/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.rpm.core.IRPMConstants;
import org.eclipse.linuxtools.rpm.core.Messages;
import org.eclipse.linuxtools.rpm.core.RPMConfiguration;
import org.eclipse.linuxtools.rpm.core.RPMProjectNature;
import org.eclipse.linuxtools.rpm.core.SourceRPM;
import org.eclipse.linuxtools.rpm.core.utils.RPM;
import org.eclipse.linuxtools.rpm.core.utils.RPMBuild;

public class RPMProject {
    private IProject project;
    private SourceRPM sourceRPM;
    private RPMConfiguration rpmConfig;

    public RPMProject(IProject project) throws CoreException {
        this.project = project;
        this.rpmConfig = new RPMConfiguration(this.project);
    }

    public IProject getProject() {
        return this.project;
    }

    public SourceRPM getSourceRPM() {
        return this.sourceRPM;
    }

    public void setSourceRPM(SourceRPM sourceRPM) throws CoreException {
        this.sourceRPM = sourceRPM;
        this.getProject().setPersistentProperty(new QualifiedName("org.eclipse.linuxtools.rpm.core", "SRPM_PROPERTY"), sourceRPM.getFile().getName());
    }

    public RPMConfiguration getConfiguration() {
        return this.rpmConfig;
    }

    public IFile getSpecFile() {
        IFolder specsFolder = this.getConfiguration().getSpecsFolder();
        IFile file = null;
        try {
            file = specsFolder.getFile(specsFolder.members()[0].getName());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return file;
    }

    public void setSpecFile(IFile specFile) throws CoreException {
        this.getProject().setPersistentProperty(new QualifiedName("org.eclipse.linuxtools.rpm.core", "SPEC_FILE_PROPERTY"), specFile.getName());
    }

    public void importSourceRPM(File externalFile) throws CoreException {
        IFile srpmFile = this.getConfiguration().getSrpmsFolder().getFile(externalFile.getName());
        try {
            srpmFile.create((InputStream)new FileInputStream(externalFile), false, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String throw_message = String.valueOf(Messages.getString("RPMCore.Error_trying_to_copy__")) + this.rpmConfig.getSpecsFolder().getLocation().toOSString();
            Status error = new Status(4, IRPMConstants.ERROR, 1, throw_message, null);
            throw new CoreException((IStatus)error);
        }
        this.setSourceRPM(new SourceRPM(srpmFile));
        RPM rpm = new RPM(this.getConfiguration());
        rpm.install(this.getSourceRPM().getFile());
        this.getProject().refreshLocal(2, null);
        IResource[] installedSpecs = this.getConfiguration().getSpecsFolder().members();
        if (installedSpecs.length != 1) {
            String throw_message = String.valueOf(Messages.getString("RPMCore.spec_file_ambiguous")) + this.rpmConfig.getSpecsFolder().getLocation().toOSString();
            Status error = new Status(4, IRPMConstants.ERROR, 1, throw_message, null);
            throw new CoreException((IStatus)error);
        }
        this.setSpecFile(this.getConfiguration().getSpecsFolder().getFile(installedSpecs[0].getName()));
        RPMProjectNature.addRPMNature(this.getProject(), null);
    }

    public void buildAll(OutputStream outStream) throws CoreException {
        RPMBuild rpmbuild = new RPMBuild(this.getConfiguration());
        rpmbuild.buildAll(this.getSpecFile(), outStream);
        this.getConfiguration().getBuildFolder().refreshLocal(2, null);
        this.getConfiguration().getRpmsFolder().refreshLocal(2, null);
        this.getConfiguration().getSrpmsFolder().refreshLocal(2, null);
    }

    public void buildBinaryRPM(OutputStream out) throws CoreException {
        RPMBuild rpmbuild = new RPMBuild(this.getConfiguration());
        rpmbuild.buildBinary(this.getSpecFile(), out);
        this.getConfiguration().getBuildFolder().refreshLocal(2, null);
        this.getConfiguration().getRpmsFolder().refreshLocal(2, null);
    }

    public void buildSourceRPM(OutputStream out) throws CoreException {
        RPMBuild rpmbuild = new RPMBuild(this.getConfiguration());
        rpmbuild.buildSource(this.getSpecFile(), out);
        this.getConfiguration().getBuildFolder().refreshLocal(2, null);
        this.getConfiguration().getSrpmsFolder().refreshLocal(2, null);
    }

    public void buildPrep(OutputStream out) throws CoreException {
        RPMBuild rpmbuild = new RPMBuild(this.getConfiguration());
        rpmbuild.buildPrep(this.getSpecFile(), out);
        this.getConfiguration().getBuildFolder().refreshLocal(2, null);
    }
}

