/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui.editor.forms;

import org.eclipse.linuxtools.rpm.ui.editor.forms.Messages;
import org.eclipse.linuxtools.rpm.ui.editor.forms.RpmTagText;
import org.eclipse.linuxtools.rpm.ui.editor.forms.SpecfileFormEditor;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfilePackage;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileTag;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class MainPackagePage
extends FormPage {
    private FormToolkit toolkit;
    private ScrolledForm form;
    private Specfile specfile;

    public MainPackagePage(SpecfileFormEditor editor, Specfile specfile) {
        super((FormEditor)editor, Messages.MainPackagePage_0, Messages.MainPackagePage_1);
        this.specfile = specfile;
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.toolkit = managedForm.getToolkit();
        this.form = managedForm.getForm();
        this.form.setText(Messages.MainPackagePage_2);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.numColumns = 2;
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.justify = true;
        rowLayout.fill = true;
        this.form.getBody().setLayout((Layout)rowLayout);
        this.form.getBody().setLayoutData((Object)rowLayout);
        layout.numColumns = 2;
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 4;
        Section mainPackageSection = this.toolkit.createSection(this.form.getBody(), 322);
        mainPackageSection.setText(Messages.MainPackagePage_3);
        mainPackageSection.setLayout((Layout)new GridLayout());
        Composite mainPackageClient = this.toolkit.createComposite((Composite)mainPackageSection);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 5;
        gridLayout.numColumns = 2;
        mainPackageClient.setLayout((Layout)gridLayout);
        new RpmTagText(mainPackageClient, "Name", this.specfile);
        new RpmTagText(mainPackageClient, "Version", this.specfile);
        new RpmTagText(mainPackageClient, "Release", this.specfile);
        new RpmTagText(mainPackageClient, "URL", this.specfile);
        new RpmTagText(mainPackageClient, "License", this.specfile);
        new RpmTagText(mainPackageClient, "Group", this.specfile);
        new RpmTagText(mainPackageClient, "Epoch", this.specfile);
        new RpmTagText(mainPackageClient, "BuildRoot", this.specfile);
        new RpmTagText(mainPackageClient, "BuildArch", this.specfile);
        new RpmTagText(mainPackageClient, "Summary", this.specfile, 2);
        Section buildRequiresSection = this.toolkit.createSection(mainPackageClient, 322);
        buildRequiresSection.setText(Messages.MainPackagePage_4);
        buildRequiresSection.setLayout((Layout)rowLayout);
        buildRequiresSection.setExpanded(false);
        Composite buildRequiresClient = this.toolkit.createComposite((Composite)buildRequiresSection);
        buildRequiresClient.setLayout((Layout)gridLayout);
        for (SpecfileTag buildRequire : this.specfile.getBuildRequires()) {
            new RpmTagText(buildRequiresClient, buildRequire, this.specfile);
        }
        buildRequiresSection.setClient((Control)buildRequiresClient);
        this.toolkit.paintBordersFor(buildRequiresClient);
        this.toolkit.paintBordersFor((Composite)buildRequiresSection);
        Section requiresSection = this.toolkit.createSection(mainPackageClient, 322);
        requiresSection.setText(Messages.MainPackagePage_5);
        requiresSection.setLayout((Layout)rowLayout);
        requiresSection.setExpanded(false);
        Composite requiresClient = this.toolkit.createComposite((Composite)requiresSection);
        requiresClient.setLayout((Layout)gridLayout);
        requiresClient.setLayoutData((Object)gd);
        for (SpecfileTag require : this.specfile.getRequires()) {
            new RpmTagText(requiresClient, require, this.specfile);
        }
        requiresSection.setClient((Control)requiresClient);
        this.toolkit.paintBordersFor(requiresClient);
        this.toolkit.paintBordersFor((Composite)requiresSection);
        mainPackageSection.setClient((Control)mainPackageClient);
        this.toolkit.paintBordersFor(mainPackageClient);
        this.toolkit.paintBordersFor((Composite)mainPackageSection);
        Section packagesSection = this.toolkit.createSection(this.form.getBody(), 322);
        packagesSection.setText(Messages.MainPackagePage_6);
        packagesSection.setLayout((Layout)gridLayout);
        Composite packagesClient = this.toolkit.createComposite((Composite)packagesSection);
        packagesClient.setLayout((Layout)gridLayout);
        packagesClient.setLayoutData((Object)gd);
        SpecfilePackage[] specfilePackageArray = this.specfile.getPackages().getPackages();
        int n = specfilePackageArray.length;
        int n2 = 0;
        while (n2 < n) {
            SpecfilePackage specfilePackage = specfilePackageArray[n2];
            if (!specfilePackage.isMainPackage()) {
                Section packageSection = this.toolkit.createSection(packagesClient, 322);
                packageSection.setText(specfilePackage.getFullPackageName());
                packageSection.setExpanded(false);
                packageSection.setLayout((Layout)rowLayout);
                Composite packageClient = this.toolkit.createComposite((Composite)packageSection);
                packageClient.setLayout((Layout)gridLayout);
                packageClient.setLayoutData((Object)gd);
                new RpmTagText(packageClient, "Summary", this.specfile, specfilePackage, 2);
                new RpmTagText(packageClient, "Group", this.specfile, specfilePackage, 2);
                Section packageRequiresSection = this.toolkit.createSection(packageClient, 322);
                packageRequiresSection.setText(Messages.MainPackagePage_7);
                packageRequiresSection.setLayout((Layout)rowLayout);
                packageRequiresSection.setLayoutData((Object)gd);
                Composite packageRequiresClient = this.toolkit.createComposite((Composite)packageRequiresSection);
                packageRequiresClient.setLayout((Layout)gridLayout);
                packageRequiresClient.setLayoutData((Object)gd);
                for (SpecfileTag require : specfilePackage.getRequires()) {
                    new RpmTagText(packageRequiresClient, require, this.specfile);
                }
                packageRequiresSection.setClient((Control)packageRequiresClient);
                this.toolkit.paintBordersFor(packageRequiresClient);
                this.toolkit.paintBordersFor((Composite)packageRequiresSection);
                packageSection.setClient((Control)packageClient);
                this.toolkit.paintBordersFor(packageClient);
                this.toolkit.paintBordersFor((Composite)packageSection);
            }
            ++n2;
        }
        packagesSection.setClient((Control)packagesClient);
        this.toolkit.paintBordersFor(packagesClient);
        this.toolkit.paintBordersFor((Composite)packagesSection);
        managedForm.refresh();
    }
}

