/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpmstubby;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.rpmstubby.StubbyLog;
import org.eclipse.linuxtools.rpmstubby.StubbyPlugin;
import org.eclipse.linuxtools.rpmstubby.model.PomModel;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class StubbyPomGenerator {
    private PomModel model;

    public StubbyPomGenerator(IFile pomFile) {
        this.parse(pomFile);
    }

    private void parse(IFile pomFile) {
        DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docbuilder = docfactory.newDocumentBuilder();
            Document docroot = docbuilder.parse(pomFile.getContents());
            this.model = new PomModel(docroot);
        }
        catch (ParserConfigurationException e) {
            StubbyLog.logError(e);
        }
        catch (SAXException e) {
            StubbyLog.logError(e);
        }
        catch (IOException e) {
            StubbyLog.logError(e);
        }
        catch (CoreException e) {
            StubbyLog.logError(e);
        }
    }

    public String generateSpecfile() {
        StringBuilder buffer = new StringBuilder();
        String packageName = this.model.getPackageName();
        buffer.append("Name:           " + packageName.toLowerCase() + "\n");
        buffer.append("Version:        " + this.model.getVersion() + "\n");
        buffer.append("Release:        1%{?dist}\n");
        buffer.append("Summary:        " + this.model.getSummary() + "\n\n");
        buffer.append("Group:          Development/Libraries\n");
        buffer.append("License:        " + this.model.getLicense() + "\n");
        buffer.append("URL:            " + this.model.getURL() + "\n");
        buffer.append("Source0:        #FIXME\n");
        buffer.append("BuildArch: noarch\n\n");
        this.generateRequires(buffer);
        buffer.append("\n%description\n" + this.model.getDescription() + "\n\n");
        this.generateJavadocSubpackage(buffer);
        this.generatePrepSection(buffer);
        this.generateBuildSection(buffer);
        this.generateInstallSection(buffer);
        this.generatePostPostun(buffer);
        this.generateFilesSections(buffer);
        this.generateChangelog(buffer);
        return buffer.toString();
    }

    private void generateRequires(StringBuilder buffer) {
        for (String dependency : this.model.getDependencies()) {
            buffer.append("BuildRequires: " + dependency + "\n");
        }
        for (String dependency : this.model.getDependencies()) {
            buffer.append("Requires: " + dependency + "\n");
        }
    }

    private void generateJavadocSubpackage(StringBuilder buffer) {
        buffer.append("%package javadoc\n");
        buffer.append("Group:          Documentation\n");
        buffer.append("Summary:        Javadoc for %{name}\n");
        buffer.append("Requires:       jpackage-utils\n\n");
        buffer.append("%description javadoc\n");
        buffer.append("API documentation for %{name}.\n\n");
    }

    private void generatePostPostun(StringBuilder buffer) {
        buffer.append("%post\n");
        buffer.append("%update_maven_depmap\n\n");
        buffer.append("%postun\n");
        buffer.append("%update_maven_depmap\n\n");
    }

    private void generateChangelog(StringBuilder buffer) {
        buffer.append("%changelog\n\n");
        buffer.append("#FIXME\n");
    }

    private void generateInstallSection(StringBuilder buffer) {
        buffer.append("%install\n");
        buffer.append("# jars\n");
        buffer.append("install -d -m 0755 %{buildroot}%{_javadir}\n");
        buffer.append("install -m 644 target/%{name}-%{version}.jar   %{buildroot}%{_javadir}/%{name}\n\n");
        buffer.append("%add_to_maven_depmap " + this.model.getGroupId() + " " + this.model.getArtifactId() + " %{version} JPP " + this.model.getArtifactId() + "\n\n");
        buffer.append("# poms\n");
        buffer.append("install -d -m 755 %{buildroot}%{_mavenpomdir}\n");
        buffer.append("install -pm 644 pom.xml \\\n");
        buffer.append("    %{buildroot}%{_mavenpomdir}/JPP.%{name}.pom\n\n");
        buffer.append("# javadoc\n");
        buffer.append("install -d -m 0755 %{buildroot}%{_javadocdir}/%{name}\n");
        buffer.append("cp -pr target/site/api*/* %{buildroot}%{_javadocdir}/%{name}/\n");
        buffer.append("rm -rf target/site/api*\n\n");
    }

    private void generateFilesSections(StringBuilder buffer) {
        buffer.append("%files\n");
        buffer.append("%defattr(-,root,root,-)\n");
        buffer.append("%{_javadir}/*\n");
        buffer.append("%{_mavenpomdir}/*\n");
        buffer.append("%{_mavendepmapfragdir}/*\n\n");
        buffer.append("%files javadoc\n");
        buffer.append("%defattr(-,root,root,-)\n");
        buffer.append("%{_javadocdir}/%{name}\n\n");
    }

    private void generatePrepSection(StringBuilder buffer) {
        buffer.append("\n%prep\n");
        buffer.append("%setup -q #You may need to update this according to your Source0\n\n");
    }

    private void generateBuildSection(StringBuilder buffer) {
        buffer.append("%build\n");
        buffer.append("mvn-rpmbuild \\\n");
        buffer.append("        -e \\\n");
        buffer.append("        install javadoc:javadoc\n\n");
    }

    public void writeContent(String projectName) throws CoreException {
        String fileName = String.valueOf(this.model.getPackageName().toLowerCase()) + ".spec";
        String contents = this.generateSpecfile();
        ByteArrayInputStream contentInputStream = new ByteArrayInputStream(contents.getBytes());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(projectName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Project \"" + projectName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            ByteArrayInputStream stream = contentInputStream;
            if (file.exists()) {
                file.setContents((InputStream)stream, true, true, null);
            } else {
                file.create((InputStream)stream, true, null);
            }
            ((InputStream)stream).close();
        }
        catch (IOException e) {
            StubbyLog.logError(e);
        }
        StubbyPlugin.getActiveWorkbenchShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException e) {
                    StubbyLog.logError(e);
                }
            }
        });
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.linuxtools.rpmstubby", 0, message, null);
        throw new CoreException((IStatus)status);
    }
}

