/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.wizards;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.tmf.ui.TmfUiPlugin;
import org.eclipse.linuxtools.tmf.ui.internal.Messages;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomXmlTrace;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomXmlTraceDefinition;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CustomXmlParserInputWizardPage
extends WizardPage {
    private static final String DEFAULT_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String SIMPLE_DATE_FORMAT_URL = "http://java.sun.com/javase/6/docs/api/java/text/SimpleDateFormat.html#skip-navbar_top";
    private static final Image elementImage = TmfUiPlugin.getDefault().getImageFromPath("/icons/elcl16/element_icon.gif");
    private static final Image addImage = TmfUiPlugin.getDefault().getImageFromPath("/icons/elcl16/add_button.gif");
    private static final Image addNextImage = TmfUiPlugin.getDefault().getImageFromPath("/icons/elcl16/addnext_button.gif");
    private static final Image addChildImage = TmfUiPlugin.getDefault().getImageFromPath("/icons/elcl16/addchild_button.gif");
    private static final Image addManyImage = TmfUiPlugin.getDefault().getImageFromPath("/icons/elcl16/addmany_button.gif");
    private static final Image deleteImage = TmfUiPlugin.getDefault().getImageFromPath("/icons/elcl16/delete_button.gif");
    private static final Image moveUpImage = TmfUiPlugin.getDefault().getImageFromPath("/icons/elcl16/moveup_button.gif");
    private static final Image moveDownImage = TmfUiPlugin.getDefault().getImageFromPath("/icons/elcl16/movedown_button.gif");
    private static final Image helpImage = TmfUiPlugin.getDefault().getImageFromPath("/icons/elcl16/help_button.gif");
    private static final Color COLOR_LIGHT_RED = new Color((Device)Display.getDefault(), 255, 192, 192);
    private static final Color COLOR_TEXT_BACKGROUND = Display.getCurrent().getSystemColor(1);
    private static final Color COLOR_WIDGET_BACKGROUND = Display.getCurrent().getSystemColor(22);
    private ISelection selection;
    private CustomXmlTraceDefinition definition;
    private String editDefinitionName;
    private String defaultDescription;
    private ElementNode selectedElement;
    private Composite container;
    private Text logtypeText;
    private Text timeStampOutputFormatText;
    private Text timeStampPreviewText;
    private Button removeButton;
    private Button addChildButton;
    private Button addNextButton;
    private Button moveUpButton;
    private Button moveDownButton;
    private Button feelingLuckyButton;
    private ScrolledComposite treeScrolledComposite;
    private ScrolledComposite elementScrolledComposite;
    private TreeViewer treeViewer;
    private Composite treeContainer;
    private Composite elementContainer;
    private Text errorText;
    private StyledText inputText;
    private Font fixedFont;
    private UpdateListener updateListener;
    private Browser helpBrowser;
    private Element documentElement;
    private String timeStampValue;
    private String timeStampFormat;
    private boolean timeStampFound;
    private int logEntriesCount;
    private boolean logEntryFound;
    private int logEntryNestedCount;

    protected CustomXmlParserInputWizardPage(ISelection selection, CustomXmlTraceDefinition definition) {
        super("CustomXmlParserWizardPage");
        if (definition == null) {
            this.setTitle(Messages.CustomXmlParserInputWizardPage_titleNew);
            this.defaultDescription = Messages.CustomXmlParserInputWizardPage_descriptionNew;
        } else {
            this.setTitle(Messages.CustomXmlParserInputWizardPage_titleEdit);
            this.defaultDescription = Messages.CustomXmlParserInputWizardPage_descriptionEdit;
        }
        this.setDescription(this.defaultDescription);
        this.selection = selection;
        this.definition = definition;
        if (definition != null) {
            this.editDefinitionName = definition.definitionName;
        }
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout());
        this.updateListener = new UpdateListener();
        Composite headerComposite = new Composite(this.container, 4);
        GridLayout headerLayout = new GridLayout(5, false);
        headerLayout.marginHeight = 0;
        headerLayout.marginWidth = 0;
        headerComposite.setLayout((Layout)headerLayout);
        headerComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label logtypeLabel = new Label(headerComposite, 0);
        logtypeLabel.setText(Messages.CustomXmlParserInputWizardPage_logType);
        this.logtypeText = new Text(headerComposite, 2052);
        this.logtypeText.setLayoutData((Object)new GridData(120, -1));
        Label timeStampFormatLabel = new Label(headerComposite, 0);
        timeStampFormatLabel.setText(Messages.CustomXmlParserInputWizardPage_timestampFormat);
        this.timeStampOutputFormatText = new Text(headerComposite, 2052);
        this.timeStampOutputFormatText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.timeStampOutputFormatText.setText(DEFAULT_TIMESTAMP_FORMAT);
        Button dateFormatHelpButton = new Button(headerComposite, 8);
        dateFormatHelpButton.setImage(helpImage);
        dateFormatHelpButton.setToolTipText(Messages.CustomXmlParserInputWizardPage_dateFormatHelp);
        dateFormatHelpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomXmlParserInputWizardPage.this.openHelpShell(CustomXmlParserInputWizardPage.SIMPLE_DATE_FORMAT_URL);
            }
        });
        Label timeStampPreviewLabel = new Label(headerComposite, 0);
        timeStampPreviewLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 3, 1));
        timeStampPreviewLabel.setText(Messages.CustomXmlParserInputWizardPage_preview);
        this.timeStampPreviewText = new Text(headerComposite, 2060);
        this.timeStampPreviewText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.timeStampPreviewText.setText("*no time stamp element or attribute*");
        this.createButtonBar();
        SashForm vSash = new SashForm(this.container, 512);
        vSash.setLayoutData((Object)new GridData(4, 4, true, true));
        vSash.setBackground(vSash.getDisplay().getSystemColor(15));
        SashForm hSash = new SashForm((Composite)vSash, 256);
        hSash.setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeScrolledComposite = new ScrolledComposite((Composite)hSash, 768);
        this.treeScrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeContainer = new Composite((Composite)this.treeScrolledComposite, 0);
        this.treeContainer.setLayout((Layout)new FillLayout());
        this.treeScrolledComposite.setContent((Control)this.treeContainer);
        this.treeScrolledComposite.setExpandHorizontal(true);
        this.treeScrolledComposite.setExpandVertical(true);
        this.treeViewer = new TreeViewer(this.treeContainer, 2052);
        this.treeViewer.setContentProvider((IContentProvider)new InputElementTreeNodeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new InputElementTreeLabelProvider());
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)new InputElementTreeSelectionChangedListener());
        this.treeContainer.layout();
        this.treeScrolledComposite.setMinSize(this.treeContainer.computeSize((int)-1, (int)-1).x, this.treeContainer.computeSize((int)-1, (int)-1).y);
        this.elementScrolledComposite = new ScrolledComposite((Composite)hSash, 512);
        this.elementScrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.elementContainer = new Composite((Composite)this.elementScrolledComposite, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 1;
        gl.marginWidth = 0;
        this.elementContainer.setLayout((Layout)gl);
        this.elementScrolledComposite.setContent((Control)this.elementContainer);
        this.elementScrolledComposite.setExpandHorizontal(true);
        this.elementScrolledComposite.setExpandVertical(true);
        if (this.definition == null) {
            this.definition = new CustomXmlTraceDefinition();
        }
        this.loadDefinition(this.definition);
        this.treeViewer.expandAll();
        this.elementContainer.layout();
        this.logtypeText.addModifyListener((ModifyListener)this.updateListener);
        this.timeStampOutputFormatText.addModifyListener((ModifyListener)this.updateListener);
        this.elementScrolledComposite.setMinSize(this.elementContainer.computeSize((int)-1, (int)-1).x, this.elementContainer.computeSize((int)-1, (int)-1).y - 1);
        hSash.setWeights(new int[]{1, 2});
        if (this.definition.rootInputElement == null) {
            this.removeButton.setEnabled(false);
            this.addChildButton.setToolTipText(Messages.CustomXmlParserInputWizardPage_addDocumentElement);
            this.addNextButton.setEnabled(false);
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
        } else {
            this.addNextButton.setEnabled(false);
        }
        Composite sashBottom = new Composite((Composite)vSash, 0);
        GridLayout sashBottomLayout = new GridLayout(2, false);
        sashBottomLayout.marginHeight = 0;
        sashBottomLayout.marginWidth = 0;
        sashBottom.setLayout((Layout)sashBottomLayout);
        Label previewLabel = new Label(sashBottom, 0);
        previewLabel.setText(Messages.CustomXmlParserInputWizardPage_previewInput);
        this.errorText = new Text(sashBottom, 12);
        this.errorText.setBackground(COLOR_WIDGET_BACKGROUND);
        this.errorText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.errorText.setVisible(false);
        this.inputText = new StyledText(sashBottom, 770);
        if (this.fixedFont == null) {
            this.fixedFont = System.getProperty("os.name").contains("Windows") ? new Font((Device)Display.getCurrent(), new FontData("Courier New", 10, 0)) : new Font((Device)Display.getCurrent(), new FontData("Monospace", 10, 0));
        }
        this.inputText.setFont(this.fixedFont);
        GridData gd = new GridData(4, 4, true, true, 2, 1);
        gd.heightHint = this.inputText.computeSize((int)-1, (int)(this.inputText.getLineHeight() * 4)).y;
        gd.widthHint = 800;
        this.inputText.setLayoutData((Object)gd);
        this.inputText.setText(this.getSelectionText());
        this.inputText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CustomXmlParserInputWizardPage.this.parseXmlInput(CustomXmlParserInputWizardPage.this.inputText.getText());
            }
        });
        this.inputText.addModifyListener((ModifyListener)this.updateListener);
        vSash.setWeights(new int[]{hSash.computeSize((int)-1, (int)-1).y, sashBottom.computeSize((int)-1, (int)-1).y});
        this.setControl((Control)this.container);
    }

    private void createButtonBar() {
        Composite buttonBar = new Composite(this.container, 0);
        GridLayout buttonBarLayout = new GridLayout(6, false);
        buttonBarLayout.marginHeight = 0;
        buttonBarLayout.marginWidth = 0;
        buttonBar.setLayout((Layout)buttonBarLayout);
        this.removeButton = new Button(buttonBar, 8);
        this.removeButton.setImage(deleteImage);
        this.removeButton.setToolTipText(Messages.CustomXmlParserInputWizardPage_removeElement);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CustomXmlParserInputWizardPage.this.treeViewer.getSelection().isEmpty() || CustomXmlParserInputWizardPage.this.selectedElement == null) {
                    return;
                }
                CustomXmlParserInputWizardPage.this.removeElement();
                CustomXmlTraceDefinition.InputElement inputElement = (CustomXmlTraceDefinition.InputElement)((IStructuredSelection)CustomXmlParserInputWizardPage.this.treeViewer.getSelection()).getFirstElement();
                if (inputElement == ((CustomXmlParserInputWizardPage)CustomXmlParserInputWizardPage.this).definition.rootInputElement) {
                    ((CustomXmlParserInputWizardPage)CustomXmlParserInputWizardPage.this).definition.rootInputElement = null;
                } else {
                    inputElement.parentElement.childElements.remove(inputElement);
                }
                CustomXmlParserInputWizardPage.this.treeViewer.refresh();
                CustomXmlParserInputWizardPage.this.validate();
                CustomXmlParserInputWizardPage.this.updatePreviews();
                CustomXmlParserInputWizardPage.this.removeButton.setEnabled(false);
                if (((CustomXmlParserInputWizardPage)CustomXmlParserInputWizardPage.this).definition.rootInputElement == null) {
                    CustomXmlParserInputWizardPage.this.addChildButton.setEnabled(true);
                    CustomXmlParserInputWizardPage.this.addChildButton.setToolTipText(Messages.CustomXmlParserInputWizardPage_addDocumentEleemnt);
                } else {
                    CustomXmlParserInputWizardPage.this.addChildButton.setEnabled(false);
                }
                CustomXmlParserInputWizardPage.this.addNextButton.setEnabled(false);
                CustomXmlParserInputWizardPage.this.moveUpButton.setEnabled(false);
                CustomXmlParserInputWizardPage.this.moveDownButton.setEnabled(false);
            }
        });
        this.addChildButton = new Button(buttonBar, 8);
        this.addChildButton.setImage(addChildImage);
        this.addChildButton.setToolTipText(Messages.CustomXmlParserInputWizardPage_addChildElement);
        this.addChildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomXmlTraceDefinition.InputElement inputElement = new CustomXmlTraceDefinition.InputElement("", false, CustomXmlTraceDefinition.TAG_IGNORE, 0, "", null);
                if (((CustomXmlParserInputWizardPage)CustomXmlParserInputWizardPage.this).definition.rootInputElement == null) {
                    ((CustomXmlParserInputWizardPage)CustomXmlParserInputWizardPage.this).definition.rootInputElement = inputElement;
                    inputElement.elementName = CustomXmlParserInputWizardPage.this.getChildNameSuggestion(null);
                } else {
                    if (CustomXmlParserInputWizardPage.this.treeViewer.getSelection().isEmpty()) {
                        return;
                    }
                    CustomXmlTraceDefinition.InputElement parentInputElement = (CustomXmlTraceDefinition.InputElement)((IStructuredSelection)CustomXmlParserInputWizardPage.this.treeViewer.getSelection()).getFirstElement();
                    parentInputElement.addChild(inputElement);
                    inputElement.elementName = CustomXmlParserInputWizardPage.this.getChildNameSuggestion(parentInputElement);
                }
                CustomXmlParserInputWizardPage.this.treeViewer.refresh();
                CustomXmlParserInputWizardPage.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)inputElement), true);
            }
        });
        this.addNextButton = new Button(buttonBar, 8);
        this.addNextButton.setImage(addNextImage);
        this.addNextButton.setToolTipText(Messages.CustomXmlParserInputWizardPage_addNextElement);
        this.addNextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomXmlTraceDefinition.InputElement inputElement = new CustomXmlTraceDefinition.InputElement("", false, CustomXmlTraceDefinition.TAG_IGNORE, 0, "", null);
                if (((CustomXmlParserInputWizardPage)CustomXmlParserInputWizardPage.this).definition.rootInputElement == null) {
                    ((CustomXmlParserInputWizardPage)CustomXmlParserInputWizardPage.this).definition.rootInputElement = inputElement;
                    inputElement.elementName = CustomXmlParserInputWizardPage.this.getChildNameSuggestion(null);
                } else {
                    if (CustomXmlParserInputWizardPage.this.treeViewer.getSelection().isEmpty()) {
                        return;
                    }
                    CustomXmlTraceDefinition.InputElement previousInputElement = (CustomXmlTraceDefinition.InputElement)((IStructuredSelection)CustomXmlParserInputWizardPage.this.treeViewer.getSelection()).getFirstElement();
                    if (previousInputElement == ((CustomXmlParserInputWizardPage)CustomXmlParserInputWizardPage.this).definition.rootInputElement) {
                        return;
                    }
                    previousInputElement.addNext(inputElement);
                    inputElement.elementName = CustomXmlParserInputWizardPage.this.getChildNameSuggestion(inputElement.parentElement);
                }
                CustomXmlParserInputWizardPage.this.treeViewer.refresh();
                CustomXmlParserInputWizardPage.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)inputElement), true);
            }
        });
        this.feelingLuckyButton = new Button(buttonBar, 8);
        this.feelingLuckyButton.setImage(addManyImage);
        this.feelingLuckyButton.setToolTipText(Messages.CustomXmlParserInputWizardPage_feelingLucky);
        this.feelingLuckyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomXmlTraceDefinition.InputElement inputElement = null;
                if (((CustomXmlParserInputWizardPage)CustomXmlParserInputWizardPage.this).definition.rootInputElement == null) {
                    if (CustomXmlParserInputWizardPage.this.getChildNameSuggestion(null).length() != 0) {
                        ((CustomXmlParserInputWizardPage)CustomXmlParserInputWizardPage.this).definition.rootInputElement = inputElement = new CustomXmlTraceDefinition.InputElement(CustomXmlParserInputWizardPage.this.getChildNameSuggestion(null), false, CustomXmlTraceDefinition.TAG_IGNORE, 0, "", null);
                        CustomXmlParserInputWizardPage.this.feelingLucky(inputElement);
                    }
                } else {
                    if (CustomXmlParserInputWizardPage.this.treeViewer.getSelection().isEmpty()) {
                        return;
                    }
                    inputElement = (CustomXmlTraceDefinition.InputElement)((IStructuredSelection)CustomXmlParserInputWizardPage.this.treeViewer.getSelection()).getFirstElement();
                    CustomXmlParserInputWizardPage.this.feelingLucky(inputElement);
                }
                CustomXmlParserInputWizardPage.this.treeViewer.refresh();
                CustomXmlParserInputWizardPage.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)inputElement), true);
                CustomXmlParserInputWizardPage.this.treeViewer.expandToLevel((Object)inputElement, -1);
            }
        });
        this.moveUpButton = new Button(buttonBar, 8);
        this.moveUpButton.setImage(moveUpImage);
        this.moveUpButton.setToolTipText(Messages.CustomXmlParserInputWizardPage_moveUp);
        this.moveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CustomXmlParserInputWizardPage.this.treeViewer.getSelection().isEmpty()) {
                    return;
                }
                CustomXmlTraceDefinition.InputElement inputElement = (CustomXmlTraceDefinition.InputElement)((IStructuredSelection)CustomXmlParserInputWizardPage.this.treeViewer.getSelection()).getFirstElement();
                if (inputElement == ((CustomXmlParserInputWizardPage)CustomXmlParserInputWizardPage.this).definition.rootInputElement) {
                    return;
                }
                inputElement.moveUp();
                CustomXmlParserInputWizardPage.this.treeViewer.refresh();
                CustomXmlParserInputWizardPage.this.validate();
                CustomXmlParserInputWizardPage.this.updatePreviews();
            }
        });
        this.moveDownButton = new Button(buttonBar, 8);
        this.moveDownButton.setImage(moveDownImage);
        this.moveDownButton.setToolTipText(Messages.CustomXmlParserInputWizardPage_moveDown);
        this.moveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CustomXmlParserInputWizardPage.this.treeViewer.getSelection().isEmpty()) {
                    return;
                }
                CustomXmlTraceDefinition.InputElement inputElement = (CustomXmlTraceDefinition.InputElement)((IStructuredSelection)CustomXmlParserInputWizardPage.this.treeViewer.getSelection()).getFirstElement();
                if (inputElement == ((CustomXmlParserInputWizardPage)CustomXmlParserInputWizardPage.this).definition.rootInputElement) {
                    return;
                }
                inputElement.moveDown();
                CustomXmlParserInputWizardPage.this.treeViewer.refresh();
                CustomXmlParserInputWizardPage.this.validate();
                CustomXmlParserInputWizardPage.this.updatePreviews();
            }
        });
    }

    private void feelingLucky(CustomXmlTraceDefinition.InputElement inputElement) {
        String childName;
        String attributeName;
        while ((attributeName = this.getAttributeNameSuggestion(inputElement)).length() != 0) {
            CustomXmlTraceDefinition.InputAttribute attribute = new CustomXmlTraceDefinition.InputAttribute(attributeName, attributeName, 0, "");
            inputElement.addAttribute(attribute);
        }
        while ((childName = this.getChildNameSuggestion(inputElement)).length() != 0) {
            CustomXmlTraceDefinition.InputElement childElement = new CustomXmlTraceDefinition.InputElement(childName, false, CustomXmlTraceDefinition.TAG_IGNORE, 0, "", null);
            inputElement.addChild(childElement);
            this.feelingLucky(childElement);
        }
    }

    public void dispose() {
        if (this.fixedFont != null) {
            this.fixedFont.dispose();
            this.fixedFont = null;
        }
        super.dispose();
    }

    private void loadDefinition(CustomXmlTraceDefinition def) {
        this.logtypeText.setText(def.definitionName);
        this.timeStampOutputFormatText.setText(def.timeStampOutputFormat);
        this.treeViewer.setInput((Object)def);
        if (def.rootInputElement != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)def.rootInputElement));
        }
    }

    private String getName(CustomXmlTraceDefinition.InputElement inputElement) {
        String name;
        String string = name = inputElement.elementName.trim().length() == 0 ? "?" : inputElement.elementName.trim();
        if (inputElement.parentElement == null) {
            return name;
        }
        return String.valueOf(this.getName(inputElement.parentElement)) + " : " + name;
    }

    private String getName(CustomXmlTraceDefinition.InputAttribute inputAttribute, CustomXmlTraceDefinition.InputElement inputElement) {
        String name = inputAttribute.attributeName.trim().length() == 0 ? "?" : inputAttribute.attributeName.trim();
        return String.valueOf(this.getName(inputElement)) + " : " + name;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.validate();
            this.updatePreviews();
        }
        super.setVisible(visible);
    }

    public List<String> getInputNames() {
        return this.getInputNames(this.definition.rootInputElement);
    }

    public List<String> getInputNames(CustomXmlTraceDefinition.InputElement inputElement) {
        String inputName;
        ArrayList<String> inputs = new ArrayList<String>();
        if (inputElement.inputName != null && !inputElement.inputName.equals(CustomXmlTraceDefinition.TAG_IGNORE) && !inputs.contains(inputName = inputElement.inputName)) {
            inputs.add(inputName);
        }
        if (inputElement.attributes != null) {
            for (CustomXmlTraceDefinition.InputAttribute attribute : inputElement.attributes) {
                String inputName2 = attribute.inputName;
                if (inputs.contains(inputName2)) continue;
                inputs.add(inputName2);
            }
        }
        if (inputElement.childElements != null) {
            for (CustomXmlTraceDefinition.InputElement childInputElement : inputElement.childElements) {
                for (String inputName2 : this.getInputNames(childInputElement)) {
                    if (inputs.contains(inputName2)) continue;
                    inputs.add(inputName2);
                }
            }
        }
        return inputs;
    }

    private void removeElement() {
        this.selectedElement.dispose();
        this.selectedElement = null;
        this.elementContainer.layout();
        this.elementScrolledComposite.setMinSize(this.elementContainer.computeSize((int)-1, (int)-1).x, this.elementContainer.computeSize((int)-1, (int)-1).y - 1);
        this.container.layout();
    }

    private String getSelectionText() {
        Object selection;
        InputStream inputStream = null;
        if (this.selection instanceof IStructuredSelection && (selection = ((IStructuredSelection)this.selection).getFirstElement()) instanceof IFile) {
            IFile file = (IFile)selection;
            try {
                inputStream = file.getContents();
            }
            catch (CoreException coreException) {
                return "";
            }
        }
        if (inputStream != null) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder sb = new StringBuilder();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    sb.append(String.valueOf(line) + "\n");
                }
                this.parseXmlInput(sb.toString());
                return sb.toString();
            }
            catch (IOException iOException) {
                return "";
            }
        }
        return "";
    }

    private void parseXmlInput(final String string) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            EntityResolver resolver = new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    String empty = "";
                    ByteArrayInputStream bais = new ByteArrayInputStream(empty.getBytes());
                    return new InputSource(bais);
                }
            };
            db.setEntityResolver(resolver);
            db.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException saxparseexception) throws SAXException {
                }

                @Override
                public void warning(SAXParseException saxparseexception) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException saxparseexception) throws SAXException {
                    if (string.trim().length() != 0) {
                        CustomXmlParserInputWizardPage.this.errorText.setText(saxparseexception.getMessage());
                        CustomXmlParserInputWizardPage.this.errorText.setBackground(COLOR_LIGHT_RED);
                        CustomXmlParserInputWizardPage.this.errorText.setVisible(true);
                    }
                    throw saxparseexception;
                }
            });
            this.errorText.setVisible(false);
            Document doc = null;
            doc = db.parse(new ByteArrayInputStream(string.getBytes()));
            this.documentElement = doc.getDocumentElement();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            this.documentElement = null;
        }
        catch (SAXException sAXException) {
            this.documentElement = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.documentElement = null;
        }
    }

    private void updatePreviews() {
        this.updatePreviews(false);
    }

    private void updatePreviews(boolean updateAll) {
        if (this.inputText == null) {
            return;
        }
        this.inputText.setStyleRanges(new StyleRange[0]);
        if (this.selectedElement == null) {
            return;
        }
        this.timeStampValue = null;
        this.timeStampFormat = null;
        this.logEntriesCount = 0;
        this.logEntryFound = false;
        this.selectedElement.updatePreview();
        if (this.timeStampValue != null && this.timeStampFormat != null) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(this.timeStampFormat);
                Date date = dateFormat.parse(this.timeStampValue);
                dateFormat = new SimpleDateFormat(this.timeStampOutputFormatText.getText().trim());
                this.timeStampPreviewText.setText(dateFormat.format(date));
            }
            catch (ParseException parseException) {
                this.timeStampPreviewText.setText("*parse exception* [" + this.timeStampValue + "] <> [" + this.timeStampFormat + "]");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.timeStampPreviewText.setText("*parse exception* [Illegal Argument]");
            }
        } else {
            this.timeStampPreviewText.setText("*no matching time stamp*");
        }
    }

    private void openHelpShell(String url) {
        if (this.helpBrowser != null && !this.helpBrowser.isDisposed()) {
            this.helpBrowser.getShell().setActive();
            if (!this.helpBrowser.getUrl().equals(url)) {
                this.helpBrowser.setUrl(url);
            }
            return;
        }
        final Shell helpShell = new Shell(this.getShell(), 1264);
        helpShell.setLayout((Layout)new FillLayout());
        this.helpBrowser = new Browser((Composite)helpShell, 0);
        this.helpBrowser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
                helpShell.setText(event.title);
            }
        });
        this.helpBrowser.setBounds(0, 0, 600, 400);
        helpShell.pack();
        helpShell.open();
        this.helpBrowser.setUrl(url);
    }

    private Element getPreviewElement(CustomXmlTraceDefinition.InputElement inputElement) {
        Element element = this.documentElement;
        if (element != null) {
            if (!this.documentElement.getNodeName().equals(this.definition.rootInputElement.elementName)) {
                return null;
            }
            ArrayList<String> elementNames = new ArrayList<String>();
            while (inputElement != null) {
                elementNames.add(inputElement.elementName);
                inputElement = inputElement.parentElement;
            }
            int i = elementNames.size() - 1;
            while (--i >= 0) {
                NodeList childList = element.getChildNodes();
                element = null;
                int j = 0;
                while (j < childList.getLength()) {
                    Node child = childList.item(j);
                    if (child instanceof Element && child.getNodeName().equals(elementNames.get(i))) {
                        element = (Element)child;
                        break;
                    }
                    ++j;
                }
                if (element == null) break;
            }
            if (element != null) {
                return element;
            }
        }
        return null;
    }

    private String getChildNameSuggestion(CustomXmlTraceDefinition.InputElement inputElement) {
        if (inputElement == null) {
            if (this.documentElement != null) {
                return this.documentElement.getNodeName();
            }
        } else {
            Element element = this.getPreviewElement(inputElement);
            if (element != null) {
                NodeList childNodes = element.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node node = childNodes.item(i);
                    if (node instanceof Element) {
                        boolean unused = true;
                        if (inputElement.childElements != null) {
                            for (CustomXmlTraceDefinition.InputElement child : inputElement.childElements) {
                                if (!child.elementName.equals(node.getNodeName())) continue;
                                unused = false;
                                break;
                            }
                        }
                        if (unused) {
                            return node.getNodeName();
                        }
                    }
                    ++i;
                }
            }
        }
        return "";
    }

    private String getAttributeNameSuggestion(CustomXmlTraceDefinition.InputElement inputElement) {
        Element element = this.getPreviewElement(inputElement);
        if (element != null) {
            NamedNodeMap attributeMap = element.getAttributes();
            int i = 0;
            while (i < attributeMap.getLength()) {
                Node node = attributeMap.item(i);
                boolean unused = true;
                if (inputElement.attributes != null) {
                    for (CustomXmlTraceDefinition.InputAttribute attribute : inputElement.attributes) {
                        if (!attribute.attributeName.equals(node.getNodeName())) continue;
                        unused = false;
                        break;
                    }
                }
                if (unused) {
                    return node.getNodeName();
                }
                ++i;
            }
        }
        return "";
    }

    private void validate() {
        this.definition.definitionName = this.logtypeText.getText().trim();
        this.definition.timeStampOutputFormat = this.timeStampOutputFormatText.getText().trim();
        if (this.selectedElement != null) {
            this.selectedElement.extractInputs();
            this.treeViewer.refresh();
        }
        StringBuffer errors = new StringBuffer();
        if (this.definition.definitionName.length() == 0) {
            errors.append(Messages.CustomXmlParserInputWizardPage_emptyLogTypeError);
            this.logtypeText.setBackground(COLOR_LIGHT_RED);
        } else {
            this.logtypeText.setBackground(COLOR_TEXT_BACKGROUND);
            CustomXmlTraceDefinition[] customXmlTraceDefinitionArray = CustomXmlTraceDefinition.loadAll();
            int n = customXmlTraceDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                CustomXmlTraceDefinition def = customXmlTraceDefinitionArray[n2];
                if (this.definition.definitionName.equals(def.definitionName) && (this.editDefinitionName == null || !this.editDefinitionName.equals(this.definition.definitionName))) {
                    errors.append(Messages.CustomXmlParserInputWizardPage_duplicatelogTypeError);
                    this.logtypeText.setBackground(COLOR_LIGHT_RED);
                    break;
                }
                ++n2;
            }
        }
        if (this.definition.rootInputElement == null) {
            errors.append(Messages.CustomXmlParserInputWizardPage_noDocumentError);
        }
        if (this.definition.rootInputElement != null) {
            this.logEntryFound = false;
            this.logEntryNestedCount = 0;
            this.timeStampFound = false;
            errors.append(this.validateElement(this.definition.rootInputElement));
            if (this.definition.rootInputElement.attributes != null && this.definition.rootInputElement.attributes.size() != 0 || this.definition.rootInputElement.childElements != null && this.definition.rootInputElement.childElements.size() != 0 || errors.length() == 0) {
                if (!this.logEntryFound) {
                    errors.append(Messages.CustomXmlParserInputWizardPage_missingLogEntryError);
                }
                if (this.timeStampFound) {
                    if (this.timeStampOutputFormatText.getText().trim().length() == 0) {
                        errors.append(Messages.CustomXmlParserInputWizardPage_missingTimestampFmtError);
                        this.timeStampOutputFormatText.setBackground(COLOR_LIGHT_RED);
                    } else {
                        try {
                            new SimpleDateFormat(this.timeStampOutputFormatText.getText().trim());
                            this.timeStampOutputFormatText.setBackground(COLOR_TEXT_BACKGROUND);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            errors.append(Messages.CustomXmlParserInputWizardPage_invalidTimestampFmtError);
                            this.timeStampOutputFormatText.setBackground(COLOR_LIGHT_RED);
                        }
                    }
                } else {
                    this.timeStampPreviewText.setText(Messages.CustomXmlParserInputWizardPage_notimestamporAttributeError);
                }
            }
        } else {
            this.timeStampPreviewText.setText(Messages.CustomXmlParserInputWizardPage_notimestamporAttributeError);
        }
        if (errors.length() == 0) {
            this.setDescription(this.defaultDescription);
            this.setPageComplete(true);
        } else {
            this.setDescription(errors.toString());
            this.setPageComplete(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StringBuffer validateElement(CustomXmlTraceDefinition.InputElement inputElement) {
        StringBuffer errors;
        block58: {
            ElementNode elementNode;
            block55: {
                block57: {
                    errors = new StringBuffer();
                    elementNode = null;
                    if (this.selectedElement != null && this.selectedElement.inputElement.equals(inputElement)) {
                        elementNode = this.selectedElement;
                    }
                    if (inputElement == this.definition.rootInputElement) {
                        if (inputElement.elementName.length() == 0) {
                            errors.append(Messages.CustomXmlParserInputWizardPage_missingDocumentElementError);
                            if (elementNode != null) {
                                elementNode.elementNameText.setBackground(COLOR_LIGHT_RED);
                            }
                        } else if (elementNode != null) {
                            elementNode.elementNameText.setBackground(COLOR_TEXT_BACKGROUND);
                        }
                    }
                    if (inputElement == this.definition.rootInputElement) break block55;
                    if (inputElement.logEntry) {
                        this.logEntryFound = true;
                        ++this.logEntryNestedCount;
                    }
                    if (!inputElement.inputName.equals(CustomXmlTraceDefinition.TAG_TIMESTAMP)) break block57;
                    this.timeStampFound = true;
                    if (inputElement.inputFormat.length() == 0) {
                        errors.append(String.valueOf(Messages.CustomXmlParserInputWizardPage_timestampFormatPrompt) + " (" + Messages.CustomXmlParserInputWizardPage_timestampElementPrompt + " " + this.getName(inputElement) + "). ");
                        if (elementNode != null) {
                            elementNode.tagText.setBackground(COLOR_LIGHT_RED);
                        }
                        break block55;
                    } else {
                        try {
                            new SimpleDateFormat(inputElement.inputFormat);
                            if (elementNode != null) {
                                elementNode.tagText.setBackground(COLOR_TEXT_BACKGROUND);
                            }
                            break block55;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            errors.append(String.valueOf(Messages.CustomXmlParserInputWizardPage_invalidTimestampFmtError) + " (" + Messages.CustomXmlParserInputWizardPage_timestampElementPrompt + " " + this.getName(inputElement) + "). ");
                            if (elementNode != null) {
                                elementNode.tagText.setBackground(COLOR_LIGHT_RED);
                            }
                            break block55;
                        }
                    }
                }
                if (inputElement.inputName.length() == 0) {
                    errors.append(Messages.CustomXmlParserInputWizardPage_missingInputElementNameError);
                    if (elementNode != null) {
                        elementNode.tagText.setBackground(COLOR_LIGHT_RED);
                    }
                } else if (elementNode != null) {
                    elementNode.tagText.setBackground(COLOR_TEXT_BACKGROUND);
                }
            }
            if (inputElement.attributes == null) break block58;
            if (elementNode != null) {
                for (Attribute attribute : elementNode.attributes) {
                    attribute.attributeNameText.setBackground(COLOR_TEXT_BACKGROUND);
                }
            }
            int i = 0;
            while (i < inputElement.attributes.size()) {
                block56: {
                    CustomXmlTraceDefinition.InputAttribute attribute;
                    block59: {
                        attribute = inputElement.attributes.get(i);
                        boolean duplicate = false;
                        int j = i + 1;
                        while (j < inputElement.attributes.size()) {
                            CustomXmlTraceDefinition.InputAttribute otherAttribute = inputElement.attributes.get(j);
                            if (otherAttribute.attributeName.equals(attribute.attributeName)) {
                                duplicate = true;
                                if (elementNode != null) {
                                    elementNode.attributes.get((int)j).attributeNameText.setBackground(COLOR_LIGHT_RED);
                                }
                            }
                            ++j;
                        }
                        if (attribute.attributeName.length() == 0) {
                            errors.append(String.valueOf(Messages.CustomXmlParserInputWizardPage_missingAttribute) + " (" + Messages.CustomXmlParserInputWizardPage_attributePrompt + " " + this.getName(inputElement) + ": ?). ");
                            if (elementNode != null) {
                                elementNode.attributes.get((int)i).attributeNameText.setBackground(COLOR_LIGHT_RED);
                            }
                        } else if (duplicate) {
                            errors.append(String.valueOf(Messages.CustomXmlParserInputWizardPage_duplicateAttributeError) + " (" + Messages.CustomXmlParserInputWizardPage_attributePrompt + " " + this.getName(attribute, inputElement) + "). ");
                            if (elementNode != null) {
                                elementNode.attributes.get((int)i).attributeNameText.setBackground(COLOR_LIGHT_RED);
                            }
                        }
                        if (!attribute.inputName.equals(CustomXmlTraceDefinition.TAG_TIMESTAMP)) break block59;
                        this.timeStampFound = true;
                        if (attribute.inputFormat.length() == 0) {
                            errors.append(String.valueOf(Messages.CustomXmlParserInputWizardPage_missingTimestampInFmtError) + " (" + Messages.CustomXmlParserInputWizardPage_attributePrompt + " " + this.getName(attribute, inputElement) + "). ");
                            if (elementNode != null) {
                                elementNode.attributes.get((int)i).tagText.setBackground(COLOR_LIGHT_RED);
                            }
                            break block56;
                        } else {
                            try {
                                new SimpleDateFormat(attribute.inputFormat);
                                if (elementNode != null) {
                                    elementNode.attributes.get((int)i).tagText.setBackground(COLOR_TEXT_BACKGROUND);
                                }
                                break block56;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                errors.append(String.valueOf(Messages.CustomXmlParserInputWizardPage_invalidTimestampInFmtError) + " (" + Messages.CustomXmlParserInputWizardPage_attributePrompt + " " + this.getName(attribute, inputElement) + "). ");
                                if (elementNode != null) {
                                    elementNode.attributes.get((int)i).tagText.setBackground(COLOR_LIGHT_RED);
                                }
                                break block56;
                            }
                        }
                    }
                    if (attribute.inputName.length() == 0) {
                        errors.append(String.valueOf(Messages.CustomXmlParserInputWizardPage_missingDataGroupNameError) + " (" + Messages.CustomXmlParserInputWizardPage_attributePrompt + " " + this.getName(attribute, inputElement) + "). ");
                        if (elementNode != null) {
                            elementNode.attributes.get((int)i).tagText.setBackground(COLOR_LIGHT_RED);
                        }
                    } else if (elementNode != null) {
                        elementNode.attributes.get((int)i).tagText.setBackground(COLOR_TEXT_BACKGROUND);
                    }
                }
                ++i;
            }
        }
        if (inputElement.childElements != null) {
            for (CustomXmlTraceDefinition.InputElement child : inputElement.childElements) {
                ElementNode childElementNode = null;
                if (this.selectedElement != null && this.selectedElement.inputElement.equals(child)) {
                    childElementNode = this.selectedElement;
                }
                if (childElementNode == null) continue;
                childElementNode.elementNameText.setBackground(COLOR_TEXT_BACKGROUND);
            }
            int i = 0;
            while (i < inputElement.childElements.size()) {
                CustomXmlTraceDefinition.InputElement child = inputElement.childElements.get(i);
                ElementNode childElementNode = null;
                if (this.selectedElement != null && this.selectedElement.inputElement.equals(child)) {
                    childElementNode = this.selectedElement;
                }
                if (child.elementName.length() == 0) {
                    errors.append(String.valueOf(Messages.CustomXmlParserInputWizardPage_missingElementNameError) + " (" + Messages.CustomXmlParserInputWizardPage_attributePrompt + " " + this.getName(child) + "). ");
                    if (childElementNode != null) {
                        childElementNode.elementNameText.setBackground(COLOR_LIGHT_RED);
                    }
                } else {
                    boolean duplicate = false;
                    int j = i + 1;
                    while (j < inputElement.childElements.size()) {
                        CustomXmlTraceDefinition.InputElement otherChild = inputElement.childElements.get(j);
                        if (otherChild.elementName.equals(child.elementName)) {
                            duplicate = true;
                            ElementNode otherChildElementNode = null;
                            if (this.selectedElement != null && this.selectedElement.inputElement.equals(otherChild)) {
                                otherChildElementNode = this.selectedElement;
                            }
                            if (otherChildElementNode != null) {
                                otherChildElementNode.elementNameText.setBackground(COLOR_LIGHT_RED);
                            }
                        }
                        ++j;
                    }
                    if (duplicate) {
                        errors.append(String.valueOf(Messages.CustomXmlParserInputWizardPage_duplicateElementNameError) + " (" + Messages.CustomXmlParserInputWizardPage_attributePrompt + " " + this.getName(child) + "). ");
                        if (childElementNode != null) {
                            childElementNode.elementNameText.setBackground(COLOR_LIGHT_RED);
                        }
                    }
                }
                errors.append(this.validateElement(child));
                ++i;
            }
        }
        if (inputElement.logEntry) {
            --this.logEntryNestedCount;
        }
        return errors;
    }

    public CustomXmlTraceDefinition getDefinition() {
        return this.definition;
    }

    public char[] getInputText() {
        return this.inputText.getText().toCharArray();
    }

    private class Attribute {
        ElementNode element;
        int attributeNumber;
        Composite labelComposite;
        Composite attributeComposite;
        Label filler;
        Composite tagComposite;
        Label attributeLabel;
        Text attributeNameText;
        Text previewText;
        Combo tagCombo;
        Label tagLabel;
        Text tagText;
        Combo actionCombo;

        public Attribute(Composite parent, ElementNode element, CustomXmlTraceDefinition.InputAttribute inputAttribute, int attributeNumber) {
            this.element = element;
            this.attributeNumber = attributeNumber;
            this.labelComposite = new Composite(parent, 4);
            GridLayout labelLayout = new GridLayout(2, false);
            labelLayout.marginWidth = 0;
            labelLayout.marginHeight = 0;
            this.labelComposite.setLayout((Layout)labelLayout);
            this.labelComposite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            Button deleteButton = new Button(this.labelComposite, 8);
            deleteButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            deleteButton.setImage(deleteImage);
            deleteButton.setToolTipText(Messages.CustomXmlParserInputWizardPage_removeAttribute);
            deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Attribute.this.element.removeAttribute(Attribute.this.attributeNumber);
                    CustomXmlParserInputWizardPage.this.validate();
                    CustomXmlParserInputWizardPage.this.updatePreviews();
                }
            });
            this.attributeLabel = new Label(this.labelComposite, 0);
            this.attributeLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            this.attributeLabel.setText(Messages.CustomXmlParserInputWizardPage_attibute);
            this.attributeComposite = new Composite(parent, 4);
            GridLayout attributeLayout = new GridLayout(4, false);
            attributeLayout.marginWidth = 0;
            attributeLayout.marginHeight = 0;
            this.attributeComposite.setLayout((Layout)attributeLayout);
            this.attributeComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Label nameLabel = new Label(this.attributeComposite, 0);
            nameLabel.setText(Messages.CustomXmlParserInputWizardPage_name);
            this.attributeNameText = new Text(this.attributeComposite, 2052);
            this.attributeNameText.setLayoutData((Object)new GridData(120, -1));
            this.attributeNameText.setText(inputAttribute.attributeName);
            this.attributeNameText.addModifyListener((ModifyListener)CustomXmlParserInputWizardPage.this.updateListener);
            Label previewLabel = new Label(this.attributeComposite, 0);
            previewLabel.setText(Messages.CustomXmlParserInputWizardPage_preview);
            this.previewText = new Text(this.attributeComposite, 2060);
            GridData gd = new GridData(4, 0x1000000, true, false);
            gd.widthHint = 0;
            this.previewText.setLayoutData((Object)gd);
            this.previewText.setText(Messages.CustomXmlParserInputWizardPage_noMatch);
            this.previewText.setBackground(COLOR_WIDGET_BACKGROUND);
            this.filler = new Label(parent, 0);
            this.tagComposite = new Composite(parent, 4);
            GridLayout tagLayout = new GridLayout(4, false);
            tagLayout.marginWidth = 0;
            tagLayout.marginHeight = 0;
            this.tagComposite.setLayout((Layout)tagLayout);
            this.tagComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.tagCombo = new Combo(this.tagComposite, 12);
            this.tagCombo.setItems(new String[]{CustomXmlTraceDefinition.TAG_TIMESTAMP, CustomXmlTraceDefinition.TAG_MESSAGE, CustomXmlTraceDefinition.TAG_OTHER});
            this.tagCombo.select(2);
            this.tagCombo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    Attribute.this.tagText.removeModifyListener((ModifyListener)CustomXmlParserInputWizardPage.this.updateListener);
                    switch (Attribute.this.tagCombo.getSelectionIndex()) {
                        case 0: {
                            Attribute.this.tagLabel.setText(Messages.CustomXmlParserInputWizardPage_format);
                            Attribute.this.tagLabel.setVisible(true);
                            Attribute.this.tagText.setVisible(true);
                            Attribute.this.tagText.addModifyListener((ModifyListener)CustomXmlParserInputWizardPage.this.updateListener);
                            break;
                        }
                        case 1: {
                            Attribute.this.tagLabel.setVisible(false);
                            Attribute.this.tagText.setVisible(false);
                            break;
                        }
                        case 2: {
                            Attribute.this.tagLabel.setText(Messages.CustomXmlParserInputWizardPage_tagName);
                            Attribute.this.tagLabel.setVisible(true);
                            if (Attribute.this.tagText.getText().trim().length() == 0) {
                                Attribute.this.tagText.setText(Attribute.this.attributeNameText.getText().trim());
                            }
                            Attribute.this.tagText.setVisible(true);
                            Attribute.this.tagText.addModifyListener((ModifyListener)CustomXmlParserInputWizardPage.this.updateListener);
                        }
                    }
                    Attribute.this.tagComposite.layout();
                    CustomXmlParserInputWizardPage.this.validate();
                    CustomXmlParserInputWizardPage.this.updatePreviews();
                }
            });
            this.tagLabel = new Label(this.tagComposite, 0);
            this.tagLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            this.tagText = new Text(this.tagComposite, 2052);
            gd = new GridData(4, 0x1000000, true, false);
            gd.widthHint = 0;
            this.tagText.setLayoutData((Object)gd);
            this.tagText.setText(this.attributeNameText.getText());
            this.actionCombo = new Combo(this.tagComposite, 12);
            this.actionCombo.setItems(new String[]{Messages.CustomXmlParserInputWizardPage_set, Messages.CustomXmlParserInputWizardPage_append, Messages.CustomXmlParserInputWizardPage_appendWith});
            this.actionCombo.select(inputAttribute.inputAction);
            this.actionCombo.addSelectionListener((SelectionListener)CustomXmlParserInputWizardPage.this.updateListener);
            if (inputAttribute.inputName.equals(CustomXmlTraceDefinition.TAG_TIMESTAMP)) {
                this.tagCombo.select(0);
                this.tagLabel.setText(Messages.CustomXmlParserInputWizardPage_format);
                this.tagText.setText(inputAttribute.inputFormat);
                this.tagText.addModifyListener((ModifyListener)CustomXmlParserInputWizardPage.this.updateListener);
            } else if (inputAttribute.inputName.equals(CustomXmlTraceDefinition.TAG_MESSAGE)) {
                this.tagCombo.select(1);
                this.tagLabel.setVisible(false);
                this.tagText.setVisible(false);
            } else {
                this.tagCombo.select(2);
                this.tagLabel.setText(Messages.CustomXmlParserInputWizardPage_tagName);
                this.tagText.setText(inputAttribute.inputName);
                this.tagText.addModifyListener((ModifyListener)CustomXmlParserInputWizardPage.this.updateListener);
            }
        }

        private void dispose() {
            this.labelComposite.dispose();
            this.attributeComposite.dispose();
            this.filler.dispose();
            this.tagComposite.dispose();
        }

        private void setAttributeNumber(int attributeNumber) {
            this.attributeNumber = attributeNumber;
            this.labelComposite.layout();
        }
    }

    private class ElementNode {
        final CustomXmlTraceDefinition.InputElement inputElement;
        final Group group;
        ArrayList<Attribute> attributes = new ArrayList();
        ArrayList<ElementNode> childElements = new ArrayList();
        Text elementNameText;
        Composite tagComposite;
        Combo tagCombo;
        Label tagLabel;
        Text tagText;
        Combo actionCombo;
        Label previewLabel;
        Text previewText;
        Button logEntryButton;
        Label fillerLabel;
        Composite addAttributeComposite;
        Button addAttributeButton;
        Label addAttributeLabel;

        public ElementNode(Composite parent, CustomXmlTraceDefinition.InputElement inputElement) {
            this.inputElement = inputElement;
            this.group = new Group(parent, 0);
            GridLayout gl = new GridLayout(2, false);
            gl.marginHeight = 0;
            this.group.setLayout((Layout)gl);
            this.group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.group.setText(CustomXmlParserInputWizardPage.this.getName(inputElement));
            Label label = new Label((Composite)this.group, 0);
            label.setText(Messages.CustomXmlParserInputWizardPage_elementName);
            label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            this.elementNameText = new Text((Composite)this.group, 2052);
            GridData gd = new GridData(4, 0x1000000, true, false);
            gd.widthHint = 0;
            this.elementNameText.setLayoutData((Object)gd);
            this.elementNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ElementNode.this.inputElement.elementName = ElementNode.this.elementNameText.getText().trim();
                    ElementNode.this.group.setText(CustomXmlParserInputWizardPage.this.getName(ElementNode.this.inputElement));
                }
            });
            this.elementNameText.setText(inputElement.elementName);
            this.elementNameText.addModifyListener((ModifyListener)CustomXmlParserInputWizardPage.this.updateListener);
            if (inputElement.parentElement != null) {
                this.previewLabel = new Label((Composite)this.group, 0);
                this.previewLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
                this.previewLabel.setText(Messages.CustomXmlParserInputWizardPage_preview);
                this.previewText = new Text((Composite)this.group, 2060);
                gd = new GridData(4, 0x1000000, true, false);
                gd.widthHint = 0;
                this.previewText.setLayoutData((Object)gd);
                this.previewText.setText(Messages.CustomXmlParserInputWizardPage_noMatchingElement);
                this.previewText.setBackground(COLOR_WIDGET_BACKGROUND);
                this.logEntryButton = new Button((Composite)this.group, 32);
                this.logEntryButton.setText(Messages.CustomXmlParserInputWizardPage_logEntry);
                this.logEntryButton.setSelection(inputElement.logEntry);
                this.logEntryButton.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        CustomXmlTraceDefinition.InputElement parent = ElementNode.this.inputElement.parentElement;
                        while (parent != null) {
                            parent.logEntry = false;
                            parent = parent.parentElement;
                        }
                    }
                });
                this.logEntryButton.addSelectionListener((SelectionListener)CustomXmlParserInputWizardPage.this.updateListener);
                this.tagComposite = new Composite((Composite)this.group, 4);
                GridLayout tagLayout = new GridLayout(4, false);
                tagLayout.marginWidth = 0;
                tagLayout.marginHeight = 0;
                this.tagComposite.setLayout((Layout)tagLayout);
                this.tagComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                this.tagCombo = new Combo(this.tagComposite, 12);
                this.tagCombo.setItems(new String[]{CustomXmlTraceDefinition.TAG_IGNORE, CustomXmlTraceDefinition.TAG_TIMESTAMP, CustomXmlTraceDefinition.TAG_MESSAGE, CustomXmlTraceDefinition.TAG_OTHER});
                this.tagCombo.setVisibleItemCount(this.tagCombo.getItemCount());
                this.tagCombo.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        ElementNode.this.tagText.removeModifyListener((ModifyListener)CustomXmlParserInputWizardPage.this.updateListener);
                        switch (ElementNode.this.tagCombo.getSelectionIndex()) {
                            case 0: {
                                ElementNode.this.tagLabel.setVisible(false);
                                ElementNode.this.tagText.setVisible(false);
                                ElementNode.this.actionCombo.setVisible(false);
                                break;
                            }
                            case 1: {
                                ElementNode.this.tagLabel.setText(Messages.CustomXmlParserInputWizardPage_format);
                                ElementNode.this.tagLabel.setVisible(true);
                                ElementNode.this.tagText.setVisible(true);
                                ElementNode.this.tagText.addModifyListener((ModifyListener)CustomXmlParserInputWizardPage.this.updateListener);
                                ElementNode.this.actionCombo.setVisible(true);
                                break;
                            }
                            case 2: {
                                ElementNode.this.tagLabel.setVisible(false);
                                ElementNode.this.tagText.setVisible(false);
                                ElementNode.this.actionCombo.setVisible(true);
                                break;
                            }
                            case 3: {
                                ElementNode.this.tagLabel.setText(Messages.CustomXmlParserInputWizardPage_tagName);
                                ElementNode.this.tagLabel.setVisible(true);
                                if (ElementNode.this.tagText.getText().trim().length() == 0) {
                                    ElementNode.this.tagText.setText(ElementNode.this.elementNameText.getText().trim());
                                }
                                ElementNode.this.tagText.setVisible(true);
                                ElementNode.this.tagText.addModifyListener((ModifyListener)CustomXmlParserInputWizardPage.this.updateListener);
                                ElementNode.this.actionCombo.setVisible(true);
                            }
                        }
                        ElementNode.this.tagComposite.layout();
                        CustomXmlParserInputWizardPage.this.validate();
                        CustomXmlParserInputWizardPage.this.updatePreviews();
                    }
                });
                this.tagLabel = new Label(this.tagComposite, 0);
                this.tagLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
                this.tagText = new Text(this.tagComposite, 2052);
                gd = new GridData(4, 0x1000000, true, false);
                gd.widthHint = 0;
                this.tagText.setLayoutData((Object)gd);
                this.actionCombo = new Combo(this.tagComposite, 12);
                this.actionCombo.setItems(new String[]{Messages.CustomXmlParserInputWizardPage_set, Messages.CustomXmlParserInputWizardPage_append, Messages.CustomXmlParserInputWizardPage_appendWith});
                this.actionCombo.select(inputElement.inputAction);
                this.actionCombo.addSelectionListener((SelectionListener)CustomXmlParserInputWizardPage.this.updateListener);
                if (inputElement.inputName.equals(CustomXmlTraceDefinition.TAG_IGNORE)) {
                    this.tagCombo.select(0);
                    this.tagLabel.setVisible(false);
                    this.tagText.setVisible(false);
                    this.actionCombo.setVisible(false);
                } else if (inputElement.inputName.equals(CustomXmlTraceDefinition.TAG_TIMESTAMP)) {
                    this.tagCombo.select(1);
                    this.tagLabel.setText(Messages.CustomXmlParserInputWizardPage_format);
                    this.tagText.setText(inputElement.inputFormat);
                    this.tagText.addModifyListener((ModifyListener)CustomXmlParserInputWizardPage.this.updateListener);
                } else if (inputElement.inputName.equals(CustomXmlTraceDefinition.TAG_MESSAGE)) {
                    this.tagCombo.select(2);
                    this.tagLabel.setVisible(false);
                    this.tagText.setVisible(false);
                } else {
                    this.tagCombo.select(3);
                    this.tagLabel.setText(Messages.CustomXmlParserInputWizardPage_tagName);
                    this.tagText.setText(inputElement.inputName);
                    this.tagText.addModifyListener((ModifyListener)CustomXmlParserInputWizardPage.this.updateListener);
                }
            }
            if (inputElement.attributes != null) {
                for (CustomXmlTraceDefinition.InputAttribute inputAttribute : inputElement.attributes) {
                    Attribute attribute = new Attribute((Composite)this.group, this, inputAttribute, this.attributes.size() + 1);
                    this.attributes.add(attribute);
                }
            }
            this.createAddButton();
        }

        private void updatePreview() {
            Element element = CustomXmlParserInputWizardPage.this.getPreviewElement(this.inputElement);
            if (this.inputElement.parentElement != null) {
                this.previewText.setText(Messages.CustomXmlParserInputWizardPage_noMatchingElement);
                if (element != null) {
                    String value;
                    this.previewText.setText(CustomXmlTrace.parseElement(element, new StringBuffer()).toString());
                    if (this.logEntryButton.getSelection()) {
                        if (!CustomXmlParserInputWizardPage.this.logEntryFound) {
                            CustomXmlParserInputWizardPage.this.logEntryFound = true;
                            CustomXmlParserInputWizardPage customXmlParserInputWizardPage = CustomXmlParserInputWizardPage.this;
                            customXmlParserInputWizardPage.logEntriesCount = customXmlParserInputWizardPage.logEntriesCount + 1;
                        } else {
                            this.logEntryButton.setSelection(false);
                        }
                    }
                    if (this.tagCombo.getText().equals(CustomXmlTraceDefinition.TAG_TIMESTAMP) && CustomXmlParserInputWizardPage.this.logEntriesCount <= 1 && (value = this.previewText.getText().trim()).length() != 0) {
                        if (this.actionCombo.getSelectionIndex() == 0) {
                            CustomXmlParserInputWizardPage.this.timeStampValue = value;
                            CustomXmlParserInputWizardPage.this.timeStampFormat = this.tagText.getText().trim();
                        } else if (this.actionCombo.getSelectionIndex() == 1) {
                            if (CustomXmlParserInputWizardPage.this.timeStampValue != null) {
                                CustomXmlParserInputWizardPage customXmlParserInputWizardPage = CustomXmlParserInputWizardPage.this;
                                customXmlParserInputWizardPage.timeStampValue = String.valueOf(customXmlParserInputWizardPage.timeStampValue) + value;
                                CustomXmlParserInputWizardPage customXmlParserInputWizardPage2 = CustomXmlParserInputWizardPage.this;
                                customXmlParserInputWizardPage2.timeStampFormat = String.valueOf(customXmlParserInputWizardPage2.timeStampFormat) + this.tagText.getText().trim();
                            } else {
                                CustomXmlParserInputWizardPage.this.timeStampValue = value;
                                CustomXmlParserInputWizardPage.this.timeStampFormat = this.tagText.getText().trim();
                            }
                        } else if (this.actionCombo.getSelectionIndex() == 2) {
                            if (CustomXmlParserInputWizardPage.this.timeStampValue != null) {
                                CustomXmlParserInputWizardPage customXmlParserInputWizardPage = CustomXmlParserInputWizardPage.this;
                                customXmlParserInputWizardPage.timeStampValue = String.valueOf(customXmlParserInputWizardPage.timeStampValue) + " | " + value;
                                CustomXmlParserInputWizardPage customXmlParserInputWizardPage3 = CustomXmlParserInputWizardPage.this;
                                customXmlParserInputWizardPage3.timeStampFormat = String.valueOf(customXmlParserInputWizardPage3.timeStampFormat) + " | " + this.tagText.getText().trim();
                            } else {
                                CustomXmlParserInputWizardPage.this.timeStampValue = value;
                                CustomXmlParserInputWizardPage.this.timeStampFormat = this.tagText.getText().trim();
                            }
                        }
                    }
                }
            }
            for (Attribute attribute : this.attributes) {
                if (element != null) {
                    String value = element.getAttribute(attribute.attributeNameText.getText().trim());
                    if (value.length() != 0) {
                        attribute.previewText.setText(value);
                        if (!attribute.tagCombo.getText().equals(CustomXmlTraceDefinition.TAG_TIMESTAMP) || CustomXmlParserInputWizardPage.this.logEntriesCount > 1) continue;
                        if (attribute.actionCombo.getSelectionIndex() == 0) {
                            CustomXmlParserInputWizardPage.this.timeStampValue = value;
                            CustomXmlParserInputWizardPage.this.timeStampFormat = attribute.tagText.getText().trim();
                            continue;
                        }
                        if (attribute.actionCombo.getSelectionIndex() == 1) {
                            if (CustomXmlParserInputWizardPage.this.timeStampValue != null) {
                                CustomXmlParserInputWizardPage customXmlParserInputWizardPage = CustomXmlParserInputWizardPage.this;
                                customXmlParserInputWizardPage.timeStampValue = String.valueOf(customXmlParserInputWizardPage.timeStampValue) + value;
                                CustomXmlParserInputWizardPage customXmlParserInputWizardPage4 = CustomXmlParserInputWizardPage.this;
                                customXmlParserInputWizardPage4.timeStampFormat = String.valueOf(customXmlParserInputWizardPage4.timeStampFormat) + attribute.tagText.getText().trim();
                                continue;
                            }
                            CustomXmlParserInputWizardPage.this.timeStampValue = value;
                            CustomXmlParserInputWizardPage.this.timeStampFormat = attribute.tagText.getText().trim();
                            continue;
                        }
                        if (attribute.actionCombo.getSelectionIndex() != 2) continue;
                        if (CustomXmlParserInputWizardPage.this.timeStampValue != null) {
                            CustomXmlParserInputWizardPage customXmlParserInputWizardPage = CustomXmlParserInputWizardPage.this;
                            customXmlParserInputWizardPage.timeStampValue = String.valueOf(customXmlParserInputWizardPage.timeStampValue) + " | " + value;
                            CustomXmlParserInputWizardPage customXmlParserInputWizardPage5 = CustomXmlParserInputWizardPage.this;
                            customXmlParserInputWizardPage5.timeStampFormat = String.valueOf(customXmlParserInputWizardPage5.timeStampFormat) + " | " + attribute.tagText.getText().trim();
                            continue;
                        }
                        CustomXmlParserInputWizardPage.this.timeStampValue = value;
                        CustomXmlParserInputWizardPage.this.timeStampFormat = attribute.tagText.getText().trim();
                        continue;
                    }
                    attribute.previewText.setText(Messages.CustomXmlParserInputWizardPage_noMatchingAttribute);
                    continue;
                }
                attribute.previewText.setText(Messages.CustomXmlParserInputWizardPage_noMatchingElement);
            }
            for (ElementNode child : this.childElements) {
                child.updatePreview();
            }
            if (this.logEntryButton != null && this.logEntryButton.getSelection()) {
                CustomXmlParserInputWizardPage.this.logEntryFound = false;
            }
        }

        private void createAddButton() {
            this.fillerLabel = new Label((Composite)this.group, 0);
            this.addAttributeComposite = new Composite((Composite)this.group, 0);
            this.addAttributeComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            GridLayout addAttributeLayout = new GridLayout(2, false);
            addAttributeLayout.marginHeight = 0;
            addAttributeLayout.marginWidth = 0;
            this.addAttributeComposite.setLayout((Layout)addAttributeLayout);
            this.addAttributeButton = new Button(this.addAttributeComposite, 8);
            this.addAttributeButton.setImage(addImage);
            this.addAttributeButton.setToolTipText(Messages.CustomXmlParserInputWizardPage_addAttribute);
            this.addAttributeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ElementNode.this.removeAddButton();
                    String attributeName = CustomXmlParserInputWizardPage.this.getAttributeNameSuggestion(ElementNode.this.inputElement);
                    CustomXmlTraceDefinition.InputAttribute inputAttribute = new CustomXmlTraceDefinition.InputAttribute(attributeName, attributeName, 0, "");
                    ElementNode.this.attributes.add(new Attribute((Composite)ElementNode.this.group, ElementNode.this, inputAttribute, ElementNode.this.attributes.size() + 1));
                    ElementNode.this.createAddButton();
                    CustomXmlParserInputWizardPage.this.elementContainer.layout();
                    CustomXmlParserInputWizardPage.this.elementScrolledComposite.setMinSize(((CustomXmlParserInputWizardPage)((ElementNode)ElementNode.this).CustomXmlParserInputWizardPage.this).elementContainer.computeSize((int)-1, (int)-1).x, ((CustomXmlParserInputWizardPage)((ElementNode)ElementNode.this).CustomXmlParserInputWizardPage.this).elementContainer.computeSize((int)-1, (int)-1).y - 1);
                    ElementNode.this.group.getParent().layout();
                    CustomXmlParserInputWizardPage.this.validate();
                    CustomXmlParserInputWizardPage.this.updatePreviews();
                }
            });
            this.addAttributeLabel = new Label(this.addAttributeComposite, 0);
            this.addAttributeLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.addAttributeLabel.setText(Messages.CustomXmlParserInputWizardPage_newAttibute);
        }

        private void removeAddButton() {
            this.fillerLabel.dispose();
            this.addAttributeComposite.dispose();
        }

        private void removeAttribute(int attributeNumber) {
            if (--attributeNumber < this.attributes.size()) {
                this.attributes.remove(attributeNumber).dispose();
                int i = attributeNumber;
                while (i < this.attributes.size()) {
                    this.attributes.get(i).setAttributeNumber(i + 1);
                    ++i;
                }
                CustomXmlParserInputWizardPage.this.elementContainer.layout();
                CustomXmlParserInputWizardPage.this.elementScrolledComposite.setMinSize(((CustomXmlParserInputWizardPage)CustomXmlParserInputWizardPage.this).elementContainer.computeSize((int)-1, (int)-1).x, ((CustomXmlParserInputWizardPage)CustomXmlParserInputWizardPage.this).elementContainer.computeSize((int)-1, (int)-1).y - 1);
                this.group.getParent().layout();
            }
        }

        private void dispose() {
            this.group.dispose();
        }

        private void extractInputs() {
            this.inputElement.elementName = this.elementNameText.getText().trim();
            if (this.inputElement.parentElement != null) {
                this.inputElement.logEntry = this.logEntryButton.getSelection();
                if (this.tagCombo.getText().equals(CustomXmlTraceDefinition.TAG_OTHER)) {
                    this.inputElement.inputName = this.tagText.getText().trim();
                } else {
                    this.inputElement.inputName = this.tagCombo.getText();
                    if (this.tagCombo.getText().equals(CustomXmlTraceDefinition.TAG_TIMESTAMP)) {
                        this.inputElement.inputFormat = this.tagText.getText().trim();
                    }
                }
                this.inputElement.inputAction = this.actionCombo.getSelectionIndex();
            }
            this.inputElement.attributes = new ArrayList<CustomXmlTraceDefinition.InputAttribute>(this.attributes.size());
            int i = 0;
            while (i < this.attributes.size()) {
                Attribute attribute = this.attributes.get(i);
                CustomXmlTraceDefinition.InputAttribute inputAttribute = new CustomXmlTraceDefinition.InputAttribute();
                inputAttribute.attributeName = attribute.attributeNameText.getText().trim();
                if (attribute.tagCombo.getText().equals(CustomXmlTraceDefinition.TAG_OTHER)) {
                    inputAttribute.inputName = attribute.tagText.getText().trim();
                } else {
                    inputAttribute.inputName = attribute.tagCombo.getText();
                    if (attribute.tagCombo.getText().equals(CustomXmlTraceDefinition.TAG_TIMESTAMP)) {
                        inputAttribute.inputFormat = attribute.tagText.getText().trim();
                    }
                }
                inputAttribute.inputAction = attribute.actionCombo.getSelectionIndex();
                this.inputElement.addAttribute(inputAttribute);
                ++i;
            }
        }
    }

    private class InputElementTreeLabelProvider
    extends ColumnLabelProvider {
        private InputElementTreeLabelProvider() {
        }

        public Image getImage(Object element) {
            return elementImage;
        }

        public String getText(Object element) {
            CustomXmlTraceDefinition.InputElement inputElement = (CustomXmlTraceDefinition.InputElement)element;
            return inputElement.elementName.trim().length() == 0 ? "?" : inputElement.elementName;
        }
    }

    private class InputElementTreeNodeContentProvider
    implements ITreeContentProvider {
        private InputElementTreeNodeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            CustomXmlTraceDefinition def = (CustomXmlTraceDefinition)inputElement;
            if (def.rootInputElement != null) {
                return new Object[]{def.rootInputElement};
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            CustomXmlTraceDefinition.InputElement inputElement = (CustomXmlTraceDefinition.InputElement)parentElement;
            if (inputElement.childElements == null) {
                return new CustomXmlTraceDefinition.InputElement[0];
            }
            return inputElement.childElements.toArray();
        }

        public boolean hasChildren(Object element) {
            CustomXmlTraceDefinition.InputElement inputElement = (CustomXmlTraceDefinition.InputElement)element;
            return inputElement.childElements != null && inputElement.childElements.size() > 0;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object getParent(Object element) {
            CustomXmlTraceDefinition.InputElement inputElement = (CustomXmlTraceDefinition.InputElement)element;
            return inputElement.parentElement;
        }
    }

    private class InputElementTreeSelectionChangedListener
    implements ISelectionChangedListener {
        private InputElementTreeSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (CustomXmlParserInputWizardPage.this.selectedElement != null) {
                CustomXmlParserInputWizardPage.this.selectedElement.dispose();
            }
            if (!event.getSelection().isEmpty() && event.getSelection() instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                CustomXmlTraceDefinition.InputElement inputElement = (CustomXmlTraceDefinition.InputElement)selection.getFirstElement();
                CustomXmlParserInputWizardPage.this.selectedElement = new ElementNode(CustomXmlParserInputWizardPage.this.elementContainer, inputElement);
                CustomXmlParserInputWizardPage.this.elementContainer.layout();
                CustomXmlParserInputWizardPage.this.elementScrolledComposite.setMinSize(((CustomXmlParserInputWizardPage)CustomXmlParserInputWizardPage.this).elementContainer.computeSize((int)-1, (int)-1).x, ((CustomXmlParserInputWizardPage)CustomXmlParserInputWizardPage.this).elementContainer.computeSize((int)-1, (int)-1).y - 1);
                CustomXmlParserInputWizardPage.this.container.layout();
                CustomXmlParserInputWizardPage.this.validate();
                CustomXmlParserInputWizardPage.this.updatePreviews();
                CustomXmlParserInputWizardPage.this.removeButton.setEnabled(true);
                CustomXmlParserInputWizardPage.this.addChildButton.setEnabled(true);
                CustomXmlParserInputWizardPage.this.addChildButton.setToolTipText(Messages.CustomXmlParserInputWizardPage_addChildElement);
                if (((CustomXmlParserInputWizardPage)CustomXmlParserInputWizardPage.this).definition.rootInputElement == inputElement) {
                    CustomXmlParserInputWizardPage.this.addNextButton.setEnabled(false);
                } else {
                    CustomXmlParserInputWizardPage.this.addNextButton.setEnabled(true);
                }
                CustomXmlParserInputWizardPage.this.moveUpButton.setEnabled(true);
                CustomXmlParserInputWizardPage.this.moveDownButton.setEnabled(true);
            } else {
                CustomXmlParserInputWizardPage.this.removeButton.setEnabled(false);
                if (((CustomXmlParserInputWizardPage)CustomXmlParserInputWizardPage.this).definition.rootInputElement == null) {
                    CustomXmlParserInputWizardPage.this.addChildButton.setEnabled(true);
                    CustomXmlParserInputWizardPage.this.addChildButton.setToolTipText(Messages.CustomXmlParserInputWizardPage_addDocumentElement);
                } else {
                    CustomXmlParserInputWizardPage.this.addChildButton.setEnabled(false);
                }
                CustomXmlParserInputWizardPage.this.addNextButton.setEnabled(false);
                CustomXmlParserInputWizardPage.this.moveUpButton.setEnabled(false);
                CustomXmlParserInputWizardPage.this.moveDownButton.setEnabled(false);
            }
        }
    }

    private class UpdateListener
    implements ModifyListener,
    SelectionListener {
        private UpdateListener() {
        }

        public void modifyText(ModifyEvent e) {
            CustomXmlParserInputWizardPage.this.validate();
            CustomXmlParserInputWizardPage.this.updatePreviews();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            CustomXmlParserInputWizardPage.this.validate();
            CustomXmlParserInputWizardPage.this.updatePreviews();
        }

        public void widgetSelected(SelectionEvent e) {
            CustomXmlParserInputWizardPage.this.validate();
            CustomXmlParserInputWizardPage.this.updatePreviews();
        }
    }
}

