/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.core;

import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.linuxtools.internal.valgrind.core.Messages;
import org.eclipse.linuxtools.internal.valgrind.core.ValgrindPlugin;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ValgrindPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String VALGRIND_PATH = "VALGRIND_PATH";
    private Text binText;
    private Button button;
    private IPreferenceStore store;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data);
        Label pathLabel = new Label(composite, 0);
        pathLabel.setText(Messages.getString("ValgrindPreferencePage.Binary_path"));
        this.binText = new Text(composite, 2052);
        GridData binTextData = new GridData();
        binTextData.horizontalAlignment = 4;
        binTextData.grabExcessHorizontalSpace = true;
        this.binText.setLayoutData((Object)binTextData);
        this.button = new Button(composite, 8);
        this.button.setText(Messages.getString("ValgrindPreferencePage.Browse_button"));
        this.button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Shell shell = new Shell();
                FileDialog dialog = new FileDialog(shell);
                String path = dialog.open();
                if (path != null) {
                    ValgrindPreferencePage.this.binText.setText(path);
                }
            }
        });
        this.loadPreferences();
        return parent;
    }

    private void loadPreferences() {
        this.binText.setText(this.store.getString(VALGRIND_PATH));
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return ValgrindPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
        this.store = this.getPreferenceStore();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.store.setValue(VALGRIND_PATH, this.store.getDefaultString(VALGRIND_PATH));
        this.binText.setText(this.store.getDefaultString(VALGRIND_PATH));
    }

    public boolean performOk() {
        if (this.passesValidityChecks()) {
            ValgrindPlugin.getDefault().savePluginPreferences();
            return true;
        }
        return false;
    }

    private boolean passesValidityChecks() {
        File file = new File(this.binText.getText());
        if (!file.exists() || file.isDirectory()) {
            this.performDefaults();
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)Messages.getString("ValgrindPreferencePage.Error_invalid_title"), (String)Messages.getString("ValgrindPreferencePage.Error_invalid_message"));
            return false;
        }
        this.store.setValue(VALGRIND_PATH, this.binText.getText());
        return true;
    }
}

