/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.massif.birt;

import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.device.ICallBackNotifier;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.CallBackValue;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifSnapshot;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifViewPart;
import org.eclipse.linuxtools.internal.valgrind.massif.birt.ChartLocationsDialog;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ChartControl
extends Canvas
implements PaintListener,
ControlListener,
ICallBackNotifier {
    private transient boolean bIsPainting = false;
    private transient Image buffer;
    private static int X_OFFSET = 3;
    private static int Y_OFFSET = 3;
    protected Chart cm = null;
    protected GeneratedChartState state = null;
    protected IDeviceRenderer deviceRenderer = null;
    private boolean needsGeneration = true;
    private MassifViewPart view;

    public ChartControl(Composite parent, Chart chart, MassifViewPart view, int style) {
        super(parent, 2048);
        this.view = view;
        this.cm = chart;
        this.setLayoutData(new GridData(1808));
        this.setBackground(Display.getDefault().getSystemColor(1));
        try {
            this.deviceRenderer = PluginSettings.instance().getDevice("dv.SWT");
            this.deviceRenderer.setProperty("device.component", (Object)this);
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ChartControl.this.deviceRenderer.dispose();
                }
            });
            this.addPaintListener(this);
            this.addControlListener(this);
        }
        catch (ChartException e) {
            e.printStackTrace();
        }
    }

    public void callback(Object event, Object source, CallBackValue value) {
        this.showView();
        MouseEvent mEvent = (MouseEvent)event;
        DataPointHints point = (DataPointHints)((WrappedStructureSource)source).getSource();
        TableViewer viewer = this.view.getTableViewer();
        this.view.setTopControl(viewer.getControl());
        MassifSnapshot snapshot = (MassifSnapshot)viewer.getElementAt(point.getIndex());
        switch (mEvent.count) {
            case 1: {
                viewer.setSelection((ISelection)new StructuredSelection((Object)snapshot));
                break;
            }
            case 2: {
                if (!snapshot.isDetailed()) break;
                ChartLocationsDialog dialog = new ChartLocationsDialog(this.getShell());
                dialog.setInput(snapshot);
                if (dialog.open() != 0) break;
                dialog.openEditorForResult();
            }
        }
    }

    public Chart getDesignTimeModel() {
        return this.cm;
    }

    public Chart getRunTimeModel() {
        return this.state.getChartModel();
    }

    public Object peerInstance() {
        return this;
    }

    public void regenerateChart() {
        this.needsGeneration = true;
        this.redraw();
    }

    public void repaintChart() {
        this.redraw();
    }

    public void paintControl(PaintEvent pe) {
        if (this.bIsPainting) {
            return;
        }
        Exception paintError = null;
        Rectangle re = this.getClientArea();
        Rectangle adjustedRe = new Rectangle(0, 0, re.width, re.height);
        if (adjustedRe.width - 2 * X_OFFSET <= 0 || adjustedRe.height - 2 * Y_OFFSET <= 0) {
            if (this.buffer != null && !this.buffer.isDisposed()) {
                this.buffer.dispose();
                this.buffer = null;
            }
            return;
        }
        if (this.cm == null) {
            this.buffer = null;
        } else {
            block17: {
                this.bIsPainting = true;
                Image oldBuffer = null;
                if (this.buffer == null) {
                    this.buffer = new Image((Device)Display.getDefault(), adjustedRe);
                } else {
                    Rectangle ore = this.buffer.getBounds();
                    oldBuffer = this.buffer;
                    if (!adjustedRe.equals((Object)ore)) {
                        this.buffer = new Image((Device)Display.getDefault(), adjustedRe);
                    }
                }
                GC gcImage = new GC((Drawable)this.buffer);
                gcImage.setForeground(Display.getDefault().getSystemColor(1));
                gcImage.fillRectangle(this.buffer.getBounds());
                Bounds bo = BoundsImpl.create((double)X_OFFSET, (double)Y_OFFSET, (double)(adjustedRe.width - 2 * X_OFFSET), (double)(adjustedRe.height - 2 * Y_OFFSET));
                try {
                    try {
                        this.deviceRenderer.setProperty("device.output.context", (Object)gcImage);
                        bo.scale(72.0 / (double)this.deviceRenderer.getDisplayServer().getDpiResolution());
                        Generator gr = Generator.instance();
                        if (this.needsGeneration) {
                            this.needsGeneration = false;
                            RunTimeContext rtc = new RunTimeContext();
                            this.state = gr.build(this.deviceRenderer.getDisplayServer(), this.cm, bo, null, rtc, null);
                        }
                        gr.render(this.deviceRenderer, this.state);
                        if (paintError != null) {
                            // empty if block
                        }
                        if (oldBuffer != null && oldBuffer != this.buffer) {
                            oldBuffer.dispose();
                        }
                        GC gc = pe.gc;
                        if (this.buffer != null) {
                            gc.drawImage(this.buffer, 0, 0);
                        }
                    }
                    catch (Exception ex) {
                        paintError = ex;
                        gcImage.dispose();
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    gcImage.dispose();
                    throw throwable;
                }
                gcImage.dispose();
            }
            this.bIsPainting = false;
        }
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.needsGeneration = true;
        this.redraw();
    }

    public void showView() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    activePage.showView("org.eclipse.linuxtools.valgrind.ui.valgrindview");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

