/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.jni;

import java.util.HashMap;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.internal.lttng.jni.common.JniTime;
import org.eclipse.linuxtools.internal.lttng.jni.common.Jni_C_Pointer_And_Library_Id;
import org.eclipse.linuxtools.internal.lttng.jni.exception.JniException;
import org.eclipse.linuxtools.internal.lttng.jni.exception.JniOpenTraceFailedException;
import org.eclipse.linuxtools.internal.lttng.jni.exception.JniTraceException;
import org.eclipse.linuxtools.internal.lttng.jni.exception.JniTracefileWithoutEventException;
import org.eclipse.linuxtools.lttng.jni.JniEvent;
import org.eclipse.linuxtools.lttng.jni.JniTracefile;
import org.eclipse.linuxtools.lttng.jni.Jni_C_Common;

public abstract class JniTrace
extends Jni_C_Common {
    private static final boolean DEFAULT_LTT_DEBUG = false;
    private Jni_C_Pointer_And_Library_Id thisTracePtr = new Jni_C_Pointer_And_Library_Id();
    private String tracepath = "";
    private int cpuNumber = 0;
    private long archType = 0L;
    private long archVariant = 0L;
    private short archSize = 0;
    private short lttMajorVersion = 0;
    private short lttMinorVersion = 0;
    private short flightRecorder = 0;
    private long freqScale = 0L;
    private long startFreq = 0L;
    private long startTimestampCurrentCounter = 0L;
    private long startMonotonic = 0L;
    private JniTime startTimeNoAdjustement = null;
    private JniTime startTime = null;
    private JniTime endTime = null;
    private HashMap<String, JniTracefile> tracefilesMap = null;
    private PriorityQueue<JniEvent> eventsHeap = null;
    private JniEvent currentEvent = null;
    private boolean printLttDebug = false;
    private boolean isLiveTraceSupported = true;
    private String traceLibPath;

    protected native int ltt_initializeHandle(String var1);

    protected native boolean ltt_freeHandle(int var1);

    protected native long ltt_openTrace(int var1, String var2, boolean var3);

    protected native long ltt_openTraceLive(int var1, String var2, boolean var3);

    protected native void ltt_closeTrace(int var1, long var2);

    protected native String ltt_getTracepath(int var1, long var2);

    protected native int ltt_getCpuNumber(int var1, long var2);

    protected native long ltt_getArchType(int var1, long var2);

    protected native long ltt_getArchVariant(int var1, long var2);

    protected native short ltt_getArchSize(int var1, long var2);

    protected native short ltt_getLttMajorVersion(int var1, long var2);

    protected native short ltt_getLttMinorVersion(int var1, long var2);

    protected native short ltt_getFlightRecorder(int var1, long var2);

    protected native long ltt_getFreqScale(int var1, long var2);

    protected native long ltt_getStartFreq(int var1, long var2);

    protected native long ltt_getStartTimestampCurrentCounter(int var1, long var2);

    protected native long ltt_getStartMonotonic(int var1, long var2);

    protected native int ltt_updateTrace(int var1, long var2);

    protected native void ltt_feedStartTime(int var1, long var2, JniTime var4);

    protected native void ltt_feedStartTimeFromTimestampCurrentCounter(int var1, long var2, JniTime var4);

    protected native void ltt_feedAllTracefiles(int var1, long var2);

    protected native void ltt_feedTracefileTimeRange(int var1, long var2, JniTime var4, JniTime var5);

    protected native void ltt_printTrace(int var1, long var2);

    protected JniTrace() {
    }

    public JniTrace(String newpath) {
        this(newpath, false);
    }

    public JniTrace(String newpath, boolean newPrintDebug) {
        this.tracepath = newpath;
        this.thisTracePtr = new Jni_C_Pointer_And_Library_Id();
        this.printLttDebug = newPrintDebug;
    }

    public JniTrace(JniTrace oldTrace) {
        this.thisTracePtr = oldTrace.thisTracePtr;
        this.tracepath = oldTrace.tracepath;
        this.cpuNumber = oldTrace.cpuNumber;
        this.archType = oldTrace.archType;
        this.archVariant = oldTrace.archVariant;
        this.archSize = oldTrace.archSize;
        this.lttMajorVersion = oldTrace.lttMajorVersion;
        this.lttMinorVersion = oldTrace.lttMinorVersion;
        this.flightRecorder = oldTrace.flightRecorder;
        this.freqScale = oldTrace.freqScale;
        this.startFreq = oldTrace.startFreq;
        this.startTimestampCurrentCounter = oldTrace.startTimestampCurrentCounter;
        this.startMonotonic = oldTrace.startMonotonic;
        this.startTimeNoAdjustement = oldTrace.startTimeNoAdjustement;
        this.startTime = oldTrace.startTime;
        this.endTime = oldTrace.endTime;
        this.tracefilesMap = new HashMap(oldTrace.tracefilesMap.size());
        this.ltt_feedAllTracefiles(this.thisTracePtr.getLibraryId(), this.thisTracePtr.getPointer());
        this.eventsHeap = new PriorityQueue(oldTrace.eventsHeap.size());
        this.populateEventHeap();
        this.printLttDebug = oldTrace.printLttDebug;
    }

    public JniTrace(Jni_C_Pointer_And_Library_Id newPtr, boolean newPrintDebug) throws JniException {
        this.thisTracePtr = newPtr;
        this.printLttDebug = newPrintDebug;
        this.populateTraceInformation();
    }

    public void finalize() {
        if (this.thisTracePtr.getPointer() != 0L) {
            this.closeTrace();
        }
        this.freeLibrary();
    }

    public void openTrace(String newPath) throws JniException {
        if (this.thisTracePtr.getPointer() != 0L) {
            this.closeTrace();
        }
        this.tracepath = newPath;
        this.openTrace();
    }

    public void openTrace() throws JniException {
        long newPtr;
        int newLibraryId;
        if (this.tracepath == "") {
            throw new JniTraceException("Tracepath is not set. (openTrace)");
        }
        if (this.thisTracePtr.getPointer() != 0L) {
            this.closeTrace();
        }
        if ((newLibraryId = this.initializeLibrary()) != -1) {
            newPtr = 0L;
            try {
                newPtr = this.ltt_openTraceLive(newLibraryId, this.tracepath, this.printLttDebug);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
            if (newPtr == 0L) {
                this.isLiveTraceSupported = false;
                newPtr = this.ltt_openTrace(newLibraryId, this.tracepath, this.printLttDebug);
            }
            if (newPtr == 0L) {
                this.thisTracePtr = new Jni_C_Pointer_And_Library_Id();
                throw new JniOpenTraceFailedException("Error while opening trace. Is the tracepath correct? (openTrace)");
            }
        } else {
            this.thisTracePtr = new Jni_C_Pointer_And_Library_Id();
            throw new JniTraceException("Failed to initialize the parsing library:\n\t" + this.getTraceLibFullPath() + "\n\nIs the C library supporting that trace format properly installed?\n\n" + "Make sure that:\n" + "\t- The correct parsing library is installed\n" + "\t- The library is accessible (LD_LIBRARY_PATH or LTTng project properties)\n" + "\nRefer to the LTTng User Guide for more information");
        }
        this.thisTracePtr = new Jni_C_Pointer_And_Library_Id(newLibraryId, newPtr);
        this.populateTraceInformation();
    }

    public void closeTrace() {
        if (this.thisTracePtr.getPointer() != 0L) {
            this.ltt_closeTrace(this.thisTracePtr.getLibraryId(), this.thisTracePtr.getPointer());
            this.tracefilesMap.clear();
            this.tracefilesMap = null;
            this.eventsHeap.clear();
            this.eventsHeap = null;
            this.thisTracePtr = new Jni_C_Pointer_And_Library_Id();
        }
    }

    public void freeLibrary() {
        this.ltt_freeHandle(this.thisTracePtr.getLibraryId());
    }

    private void populateTraceInformation() throws JniException {
        if (this.thisTracePtr.getPointer() == 0L) {
            throw new JniTraceException("Pointer is NULL, trace not opened/already closed? (populateTraceInformation)");
        }
        this.tracepath = this.ltt_getTracepath(this.thisTracePtr.getLibraryId(), this.thisTracePtr.getPointer());
        this.cpuNumber = this.ltt_getCpuNumber(this.thisTracePtr.getLibraryId(), this.thisTracePtr.getPointer());
        this.archType = this.ltt_getArchType(this.thisTracePtr.getLibraryId(), this.thisTracePtr.getPointer());
        this.archVariant = this.ltt_getArchVariant(this.thisTracePtr.getLibraryId(), this.thisTracePtr.getPointer());
        this.archSize = this.ltt_getArchSize(this.thisTracePtr.getLibraryId(), this.thisTracePtr.getPointer());
        this.lttMajorVersion = this.ltt_getLttMajorVersion(this.thisTracePtr.getLibraryId(), this.thisTracePtr.getPointer());
        this.lttMinorVersion = this.ltt_getLttMinorVersion(this.thisTracePtr.getLibraryId(), this.thisTracePtr.getPointer());
        this.flightRecorder = this.ltt_getFlightRecorder(this.thisTracePtr.getLibraryId(), this.thisTracePtr.getPointer());
        this.freqScale = this.ltt_getFreqScale(this.thisTracePtr.getLibraryId(), this.thisTracePtr.getPointer());
        this.startFreq = this.ltt_getStartFreq(this.thisTracePtr.getLibraryId(), this.thisTracePtr.getPointer());
        this.startTimestampCurrentCounter = this.ltt_getStartTimestampCurrentCounter(this.thisTracePtr.getLibraryId(), this.thisTracePtr.getPointer());
        this.startMonotonic = this.ltt_getStartMonotonic(this.thisTracePtr.getLibraryId(), this.thisTracePtr.getPointer());
        this.startTimeNoAdjustement = new JniTime();
        this.ltt_feedStartTime(this.thisTracePtr.getLibraryId(), this.thisTracePtr.getPointer(), this.startTimeNoAdjustement);
        this.startTime = new JniTime();
        this.ltt_feedStartTimeFromTimestampCurrentCounter(this.thisTracePtr.getLibraryId(), this.thisTracePtr.getPointer(), this.startTime);
        if (this.tracefilesMap == null) {
            this.tracefilesMap = new HashMap();
        }
        this.ltt_feedAllTracefiles(this.thisTracePtr.getLibraryId(), this.thisTracePtr.getPointer());
        this.endTime = new JniTime();
        this.ltt_feedTracefileTimeRange(this.thisTracePtr.getLibraryId(), this.thisTracePtr.getPointer(), new JniTime(), this.endTime);
        if (this.eventsHeap == null) {
            this.eventsHeap = new PriorityQueue(this.tracefilesMap.size());
        }
        this.populateEventHeap();
    }

    private void populateEventHeap() {
        this.currentEvent = null;
        this.eventsHeap.clear();
        String new_key2 = null;
        JniTracefile tmpTracefile = null;
        for (String new_key2 : this.tracefilesMap.keySet()) {
            tmpTracefile = this.tracefilesMap.get(new_key2);
            if (tmpTracefile.getCurrentEvent().getEventState() != 0) continue;
            this.eventsHeap.add(tmpTracefile.getCurrentEvent());
        }
    }

    protected void addTracefileFromC(String tracefileName, long tracefilePtr) {
        block4: {
            JniTracefile newTracefile = null;
            try {
                newTracefile = this.allocateNewJniTracefile(new Jni_C_Pointer_And_Library_Id(this.thisTracePtr.getLibraryId(), tracefilePtr), this);
                this.getTracefilesMap().put(String.valueOf(tracefileName) + newTracefile.getCpuNumber(), newTracefile);
            }
            catch (JniTracefileWithoutEventException jniTracefileWithoutEventException) {
                if (this.printLttDebug) {
                    this.printlnC(this.thisTracePtr.getLibraryId(), "JniTracefile " + tracefileName + " has no event (addTracefileFromC). Ignoring.");
                }
            }
            catch (Exception e) {
                if (!this.printLttDebug) break block4;
                this.printlnC(this.thisTracePtr.getLibraryId(), "Failed to add tracefile " + tracefileName + " to tracefilesMap!(addTracefileFromC)\n\tException raised : " + e.toString());
            }
        }
    }

    public JniEvent findNextEvent() {
        if (this.eventsHeap != null) {
            return this.eventsHeap.peek();
        }
        return null;
    }

    public JniEvent readNextEvent() {
        JniEvent tmpEvent = this.findNextEvent();
        if (tmpEvent == null) {
            return null;
        }
        if (tmpEvent.equals(this.currentEvent)) {
            this.eventsHeap.poll();
            tmpEvent.readNextEvent();
            if (tmpEvent.getEventState() == 0) {
                this.eventsHeap.add(tmpEvent);
            }
            this.currentEvent = tmpEvent = this.findNextEvent();
        } else {
            this.currentEvent = tmpEvent;
        }
        return tmpEvent;
    }

    public JniEvent readNextEvent(JniTracefile targetTracefile) {
        JniEvent returnedEvent = null;
        if (this.currentEvent == null || !this.currentEvent.getParentTracefile().equals(targetTracefile)) {
            this.currentEvent = returnedEvent = targetTracefile.getCurrentEvent();
        } else {
            this.eventsHeap.remove(targetTracefile.getCurrentEvent());
            if (targetTracefile.readNextEvent() == 0) {
                returnedEvent = targetTracefile.getCurrentEvent();
                this.eventsHeap.add(returnedEvent);
            }
            this.currentEvent = targetTracefile.getCurrentEvent();
        }
        return returnedEvent;
    }

    public void seekToTime(JniTime seekTime) {
        this.currentEvent = null;
        String tracefile_name2 = null;
        for (String tracefile_name2 : this.tracefilesMap.keySet()) {
            this.seekToTime(seekTime, this.tracefilesMap.get(tracefile_name2));
        }
        this.populateEventHeap();
    }

    public void seekToTime(JniTime seekTime, JniTracefile targetTracefile) {
        this.currentEvent = null;
        this.eventsHeap.remove(targetTracefile.getCurrentEvent());
        if (targetTracefile.seekToTime(seekTime) == 0) {
            this.eventsHeap.add(targetTracefile.getCurrentEvent());
        }
    }

    public JniEvent seekAndRead(JniTime seekTime) {
        JniEvent returnedEvent = null;
        this.seekToTime(seekTime);
        returnedEvent = this.readNextEvent();
        return returnedEvent;
    }

    public JniEvent seekAndRead(JniTime seekTime, JniTracefile targetTracefile) {
        this.seekToTime(seekTime, targetTracefile);
        return this.readNextEvent(targetTracefile);
    }

    public JniTracefile requestTracefileByName(String tracefileName) {
        return this.tracefilesMap.get(tracefileName);
    }

    public JniEvent requestEventByName(String tracefileName) {
        JniEvent returnValue = null;
        JniTracefile tmpTracefile = this.tracefilesMap.get(tracefileName);
        if (tmpTracefile != null) {
            returnValue = tmpTracefile.getCurrentEvent();
        }
        return returnValue;
    }

    public String getTracepath() {
        return this.tracepath;
    }

    public int getCpuNumber() {
        return this.cpuNumber;
    }

    public long getArchType() {
        return this.archType;
    }

    public long getArchVariant() {
        return this.archVariant;
    }

    public short getArchSize() {
        return this.archSize;
    }

    public short getLttMajorVersion() {
        return this.lttMajorVersion;
    }

    public short getLttMinorVersion() {
        return this.lttMinorVersion;
    }

    public short getFlightRecorder() {
        return this.flightRecorder;
    }

    public long getFreqScale() {
        return this.freqScale;
    }

    public long getStartFreq() {
        return this.startFreq;
    }

    public long getStartTimestampCurrentCounter() {
        return this.startTimestampCurrentCounter;
    }

    public long getStartMonotonic() {
        return this.startMonotonic;
    }

    public void updateTrace() {
        int numUpdated;
        if (this.thisTracePtr.getPointer() != 0L && this.isLiveTraceSupported() && (numUpdated = this.ltt_updateTrace(this.thisTracePtr.getLibraryId(), this.thisTracePtr.getPointer())) > 0) {
            this.ltt_feedTracefileTimeRange(this.thisTracePtr.getLibraryId(), this.thisTracePtr.getPointer(), new JniTime(), this.endTime);
        }
    }

    public JniTime getStartTime() {
        return this.startTime;
    }

    public JniTime getEndTime() {
        return this.endTime;
    }

    public JniTime getStartTimeNoAdjustement() {
        return this.startTimeNoAdjustement;
    }

    public HashMap<String, JniTracefile> getTracefilesMap() {
        return this.tracefilesMap;
    }

    public JniTime getCurrentEventTimestamp() {
        JniTime returnedTime = null;
        returnedTime = this.currentEvent != null ? this.currentEvent.getEventTime() : new JniTime(Long.MAX_VALUE);
        return returnedTime;
    }

    public Jni_C_Pointer_And_Library_Id getTracePtr() {
        return this.thisTracePtr;
    }

    public boolean isLiveTraceSupported() {
        return this.isLiveTraceSupported;
    }

    public boolean isPrintingLttDebug() {
        return this.printLttDebug;
    }

    public void printAllTracefilesInformation() {
        JniTracefile tracefile = null;
        Iterator<String> iterator = this.tracefilesMap.keySet().iterator();
        while (iterator.hasNext()) {
            tracefile = this.tracefilesMap.get(iterator.next());
            tracefile.printTracefileInformation();
        }
    }

    public void printTraceInformation() {
    }

    public String toString() {
        String returnData = "";
        returnData = String.valueOf(returnData) + "tracepath                            : " + this.tracepath + "\n";
        returnData = String.valueOf(returnData) + "cpuNumber                            : " + this.cpuNumber + "\n";
        returnData = String.valueOf(returnData) + "archType                             : " + this.archType + "\n";
        returnData = String.valueOf(returnData) + "archVariant                          : " + this.archVariant + "\n";
        returnData = String.valueOf(returnData) + "archSize                             : " + this.archSize + "\n";
        returnData = String.valueOf(returnData) + "lttMajorVersion                      : " + this.lttMajorVersion + "\n";
        returnData = String.valueOf(returnData) + "lttMinorVersion                      : " + this.lttMinorVersion + "\n";
        returnData = String.valueOf(returnData) + "flightRecorder                       : " + this.flightRecorder + "\n";
        returnData = String.valueOf(returnData) + "freqScale                            : " + this.freqScale + "\n";
        returnData = String.valueOf(returnData) + "startFreq                            : " + this.startFreq + "\n";
        returnData = String.valueOf(returnData) + "startTimestampCurrentCounter         : " + this.startTimestampCurrentCounter + "\n";
        returnData = String.valueOf(returnData) + "startMonotonic                       : " + this.startMonotonic + "\n";
        returnData = String.valueOf(returnData) + "startTimeNoAdjustement               : " + this.startTimeNoAdjustement.getReferenceToString() + "\n";
        returnData = String.valueOf(returnData) + "   seconds                           : " + this.startTimeNoAdjustement.getSeconds() + "\n";
        returnData = String.valueOf(returnData) + "   nanoSeconds                       : " + this.startTimeNoAdjustement.getNanoSeconds() + "\n";
        returnData = String.valueOf(returnData) + "startTime                            : " + this.startTime.getReferenceToString() + "\n";
        returnData = String.valueOf(returnData) + "   seconds                           : " + this.startTime.getSeconds() + "\n";
        returnData = String.valueOf(returnData) + "   nanoSeconds                       : " + this.startTime.getNanoSeconds() + "\n";
        returnData = String.valueOf(returnData) + "endTime                              : " + this.endTime.getReferenceToString() + "\n";
        returnData = String.valueOf(returnData) + "   seconds                           : " + this.endTime.getSeconds() + "\n";
        returnData = String.valueOf(returnData) + "   nanoSeconds                       : " + this.endTime.getNanoSeconds() + "\n";
        returnData = String.valueOf(returnData) + "tracefilesMap                        : " + this.tracefilesMap.keySet() + "\n";
        return returnData;
    }

    public abstract String getTraceLibName();

    public abstract JniTracefile allocateNewJniTracefile(Jni_C_Pointer_And_Library_Id var1, JniTrace var2) throws JniException;

    public void setTraceLibPath(String traceLibPath) {
        this.traceLibPath = traceLibPath;
    }

    public String getTraceLibPath() {
        return this.traceLibPath;
    }

    public int initializeLibrary() {
        return this.ltt_initializeHandle(this.getTraceLibFullPath());
    }

    public String getTraceLibFullPath() {
        if (this.getTraceLibPath() == null) {
            return this.getTraceLibName();
        }
        Path path = new Path(this.getTraceLibPath());
        IPath traceLib = path.append(this.getTraceLibName());
        return traceLib.toOSString();
    }
}

