/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.views.statistics.evProcessor;

import org.eclipse.linuxtools.internal.lttng.core.event.LttngEvent;
import org.eclipse.linuxtools.internal.lttng.core.state.StateStrings;
import org.eclipse.linuxtools.internal.lttng.core.state.evProcessor.ILttngEventProcessor;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngTraceState;
import org.eclipse.linuxtools.internal.lttng.ui.views.statistics.evProcessor.StatsModeChangeHandler;
import org.eclipse.linuxtools.internal.lttng.ui.views.statistics.evProcessor.StatsModeEndHandler;
import org.eclipse.linuxtools.internal.lttng.ui.views.statistics.evProcessor.StatsProcessExitHandler;
import org.eclipse.linuxtools.internal.lttng.ui.views.statistics.evProcessor.StatsTracesetEndHandler;

class StatsTimeCountHandlers {
    StatsTimeCountHandlers() {
    }

    final ILttngEventProcessor getSyscallEntryBeforeHandler() {
        StatsModeChangeHandler handler = new StatsModeChangeHandler(StateStrings.Events.LTT_EVENT_SYSCALL_ENTRY);
        return handler;
    }

    final ILttngEventProcessor getsySyscallExitBeforeHandler() {
        StatsModeEndHandler handler = new StatsModeEndHandler(StateStrings.Events.LTT_EVENT_SYSCALL_EXIT);
        return handler;
    }

    final ILttngEventProcessor getTrapEntryBeforeHandler() {
        StatsModeChangeHandler handler = new StatsModeChangeHandler(StateStrings.Events.LTT_EVENT_TRAP_ENTRY);
        return handler;
    }

    final ILttngEventProcessor getTrapExitBeforeHandler() {
        StatsModeEndHandler handler = new StatsModeEndHandler(StateStrings.Events.LTT_EVENT_TRAP_EXIT);
        return handler;
    }

    final ILttngEventProcessor getIrqEntryBeforeHandler() {
        StatsModeChangeHandler handler = new StatsModeChangeHandler(StateStrings.Events.LTT_EVENT_IRQ_ENTRY);
        return handler;
    }

    final ILttngEventProcessor getIrqExitBeforeHandler() {
        StatsModeEndHandler handler = new StatsModeEndHandler(StateStrings.Events.LTT_EVENT_IRQ_EXIT);
        return handler;
    }

    final ILttngEventProcessor getSoftIrqEntryBeforeHandler() {
        StatsModeChangeHandler handler = new StatsModeChangeHandler(StateStrings.Events.LTT_EVENT_SOFT_IRQ_ENTRY);
        return handler;
    }

    final ILttngEventProcessor getSoftIrqExitBeforeHandler() {
        StatsModeEndHandler handler = new StatsModeEndHandler(StateStrings.Events.LTT_EVENT_SOFT_IRQ_EXIT);
        return handler;
    }

    final ILttngEventProcessor getFunctionEntryBeforeHandler() {
        StatsModeChangeHandler handler = new StatsModeChangeHandler(StateStrings.Events.LTT_EVENT_FUNCTION_ENTRY);
        return handler;
    }

    final ILttngEventProcessor getFunctionExitBeforeHandler() {
        StatsModeEndHandler handler = new StatsModeEndHandler(StateStrings.Events.LTT_EVENT_FUNCTION_EXIT);
        return handler;
    }

    final ILttngEventProcessor getSchedChangeBeforeHandler() {
        StatsModeChangeHandler handler = new StatsModeChangeHandler(StateStrings.Events.LTT_EVENT_SCHED_SCHEDULE);
        return handler;
    }

    final ILttngEventProcessor getAfterHandler() {
        StatsModeChangeHandler handler = new StatsModeChangeHandler(null){
            int sched_hash;
            {
                this.sched_hash = StateStrings.Events.LTT_EVENT_SCHED_SCHEDULE.getInName().hashCode();
            }

            @Override
            public boolean process(LttngEvent event, LttngTraceState traceState) {
                this.stepCount(event, traceState);
                int eventNameHash = event.getMarkerName().hashCode();
                if (this.sched_hash == eventNameHash && event.getMarkerName().equals(StateStrings.Events.LTT_EVENT_SCHED_SCHEDULE.getInName())) {
                    return super.process(event, traceState);
                }
                return false;
            }
        };
        return handler;
    }

    ILttngEventProcessor getTracesetEndHandler() {
        return new StatsTracesetEndHandler();
    }

    ILttngEventProcessor getProcessExitHandler() {
        return new StatsProcessExitHandler();
    }
}

