/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.IBaseEventInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.IChannelInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.IDomainInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.IEventInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.ISessionInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.IUstProviderInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.LogLevelType;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.TraceEventType;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.TraceLogLevel;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.impl.BaseEventInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.impl.ChannelInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.impl.DomainInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.impl.EventInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.impl.ProbeEventInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.impl.SessionInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.impl.UstProviderInfo;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.logging.ControlCommandLogger;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.preferences.ControlPreferences;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.remote.ICommandResult;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.remote.ICommandShell;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.service.ILttngControlService;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.service.LTTngControlServiceConstants;

public class LTTngControlService
implements ILttngControlService {
    protected ICommandShell fCommandShell = null;
    protected String fVersion = "Unknown";

    public LTTngControlService(ICommandShell shell) {
        this.fCommandShell = shell;
    }

    @Override
    public String getVersion() {
        return this.fVersion;
    }

    public void setVersion(String version) {
        this.fVersion = version;
    }

    @Override
    public String[] getSessionNames(IProgressMonitor monitor) throws ExecutionException {
        StringBuffer command = this.createCommand(" list ");
        ICommandResult result = this.executeCommand(command.toString(), monitor);
        ArrayList<String> retArray = new ArrayList<String>();
        int index = 0;
        while (index < result.getOutput().length) {
            String line = result.getOutput()[index];
            Matcher matcher = LTTngControlServiceConstants.SESSION_PATTERN.matcher(line);
            if (matcher.matches()) {
                retArray.add(matcher.group(2).trim());
            }
            ++index;
        }
        return retArray.toArray(new String[retArray.size()]);
    }

    @Override
    public ISessionInfo getSession(String sessionName, IProgressMonitor monitor) throws ExecutionException {
        StringBuffer command = this.createCommand(" list ", sessionName);
        ICommandResult result = this.executeCommand(command.toString(), monitor);
        int index = 0;
        SessionInfo sessionInfo = new SessionInfo(sessionName);
        while (index < result.getOutput().length) {
            ArrayList<Object> channels;
            DomainInfo domainInfo;
            String line = result.getOutput()[index];
            Matcher matcher = LTTngControlServiceConstants.TRACE_SESSION_PATTERN.matcher(line);
            if (matcher.matches()) {
                sessionInfo.setSessionState(matcher.group(2));
                ++index;
                continue;
            }
            matcher = LTTngControlServiceConstants.TRACE_SESSION_PATH_PATTERN.matcher(line);
            if (matcher.matches()) {
                sessionInfo.setSessionPath(matcher.group(1).trim());
                ++index;
                continue;
            }
            matcher = LTTngControlServiceConstants.DOMAIN_KERNEL_PATTERN.matcher(line);
            if (matcher.matches()) {
                domainInfo = new DomainInfo(Messages.TraceControl_KernelDomainDisplayName);
                sessionInfo.addDomain((IDomainInfo)domainInfo);
                channels = new ArrayList<IChannelInfo>();
                index = this.parseDomain(result.getOutput(), index, channels);
                domainInfo.setChannels(channels);
                domainInfo.setIsKernel(true);
                continue;
            }
            matcher = LTTngControlServiceConstants.DOMAIN_UST_GLOBAL_PATTERN.matcher(line);
            if (matcher.matches()) {
                domainInfo = new DomainInfo(Messages.TraceControl_UstGlobalDomainDisplayName);
                sessionInfo.addDomain((IDomainInfo)domainInfo);
                channels = new ArrayList();
                index = this.parseDomain(result.getOutput(), index, channels);
                domainInfo.setChannels(channels);
                domainInfo.setIsKernel(false);
                continue;
            }
            ++index;
        }
        return sessionInfo;
    }

    @Override
    public List<IBaseEventInfo> getKernelProvider(IProgressMonitor monitor) throws ExecutionException {
        StringBuffer command = this.createCommand(" list -k");
        ICommandResult result = this.executeCommand(command.toString(), monitor);
        ArrayList<IBaseEventInfo> events = new ArrayList<IBaseEventInfo>();
        this.getProviderEventInfo(result.getOutput(), 0, events);
        return events;
    }

    @Override
    public List<IUstProviderInfo> getUstProvider() throws ExecutionException {
        return this.getUstProvider((IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public List<IUstProviderInfo> getUstProvider(IProgressMonitor monitor) throws ExecutionException {
        StringBuffer command = this.createCommand(" list -u");
        ICommandResult result = this.executeCommand(command.toString(), monitor);
        ArrayList<IUstProviderInfo> allProviders = new ArrayList<IUstProviderInfo>();
        UstProviderInfo provider = null;
        int index = 0;
        while (index < result.getOutput().length) {
            String line = result.getOutput()[index];
            Matcher matcher = LTTngControlServiceConstants.UST_PROVIDER_PATTERN.matcher(line);
            if (matcher.matches()) {
                provider = new UstProviderInfo(matcher.group(2).trim());
                provider.setPid(Integer.valueOf(matcher.group(1).trim()).intValue());
                ArrayList<IBaseEventInfo> events = new ArrayList<IBaseEventInfo>();
                ++index;
                index = this.getProviderEventInfo(result.getOutput(), index, events);
                provider.setEvents(events);
                allProviders.add((IUstProviderInfo)provider);
                continue;
            }
            ++index;
        }
        return allProviders;
    }

    @Override
    public ISessionInfo createSession(String sessionName, String sessionPath, IProgressMonitor monitor) throws ExecutionException {
        String newName = this.formatParameter(sessionName);
        String newPath = this.formatParameter(sessionPath);
        StringBuffer command = this.createCommand(" create ", newName);
        if (newPath != null && !"".equals(newPath)) {
            command.append(" -o ");
            command.append(newPath);
        }
        ICommandResult result = this.executeCommand(command.toString(), monitor);
        String[] output = result.getOutput();
        Matcher matcher = LTTngControlServiceConstants.CREATE_SESSION_NAME_PATTERN.matcher(output[0]);
        String name = null;
        if (!matcher.matches()) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command + "\n" + Messages.TraceControl_UnexpectedCommandOutputFormat + ":\n" + LTTngControlService.formatOutput(result));
        }
        name = String.valueOf(matcher.group(1).trim());
        if (name == null || !name.equals(sessionName)) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command + "\n" + Messages.TraceControl_UnexpectedNameError + ": " + name);
        }
        matcher = LTTngControlServiceConstants.CREATE_SESSION_PATH_PATTERN.matcher(output[1]);
        String path = null;
        if (!matcher.matches()) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command + "\n" + Messages.TraceControl_UnexpectedCommandOutputFormat + ":\n" + LTTngControlService.formatOutput(result));
        }
        path = String.valueOf(matcher.group(1).trim());
        if (path == null || sessionPath != null && !path.contains(sessionPath)) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command + "\n" + Messages.TraceControl_UnexpectedPathError + ": " + name);
        }
        SessionInfo sessionInfo = new SessionInfo(name);
        sessionInfo.setSessionPath(path);
        return sessionInfo;
    }

    @Override
    public void destroySession(String sessionName, IProgressMonitor monitor) throws ExecutionException {
        String newName = this.formatParameter(sessionName);
        StringBuffer command = this.createCommand(" destroy ", newName);
        ICommandResult result = this.executeCommand(command.toString(), monitor, false);
        String[] output = result.getOutput();
        if (this.isError(result) && (output == null || !LTTngControlServiceConstants.SESSION_NOT_FOUND_ERROR_PATTERN.matcher(output[0]).matches())) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command.toString() + "\n" + LTTngControlService.formatOutput(result));
        }
    }

    @Override
    public void startSession(String sessionName, IProgressMonitor monitor) throws ExecutionException {
        String newSessionName = this.formatParameter(sessionName);
        StringBuffer command = this.createCommand(" start ", newSessionName);
        this.executeCommand(command.toString(), monitor);
    }

    @Override
    public void stopSession(String sessionName, IProgressMonitor monitor) throws ExecutionException {
        String newSessionName = this.formatParameter(sessionName);
        StringBuffer command = this.createCommand(" stop ", newSessionName);
        this.executeCommand(command.toString(), monitor);
    }

    @Override
    public void enableChannels(String sessionName, List<String> channelNames, boolean isKernel, IChannelInfo info, IProgressMonitor monitor) throws ExecutionException {
        if (channelNames.isEmpty()) {
            return;
        }
        StringBuffer command = this.createCommand(" enable-channel ");
        Iterator<String> iterator = channelNames.iterator();
        while (iterator.hasNext()) {
            String channel = iterator.next();
            command.append(channel);
            if (!iterator.hasNext()) continue;
            command.append(',');
        }
        if (isKernel) {
            command.append(" -k ");
        } else {
            command.append(" -u ");
        }
        String newSessionName = this.formatParameter(sessionName);
        command.append(" -s ");
        command.append(newSessionName);
        if (info != null) {
            if (info.isOverwriteMode()) {
                command.append(" --overwrite ");
            }
            command.append(" --subbuf-size ");
            command.append(String.valueOf(info.getSubBufferSize()));
            command.append(" --num-subbuf ");
            command.append(String.valueOf(info.getNumberOfSubBuffers()));
            command.append(" --switch-timer ");
            command.append(String.valueOf(info.getSwitchTimer()));
            command.append(" --read-timer ");
            command.append(String.valueOf(info.getReadTimer()));
        }
        this.executeCommand(command.toString(), monitor);
    }

    @Override
    public void disableChannels(String sessionName, List<String> channelNames, boolean isKernel, IProgressMonitor monitor) throws ExecutionException {
        if (channelNames.isEmpty()) {
            return;
        }
        StringBuffer command = this.createCommand(" disable-channel ");
        Iterator<String> iterator = channelNames.iterator();
        while (iterator.hasNext()) {
            String channel = iterator.next();
            command.append(channel);
            if (!iterator.hasNext()) continue;
            command.append(',');
        }
        if (isKernel) {
            command.append(" -k ");
        } else {
            command.append(" -u ");
        }
        String newSessionName = this.formatParameter(sessionName);
        command.append(" -s ");
        command.append(newSessionName);
        this.executeCommand(command.toString(), monitor);
    }

    @Override
    public void enableEvents(String sessionName, String channelName, List<String> eventNames, boolean isKernel, IProgressMonitor monitor) throws ExecutionException {
        StringBuffer command = this.createCommand(" enable-event ");
        if (eventNames == null || eventNames.isEmpty()) {
            command.append(" -a ");
        } else {
            StringBuffer eventNameParameter = new StringBuffer();
            Iterator<String> iterator = eventNames.iterator();
            while (iterator.hasNext()) {
                String event = iterator.next();
                eventNameParameter.append(event);
                if (!iterator.hasNext()) continue;
                eventNameParameter.append(',');
            }
            command.append(this.formatParameter(eventNameParameter.toString()));
        }
        if (isKernel) {
            command.append(" -k ");
        } else {
            command.append(" -u ");
        }
        String newSessionName = this.formatParameter(sessionName);
        command.append(" -s ");
        command.append(newSessionName);
        if (channelName != null) {
            command.append(" -c ");
            command.append(channelName);
        }
        command.append(" --tracepoint ");
        this.executeCommand(command.toString(), monitor);
    }

    @Override
    public void enableSyscalls(String sessionName, String channelName, IProgressMonitor monitor) throws ExecutionException {
        StringBuffer command = this.createCommand(" enable-event ");
        command.append(" -a ");
        command.append(" -k ");
        String newSessionName = this.formatParameter(sessionName);
        command.append(" -s ");
        command.append(newSessionName);
        if (channelName != null) {
            command.append(" -c ");
            command.append(channelName);
        }
        command.append(" --syscall ");
        this.executeCommand(command.toString(), monitor);
    }

    @Override
    public void enableProbe(String sessionName, String channelName, String eventName, boolean isFunction, String probe, IProgressMonitor monitor) throws ExecutionException {
        StringBuffer command = this.createCommand(" enable-event ");
        command.append(eventName);
        command.append(" -k ");
        String newSessionName = this.formatParameter(sessionName);
        command.append(" -s ");
        command.append(newSessionName);
        if (channelName != null) {
            command.append(" -c ");
            command.append(channelName);
        }
        if (isFunction) {
            command.append(" --function ");
        } else {
            command.append(" --probe ");
        }
        command.append(probe);
        this.executeCommand(command.toString(), monitor);
    }

    @Override
    public void enableLogLevel(String sessionName, String channelName, String eventName, LogLevelType logLevelType, TraceLogLevel level, IProgressMonitor monitor) throws ExecutionException {
        StringBuffer command = this.createCommand(" enable-event ");
        command.append(eventName);
        command.append(" -u ");
        String newSessionName = this.formatParameter(sessionName);
        command.append(" -s ");
        command.append(newSessionName);
        if (channelName != null) {
            command.append(" -c ");
            command.append(channelName);
        }
        if (logLevelType == LogLevelType.LOGLEVEL) {
            command.append(" --loglevel ");
        } else if (logLevelType == LogLevelType.LOGLEVEL_ONLY) {
            command.append(" --loglevel-only ");
        } else {
            return;
        }
        command.append(level.getInName());
        this.executeCommand(command.toString(), monitor);
    }

    @Override
    public void disableEvent(String sessionName, String channelName, List<String> eventNames, boolean isKernel, IProgressMonitor monitor) throws ExecutionException {
        StringBuffer command = this.createCommand(" disable-event ");
        if (eventNames == null) {
            command.append(" -a ");
        } else {
            if (eventNames.isEmpty()) {
                return;
            }
            StringBuffer eventNameParameter = new StringBuffer();
            Iterator<String> iterator = eventNames.iterator();
            while (iterator.hasNext()) {
                String event = iterator.next();
                eventNameParameter.append(event);
                if (!iterator.hasNext()) continue;
                eventNameParameter.append(',');
            }
            command.append(this.formatParameter(eventNameParameter.toString()));
        }
        if (isKernel) {
            command.append(" -k ");
        } else {
            command.append(" -u ");
        }
        String newSessionName = this.formatParameter(sessionName);
        command.append(" -s ");
        command.append(newSessionName);
        if (channelName != null) {
            command.append(" -c ");
            command.append(channelName);
        }
        this.executeCommand(command.toString(), monitor);
    }

    @Override
    public List<String> getContextList(IProgressMonitor monitor) throws ExecutionException {
        StringBuffer command = this.createCommand(" add-context ", " -h ");
        ICommandResult result = this.executeCommand(command.toString(), monitor);
        String[] output = result.getOutput();
        ArrayList<String> contexts = new ArrayList<String>(0);
        int index = 0;
        boolean inList = false;
        while (index < output.length) {
            String line = result.getOutput()[index];
            Matcher startMatcher = LTTngControlServiceConstants.ADD_CONTEXT_HELP_CONTEXTS_INTRO.matcher(line);
            Matcher endMatcher = LTTngControlServiceConstants.ADD_CONTEXT_HELP_CONTEXTS_END_LINE.matcher(line);
            if (startMatcher.matches()) {
                inList = true;
            } else {
                if (endMatcher.matches()) break;
                if (inList) {
                    String[] tmp = line.split(",");
                    int i = 0;
                    while (i < tmp.length) {
                        contexts.add(tmp[i].trim());
                        ++i;
                    }
                }
            }
            ++index;
        }
        return contexts;
    }

    @Override
    public void addContexts(String sessionName, String channelName, String eventName, boolean isKernel, List<String> contextNames, IProgressMonitor monitor) throws ExecutionException {
        StringBuffer command = this.createCommand(" add-context ");
        String newSessionName = this.formatParameter(sessionName);
        command.append(" -s ");
        command.append(newSessionName);
        if (channelName != null) {
            command.append(" -c ");
            command.append(channelName);
        }
        if (eventName != null) {
            command.append(" -e ");
            command.append(eventName);
        }
        if (isKernel) {
            command.append(" -k ");
        } else {
            command.append(" -u ");
        }
        for (String context : contextNames) {
            command.append(" -t ");
            command.append(context);
        }
        this.executeCommand(command.toString(), monitor);
    }

    @Override
    public void calibrate(boolean isKernel, IProgressMonitor monitor) throws ExecutionException {
        StringBuffer command = this.createCommand(" calibrate ");
        if (isKernel) {
            command.append(" -k ");
        } else {
            command.append(" -u ");
        }
        command.append(" --function ");
        this.executeCommand(command.toString(), monitor);
    }

    protected boolean isError(ICommandResult result) {
        return result.getResult() != 0 || result.getOutput().length < 1 || LTTngControlServiceConstants.ERROR_PATTERN.matcher(result.getOutput()[0]).matches();
    }

    public static String formatOutput(ICommandResult result) {
        if (result == null || result.getOutput() == null || result.getOutput().length == 0) {
            return "";
        }
        String[] output = result.getOutput();
        StringBuffer ret = new StringBuffer();
        ret.append("Return Value: ");
        ret.append(result.getResult());
        ret.append("\n");
        int i = 0;
        while (i < output.length) {
            ret.append(String.valueOf(output[i]) + "\n");
            ++i;
        }
        return ret.toString();
    }

    protected int parseDomain(String[] output, int currentIndex, List<IChannelInfo> channels) {
        int index = currentIndex;
        while (index < output.length) {
            String line = output[index];
            Matcher outerMatcher = LTTngControlServiceConstants.CHANNELS_SECTION_PATTERN.matcher(line);
            if (outerMatcher.matches()) {
                ChannelInfo channelInfo = null;
                while (index < output.length) {
                    String subLine = output[index];
                    Matcher innerMatcher = LTTngControlServiceConstants.CHANNEL_PATTERN.matcher(subLine);
                    if (innerMatcher.matches()) {
                        channelInfo = new ChannelInfo("");
                        channelInfo.setName(innerMatcher.group(1));
                        channelInfo.setState(innerMatcher.group(2));
                        channels.add((IChannelInfo)channelInfo);
                    } else if (LTTngControlServiceConstants.OVERWRITE_MODE_ATTRIBUTE.matcher(subLine).matches()) {
                        String value = this.getAttributeValue(subLine);
                        channelInfo.setOverwriteMode(!"0".equals(value));
                    } else if (LTTngControlServiceConstants.SUBBUFFER_SIZE_ATTRIBUTE.matcher(subLine).matches()) {
                        channelInfo.setSubBufferSize(Long.valueOf(this.getAttributeValue(subLine)).longValue());
                    } else if (LTTngControlServiceConstants.NUM_SUBBUFFERS_ATTRIBUTE.matcher(subLine).matches()) {
                        channelInfo.setNumberOfSubBuffers(Integer.valueOf(this.getAttributeValue(subLine)).intValue());
                    } else if (LTTngControlServiceConstants.SWITCH_TIMER_ATTRIBUTE.matcher(subLine).matches()) {
                        channelInfo.setSwitchTimer(Long.valueOf(this.getAttributeValue(subLine)).longValue());
                    } else if (LTTngControlServiceConstants.READ_TIMER_ATTRIBUTE.matcher(subLine).matches()) {
                        channelInfo.setReadTimer(Long.valueOf(this.getAttributeValue(subLine)).longValue());
                    } else if (LTTngControlServiceConstants.OUTPUT_ATTRIBUTE.matcher(subLine).matches()) {
                        channelInfo.setOutputType(this.getAttributeValue(subLine));
                    } else {
                        if (LTTngControlServiceConstants.EVENT_SECTION_PATTERN.matcher(subLine).matches()) {
                            ArrayList<IEventInfo> events = new ArrayList<IEventInfo>();
                            index = this.parseEvents(output, index, events);
                            channelInfo.setEvents(events);
                            continue;
                        }
                        if (LTTngControlServiceConstants.DOMAIN_KERNEL_PATTERN.matcher(subLine).matches()) {
                            return index;
                        }
                        if (LTTngControlServiceConstants.DOMAIN_UST_GLOBAL_PATTERN.matcher(subLine).matches()) {
                            return index;
                        }
                    }
                    ++index;
                }
            }
            ++index;
        }
        return index;
    }

    protected int parseEvents(String[] output, int currentIndex, List<IEventInfo> events) {
        int index = currentIndex;
        while (index < output.length) {
            EventInfo eventInfo;
            String line = output[index];
            if (LTTngControlServiceConstants.CHANNEL_PATTERN.matcher(line).matches()) {
                return index;
            }
            if (LTTngControlServiceConstants.DOMAIN_KERNEL_PATTERN.matcher(line).matches()) {
                return index;
            }
            if (LTTngControlServiceConstants.DOMAIN_UST_GLOBAL_PATTERN.matcher(line).matches()) {
                return index;
            }
            Matcher matcher = LTTngControlServiceConstants.EVENT_PATTERN.matcher(line);
            Matcher matcher2 = LTTngControlServiceConstants.WILDCARD_EVENT_PATTERN.matcher(line);
            if (matcher.matches()) {
                eventInfo = new EventInfo(matcher.group(1).trim());
                eventInfo.setLogLevel(matcher.group(2).trim());
                eventInfo.setEventType(matcher.group(3).trim());
                eventInfo.setState(matcher.group(4));
                events.add((IEventInfo)eventInfo);
                ++index;
                continue;
            }
            if (matcher2.matches()) {
                eventInfo = new EventInfo(matcher2.group(1).trim());
                eventInfo.setLogLevel(TraceLogLevel.LEVEL_UNKNOWN);
                eventInfo.setEventType(matcher2.group(2).trim());
                eventInfo.setState(matcher2.group(3));
                if (eventInfo.getEventType() == TraceEventType.PROBE) {
                    ProbeEventInfo probeEvent = new ProbeEventInfo(eventInfo.getName());
                    probeEvent.setLogLevel(eventInfo.getLogLevel());
                    probeEvent.setEventType(eventInfo.getEventType());
                    probeEvent.setState(eventInfo.getState());
                    eventInfo = probeEvent;
                    ++index;
                    while (index < output.length) {
                        String probeLine = output[index];
                        Matcher addrMatcher = LTTngControlServiceConstants.PROBE_ADDRESS_PATTERN.matcher(probeLine);
                        Matcher offsetMatcher = LTTngControlServiceConstants.PROBE_OFFSET_PATTERN.matcher(probeLine);
                        Matcher symbolMatcher = LTTngControlServiceConstants.PROBE_SYMBOL_PATTERN.matcher(probeLine);
                        if (addrMatcher.matches()) {
                            String addr = addrMatcher.group(2).trim();
                            probeEvent.setAddress(addr);
                        } else if (offsetMatcher.matches()) {
                            String offset = offsetMatcher.group(2).trim();
                            probeEvent.setOffset(offset);
                        } else if (symbolMatcher.matches()) {
                            String symbol = symbolMatcher.group(2).trim();
                            probeEvent.setSymbol(symbol);
                        } else if (LTTngControlServiceConstants.EVENT_PATTERN.matcher(probeLine).matches() || LTTngControlServiceConstants.WILDCARD_EVENT_PATTERN.matcher(probeLine).matches() || LTTngControlServiceConstants.CHANNEL_PATTERN.matcher(probeLine).matches() || LTTngControlServiceConstants.DOMAIN_KERNEL_PATTERN.matcher(probeLine).matches() || LTTngControlServiceConstants.DOMAIN_UST_GLOBAL_PATTERN.matcher(probeLine).matches()) break;
                        ++index;
                    }
                    events.add((IEventInfo)eventInfo);
                    continue;
                }
                events.add((IEventInfo)eventInfo);
                ++index;
                continue;
            }
            ++index;
        }
        return index;
    }

    protected String getAttributeValue(String line) {
        String[] temp = line.split("\\: ");
        return temp[1];
    }

    protected int getProviderEventInfo(String[] output, int currentIndex, List<IBaseEventInfo> events) {
        int index = currentIndex;
        while (index < output.length) {
            String line = output[index];
            Matcher matcher = LTTngControlServiceConstants.PROVIDER_EVENT_PATTERN.matcher(line);
            if (matcher.matches()) {
                BaseEventInfo eventInfo = new BaseEventInfo(matcher.group(1).trim());
                eventInfo.setLogLevel(matcher.group(2).trim());
                eventInfo.setEventType(matcher.group(3).trim());
                events.add((IBaseEventInfo)eventInfo);
            } else if (LTTngControlServiceConstants.UST_PROVIDER_PATTERN.matcher(line).matches()) {
                return index;
            }
            ++index;
        }
        return index;
    }

    protected String formatParameter(String parameter) {
        if (parameter != null) {
            StringBuffer newString = new StringBuffer();
            newString.append(parameter);
            if (parameter.contains(" ") || parameter.contains("*")) {
                newString.insert(0, "\"");
                newString.append("\"");
            }
            return newString.toString();
        }
        return null;
    }

    protected StringBuffer createCommand(String ... strings) {
        StringBuffer command = new StringBuffer();
        command.append("lttng");
        command.append(this.getTracingGroupOption());
        command.append(this.getVerboseOption());
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            command.append(string);
            ++n2;
        }
        return command;
    }

    protected String getTracingGroupOption() {
        if (!ControlPreferences.getInstance().isDefaultTracingGroup() && !ControlPreferences.getInstance().getTracingGroup().equals("")) {
            return " -g " + ControlPreferences.getInstance().getTracingGroup();
        }
        return "";
    }

    protected String getVerboseOption() {
        if (ControlPreferences.getInstance().isLoggingEnabled()) {
            String level = ControlPreferences.getInstance().getVerboseLevel();
            if ("trace.control.verbose.level.v".equals(level)) {
                return " -v ";
            }
            if ("trace.control.verbose.level.vv".equals(level)) {
                return " -vv ";
            }
            if ("trace.control.verbose.level.vvv".equals(level)) {
                return " -vvv ";
            }
        }
        return "";
    }

    protected ICommandResult executeCommand(String command, IProgressMonitor monitor) throws ExecutionException {
        return this.executeCommand(command, monitor, true);
    }

    protected ICommandResult executeCommand(String command, IProgressMonitor monitor, boolean checkForError) throws ExecutionException {
        if (ControlPreferences.getInstance().isLoggingEnabled()) {
            ControlCommandLogger.log(command);
        }
        ICommandResult result = this.fCommandShell.executeCommand(command.toString(), monitor);
        if (ControlPreferences.getInstance().isLoggingEnabled()) {
            ControlCommandLogger.log(LTTngControlService.formatOutput(result));
        }
        if (this.isError(result)) {
            throw new ExecutionException(String.valueOf(Messages.TraceControl_CommandError) + " " + command.toString() + "\n" + LTTngControlService.formatOutput(result));
        }
        return result;
    }
}

