/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.service;

import java.util.regex.Matcher;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.logging.ControlCommandLogger;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.preferences.ControlPreferences;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.remote.ICommandResult;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.remote.ICommandShell;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.service.ILttngControlService;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.service.LTTngControlService;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.service.LTTngControlServiceConstants;

public class LTTngControlServiceFactory {
    private static LTTngControlServiceFactory fInstance = null;

    private LTTngControlServiceFactory() {
    }

    public static synchronized LTTngControlServiceFactory getInstance() {
        if (fInstance == null) {
            fInstance = new LTTngControlServiceFactory();
        }
        return fInstance;
    }

    public ILttngControlService getLttngControlService(ICommandShell shell) throws ExecutionException {
        String command = "lttng version ";
        if (ControlPreferences.getInstance().isLoggingEnabled()) {
            ControlCommandLogger.log(command);
        }
        ICommandResult result = shell.executeCommand(command, (IProgressMonitor)new NullProgressMonitor());
        if (ControlPreferences.getInstance().isLoggingEnabled()) {
            ControlCommandLogger.log(LTTngControlService.formatOutput(result));
        }
        if (result != null && result.getResult() == 0 && result.getOutput().length >= 1 && !LTTngControlServiceConstants.ERROR_PATTERN.matcher(result.getOutput()[0]).matches()) {
            int index = 0;
            while (index < result.getOutput().length) {
                String line = result.getOutput()[index];
                Matcher matcher = LTTngControlServiceConstants.VERSION_PATTERN.matcher(line);
                if (matcher.matches()) {
                    String version = matcher.group(1).trim();
                    if (version.startsWith("2.0")) {
                        LTTngControlService service = new LTTngControlService(shell);
                        service.setVersion(version);
                        return service;
                    }
                    throw new ExecutionException(String.valueOf(Messages.TraceControl_UnsupportedVersionError) + ": " + version);
                }
                ++index;
            }
        }
        throw new ExecutionException(Messages.TraceControl_GettingVersionError);
    }
}

