package org.eclipse.linuxtools.internal.oprofile.remote.launch.configuration;

import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.linuxtools.internal.oprofile.core.IOpcontrolProvider;
import org.eclipse.linuxtools.internal.oprofile.core.IOpcontrolProvider2;
import org.eclipse.linuxtools.internal.oprofile.core.OpcontrolException;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileCorePlugin;
import org.eclipse.linuxtools.internal.oprofile.launch.configuration.OprofileCounter;
import org.eclipse.linuxtools.internal.oprofile.launch.configuration.OprofileEventConfigTab;
import org.eclipse.swt.widgets.Button;


/**
 * Thic class represents the event configuration tab of the launcher dialog.
 * @since 1.1
 */
public class OprofileRemoteEventConfigTab extends OprofileEventConfigTab  {
	protected Button defaultEventCheck;
	protected OprofileCounter[] counters = null;
	protected CounterSubTab[] counterSubTabs;
	private Boolean hasPermissions = null;


	public OprofileRemoteEventConfigTab(){
	}

	protected boolean hasPermissions(IProject project){
		try{
			if (this.hasPermissions == null){
				IOpcontrolProvider provider = OprofileCorePlugin.getDefault().getOpcontrolProvider();
				if (provider instanceof IOpcontrolProvider2)
					this.hasPermissions = ((IOpcontrolProvider2)provider).hasPermissions(project);
				else
					this.hasPermissions = true;
			}
		} catch(OpcontrolException e){
			return false;
		}
		return this.hasPermissions;

	}

	public void initializeFrom(ILaunchConfiguration config) {
		// Force re-check of permissions every time the view is initialized
		this.hasPermissions = null;
		super.initializeFrom(config);
	}
}
