/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.remote.launch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.linuxtools.internal.perf.PerfCore;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PerfEventsTab
extends org.eclipse.linuxtools.internal.perf.launch.PerfEventsTab {
    private int rawTabIndex = 0;
    private int bpTabIndex = 0;
    private String[] tabNames = null;
    private Composite top;

    @Override
    public void createControl(Composite parent) {
        this.top = new Composite(parent, 0);
        this.setControl((Control)this.top);
        this.top.setLayout((Layout)new GridLayout());
        this.createVerticalSpacer(this.top, 1);
        this._chkDefaultEvent = new Button(this.top, 32);
        this._chkDefaultEvent.setText("Default Event");
        this._chkDefaultEvent.setLayoutData((Object)new GridData());
        this._chkDefaultEvent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                PerfEventsTab.this.refreshDefaultEnabled();
                PerfEventsTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createVerticalSpacer(this.top, 1);
    }

    @Override
    public void initializeFrom(ILaunchConfiguration config) {
        TableItem x;
        HashMap<String, ArrayList<String>> events = PerfCore.getEventList(config);
        if (this.tabNames == null) {
            this.tabNames = events.keySet().toArray(new String[events.keySet().size()]);
            this._eventTabItems = new TabItem[this.tabNames.length];
            this._eventTabLists = new Table[this.tabNames.length];
            this._tabFolder = new TabFolder(this.top, 0);
            this._tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
            int i = 0;
            while (i < this.tabNames.length) {
                this._eventTabItems[i] = new TabItem(this._tabFolder, 0);
                this._eventTabItems[i].setText(this.tabNames[i]);
                if (this.tabNames[i].equals("Hardware breakpoint") || this.tabNames[i].equals("Raw hardware event descriptor")) {
                    Table eventList;
                    Composite c = new Composite((Composite)this._tabFolder, 0);
                    c.setLayout((Layout)new GridLayout(2, false));
                    this._eventTabLists[i] = eventList = new Table(c, 34);
                    eventList.setLayoutData((Object)new GridData(4, 4, true, true));
                    eventList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent se) {
                            PerfEventsTab.this.updateLaunchConfigurationDialog();
                        }
                    });
                    Composite composite = new Composite(c, 0);
                    composite.setLayout((Layout)new GridLayout(2, false));
                    composite.setLayoutData((Object)new GridData(131072, 4, false, true));
                    Label l = new Label(composite, 0);
                    l.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
                    Text t = new Text(composite, 2052);
                    t.setLayoutData((Object)new GridData(4, 128, true, false));
                    if (this.tabNames[i].equals("Hardware breakpoint")) {
                        this.bpTabIndex = i;
                        this._bpText = t;
                        l.setText("Please enter the hardware breakpoint in the form mem:<addr>[:access].");
                    }
                    if (this.tabNames[i].equals("Raw hardware event descriptor")) {
                        this.rawTabIndex = i;
                        this._rawText = t;
                        l.setText("Please enter the raw register encoding in the form rNNN.");
                    }
                    Button b = new Button(composite, 8);
                    b.setText("      Add       ");
                    b.setLayoutData((Object)new GridData(131072, 128, false, false));
                    b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent se) {
                            int i = PerfEventsTab.this._tabFolder.getSelectionIndex();
                            if (PerfEventsTab.this.rawTabIndex == i) {
                                new TableItem(PerfEventsTab.this._eventTabLists[i], 0).setText(PerfEventsTab.this._rawText.getText());
                            } else if (PerfEventsTab.this.bpTabIndex == i) {
                                new TableItem(PerfEventsTab.this._eventTabLists[i], 0).setText(PerfEventsTab.this._bpText.getText());
                            }
                            PerfEventsTab.this.updateLaunchConfigurationDialog();
                        }
                    });
                    l = new Label(composite, 0);
                    l.setForeground(new Color((Device)composite.getDisplay(), 100, 100, 100));
                    if (this.tabNames[i].equals("Hardware breakpoint")) {
                        l.setText("For example, .........");
                    }
                    if (this.tabNames[i].equals("Raw hardware event descriptor")) {
                        l.setText("For example, r1a8");
                    }
                    l.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
                    l = new Label(composite, 0);
                    l.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
                    b = new Button(composite, 8);
                    b.setText("Remove Selected Events");
                    b.setLayoutData((Object)new GridData(4, 1024, true, false, 2, 1));
                    b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent se) {
                            PerfEventsTab.this._eventTabLists[PerfEventsTab.this._tabFolder.getSelectionIndex()].remove(PerfEventsTab.this._eventTabLists[PerfEventsTab.this._tabFolder.getSelectionIndex()].getSelectionIndices());
                            PerfEventsTab.this.updateLaunchConfigurationDialog();
                        }
                    });
                    l = new Label(composite, 0);
                    l.setForeground(new Color((Device)composite.getDisplay(), 100, 100, 100));
                    l.setText("Note: Select by highlighting, not by checking.");
                    l.setLayoutData((Object)new GridData(4, 1024, true, false, 2, 1));
                    this._eventTabItems[i].setControl((Control)c);
                } else {
                    Table eventList;
                    this._eventTabLists[i] = eventList = new Table((Composite)this._tabFolder, 32);
                    ArrayList<String> evlist = events.get(this.tabNames[i]);
                    for (String string : evlist) {
                        x = new TableItem(eventList, 0);
                        x.setText(string);
                    }
                    eventList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent se) {
                            PerfEventsTab.this.updateLaunchConfigurationDialog();
                        }
                    });
                    this._eventTabItems[i].setControl((Control)eventList);
                }
                ++i;
            }
        }
        try {
            List selectedEvents;
            List rawhe;
            this._chkDefaultEvent.setSelection(config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.DefaultEvent", true));
            this.refreshDefaultEnabled();
            List hwbps = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.HwBreakpointEvents", PerfPlugin.ATTR_HwBreakpointEvents_default);
            if (hwbps != null) {
                int i = 0;
                while (i < this._eventTabLists.length) {
                    if (this._eventTabItems[i].getText().equals("Hardware breakpoint")) {
                        this._eventTabLists[i].removeAll();
                        for (Object e : hwbps) {
                            TableItem x2 = new TableItem(this._eventTabLists[i], 0);
                            x2.setText((String)e);
                        }
                    }
                    ++i;
                }
            }
            if ((rawhe = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.RawHwEvents", PerfPlugin.ATTR_RawHwEvents_default)) != null) {
                int i = 0;
                while (i < this._eventTabLists.length) {
                    if (this._eventTabItems[i].getText().equals("Raw hardware event descriptor")) {
                        this._eventTabLists[i].removeAll();
                        for (Object e : rawhe) {
                            x = new TableItem(this._eventTabLists[i], 0);
                            x.setText((String)e);
                        }
                    }
                    ++i;
                }
            }
            if ((selectedEvents = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.SelectedEvents", PerfPlugin.ATTR_SelectedEvents_default)) != null) {
                for (Object e : selectedEvents) {
                    int i = 0;
                    while (i < this._eventTabLists.length) {
                        TableItem[] tableItemArray = this._eventTabLists[i].getItems();
                        int n = tableItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableItem x3 = tableItemArray[n2];
                            if (x3.getText().equals(e)) {
                                x3.setChecked(true);
                            }
                            ++n2;
                        }
                        ++i;
                    }
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

