/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.launch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.linuxtools.internal.perf.PerfCore;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PerfEventsTab
extends AbstractLaunchConfigurationTab {
    protected Button _chkDefaultEvent;
    protected TabItem[] _eventTabItems;
    protected Table[] _eventTabLists;
    protected TabFolder _tabFolder;
    private int rawTabIndex = 0;
    private int bpTabIndex = 0;
    protected Text _rawText;
    protected Text _bpText;

    public Image getImage() {
        return PerfPlugin.getImageDescriptor("icons/event.gif").createImage();
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        this.setControl((Control)top);
        top.setLayout((Layout)new GridLayout());
        this.createVerticalSpacer(top, 1);
        this._chkDefaultEvent = new Button(top, 32);
        this._chkDefaultEvent.setText("Default Event");
        this._chkDefaultEvent.setLayoutData((Object)new GridData());
        this._chkDefaultEvent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                PerfEventsTab.this.refreshDefaultEnabled();
                PerfEventsTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createVerticalSpacer(top, 1);
        HashMap<String, ArrayList<String>> events = PerfCore.getEventList();
        String[] tabNames = events.keySet().toArray(new String[events.keySet().size()]);
        this._eventTabItems = new TabItem[tabNames.length];
        this._eventTabLists = new Table[tabNames.length];
        this._tabFolder = new TabFolder(top, 0);
        this._tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        int i = 0;
        while (i < tabNames.length) {
            this._eventTabItems[i] = new TabItem(this._tabFolder, 0);
            this._eventTabItems[i].setText(tabNames[i]);
            if (tabNames[i].equals("Hardware breakpoint") || tabNames[i].equals("Raw hardware event descriptor")) {
                Table eventList;
                Composite c = new Composite((Composite)this._tabFolder, 0);
                c.setLayout((Layout)new GridLayout(2, false));
                this._eventTabLists[i] = eventList = new Table(c, 34);
                eventList.setLayoutData((Object)new GridData(4, 4, true, true));
                eventList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent se) {
                        PerfEventsTab.this.updateLaunchConfigurationDialog();
                    }
                });
                Composite right = new Composite(c, 0);
                right.setLayout((Layout)new GridLayout(2, false));
                right.setLayoutData((Object)new GridData(131072, 4, false, true));
                Label l = new Label(right, 0);
                l.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
                Text t = new Text(right, 2052);
                t.setLayoutData((Object)new GridData(4, 128, true, false));
                if (tabNames[i].equals("Hardware breakpoint")) {
                    this.bpTabIndex = i;
                    this._bpText = t;
                    l.setText("Please enter the hardware breakpoint in the form mem:<addr>[:access].");
                }
                if (tabNames[i].equals("Raw hardware event descriptor")) {
                    this.rawTabIndex = i;
                    this._rawText = t;
                    l.setText("Please enter the raw register encoding in the form rNNN.");
                }
                Button b = new Button(right, 8);
                b.setText("      Add       ");
                b.setLayoutData((Object)new GridData(131072, 128, false, false));
                b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent se) {
                        int i = PerfEventsTab.this._tabFolder.getSelectionIndex();
                        if (PerfEventsTab.this.rawTabIndex == i) {
                            new TableItem(PerfEventsTab.this._eventTabLists[i], 0).setText(PerfEventsTab.this._rawText.getText());
                        } else if (PerfEventsTab.this.bpTabIndex == i) {
                            new TableItem(PerfEventsTab.this._eventTabLists[i], 0).setText(PerfEventsTab.this._bpText.getText());
                        }
                        PerfEventsTab.this.updateLaunchConfigurationDialog();
                    }
                });
                l = new Label(right, 0);
                l.setForeground(new Color((Device)right.getDisplay(), 100, 100, 100));
                if (tabNames[i].equals("Hardware breakpoint")) {
                    l.setText("For example, .........");
                }
                if (tabNames[i].equals("Raw hardware event descriptor")) {
                    l.setText("For example, r1a8");
                }
                l.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
                l = new Label(right, 0);
                l.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
                b = new Button(right, 8);
                b.setText("Remove Selected Events");
                b.setLayoutData((Object)new GridData(4, 1024, true, false, 2, 1));
                b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent se) {
                        PerfEventsTab.this._eventTabLists[PerfEventsTab.this._tabFolder.getSelectionIndex()].remove(PerfEventsTab.this._eventTabLists[PerfEventsTab.this._tabFolder.getSelectionIndex()].getSelectionIndices());
                        PerfEventsTab.this.updateLaunchConfigurationDialog();
                    }
                });
                l = new Label(right, 0);
                l.setForeground(new Color((Device)right.getDisplay(), 100, 100, 100));
                l.setText("Note: Select by highlighting, not by checking.");
                l.setLayoutData((Object)new GridData(4, 1024, true, false, 2, 1));
                this._eventTabItems[i].setControl((Control)c);
            } else {
                Table eventList;
                this._eventTabLists[i] = eventList = new Table((Composite)this._tabFolder, 32);
                ArrayList<String> evlist = events.get(tabNames[i]);
                for (String e : evlist) {
                    TableItem x = new TableItem(eventList, 0);
                    x.setText(e);
                }
                eventList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent se) {
                        PerfEventsTab.this.updateLaunchConfigurationDialog();
                    }
                });
                this._eventTabItems[i].setControl((Control)eventList);
            }
            ++i;
        }
    }

    public void refreshDefaultEnabled() {
        boolean state = !this._chkDefaultEvent.getSelection();
        Table[] tableArray = this._eventTabLists;
        int n = this._eventTabLists.length;
        int n2 = 0;
        while (n2 < n) {
            Table tab = tableArray[n2];
            tab.setEnabled(state);
            ++n2;
        }
    }

    public String getName() {
        return "Perf Events";
    }

    public boolean canSave() {
        return this.isValid();
    }

    public boolean isValid() {
        return true;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            List selectedEvents;
            List rawhe;
            this._chkDefaultEvent.setSelection(config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.DefaultEvent", true));
            this.refreshDefaultEnabled();
            List hwbps = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.HwBreakpointEvents", PerfPlugin.ATTR_HwBreakpointEvents_default);
            if (hwbps != null) {
                int i = 0;
                while (i < this._eventTabLists.length) {
                    if (this._eventTabItems[i].getText().equals("Hardware breakpoint")) {
                        this._eventTabLists[i].removeAll();
                        for (Object e : hwbps) {
                            TableItem x = new TableItem(this._eventTabLists[i], 0);
                            x.setText((String)e);
                        }
                    }
                    ++i;
                }
            }
            if ((rawhe = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.RawHwEvents", PerfPlugin.ATTR_RawHwEvents_default)) != null) {
                int i = 0;
                while (i < this._eventTabLists.length) {
                    if (this._eventTabItems[i].getText().equals("Raw hardware event descriptor")) {
                        this._eventTabLists[i].removeAll();
                        for (Object e : rawhe) {
                            TableItem x = new TableItem(this._eventTabLists[i], 0);
                            x.setText((String)e);
                        }
                    }
                    ++i;
                }
            }
            if ((selectedEvents = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.SelectedEvents", PerfPlugin.ATTR_SelectedEvents_default)) != null) {
                for (Object s : selectedEvents) {
                    int i = 0;
                    while (i < this._eventTabLists.length) {
                        TableItem[] tableItemArray = this._eventTabLists[i].getItems();
                        int n = tableItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableItem x = tableItemArray[n2];
                            if (x.getText().equals(s)) {
                                x.setChecked(true);
                            }
                            ++n2;
                        }
                        ++i;
                    }
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy wconfig) {
        int n;
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.DefaultEvent", this._chkDefaultEvent.getSelection());
        ArrayList<String> selectedEvents = new ArrayList<String>();
        int i = 0;
        while (i < this._eventTabLists.length) {
            TableItem[] tableItemArray = this._eventTabLists[i].getItems();
            n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem x = tableItemArray[n2];
                if (x.getChecked()) {
                    selectedEvents.add(x.getText());
                }
                ++n2;
            }
            ++i;
        }
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.SelectedEvents", selectedEvents);
        if (!this._chkDefaultEvent.getSelection() && selectedEvents.size() >= 1) {
            wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.MultipleEvents", true);
        } else {
            wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.MultipleEvents", false);
        }
        if (selectedEvents.size() <= 0) {
            wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.DefaultEvent", true);
        }
        ArrayList<String> hwbps = new ArrayList<String>();
        int i2 = 0;
        while (i2 < this._eventTabLists.length) {
            if (this._eventTabItems[i2].getText().equals("Hardware breakpoint")) {
                TableItem[] tableItemArray = this._eventTabLists[i2].getItems();
                int n3 = tableItemArray.length;
                n = 0;
                while (n < n3) {
                    TableItem x = tableItemArray[n];
                    hwbps.add(x.getText());
                    ++n;
                }
            }
            ++i2;
        }
        if (hwbps.size() == 0) {
            hwbps = null;
        }
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.HwBreakpointEvents", hwbps);
        ArrayList<String> rawhwe = new ArrayList<String>();
        int i3 = 0;
        while (i3 < this._eventTabLists.length) {
            if (this._eventTabItems[i3].getText().equals("Raw hardware event descriptor")) {
                TableItem[] tableItemArray = this._eventTabLists[i3].getItems();
                int n4 = tableItemArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    TableItem x = tableItemArray[n5];
                    rawhwe.add(x.getText());
                    ++n5;
                }
            }
            ++i3;
        }
        if (rawhwe.size() == 0) {
            rawhwe = null;
        }
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.RawHwEvents", rawhwe);
        try {
            if (this.canSave()) {
                wconfig.doSave();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy wconfig) {
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.DefaultEvent", true);
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.SelectedEvents", PerfPlugin.ATTR_SelectedEvents_default);
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.HwBreakpointEvents", PerfPlugin.ATTR_HwBreakpointEvents_default);
        wconfig.setAttribute("org.eclipse.linuxtools.internal.perf.attr.RawHwEvents", PerfPlugin.ATTR_RawHwEvents_default);
        try {
            if (this.canSave()) {
                wconfig.doSave();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

