/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.profiling.launch.remote;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.linuxtools.internal.profiling.launch.remote.RemoteCommandShellOperation;
import org.eclipse.linuxtools.internal.profiling.launch.remote.RemoteLaunchConstants;
import org.eclipse.linuxtools.internal.profiling.launch.remote.RemoteMessages;
import org.eclipse.linuxtools.profiling.launch.remote.RemoteConnectionException;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemStartHere;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteConnection {
    private ILaunchConfiguration config;
    private IHost rseHost;
    private IRemoteFileSubSystem fs;
    private IRemoteCmdSubSystem rcs;
    private String hostName;

    public RemoteConnection(ILaunchConfiguration config) throws RemoteConnectionException {
        this.config = config;
        this.initialize();
    }

    public RemoteConnection(String hostName) throws RemoteConnectionException {
        this.config = null;
        this.hostName = hostName;
        this.initialize();
    }

    private void initialize() throws RemoteConnectionException {
        try {
            RSECorePlugin.waitForInitCompletion();
        }
        catch (InterruptedException e2) {
            throw new RemoteConnectionException(RemoteMessages.RemoteLaunchDelegate_error_interrupted, e2);
        }
        ISystemRegistry registry = SystemStartHere.getSystemRegistry();
        if (this.hostName == null) {
            if (this.config != null) {
                try {
                    this.hostName = this.config.getAttribute("org.eclipse.linuxtools.profiling.launch.remote.REMOTE_HOSTID", RemoteLaunchConstants.DEFAULT_REMOTE_HOSTID);
                }
                catch (CoreException e1) {
                    throw new RemoteConnectionException(RemoteMessages.RemoteLaunchDelegate_error_launch_failed, e1);
                }
            } else {
                throw new RemoteConnectionException(RemoteMessages.RemoteLaunchDelegate_error_no_host, null);
            }
        }
        if (this.hostName == null) {
            throw new RemoteConnectionException(RemoteMessages.RemoteLaunchDelegate_error_no_host, null);
        }
        IHost[] hosts = registry.getHosts();
        int i = 0;
        while (i < hosts.length) {
            IHost host = hosts[i];
            if (host.getName().equals(this.hostName)) {
                this.rseHost = host;
                break;
            }
            ++i;
        }
        if (this.rseHost == null) {
            throw new RemoteConnectionException(RemoteMessages.RemoteLaunchDelegate_error_no_host, null);
        }
        ISubSystem[] subSystems = registry.getSubSystems(this.rseHost);
        int i2 = 0;
        while (i2 < subSystems.length) {
            ISubSystem subSystem = subSystems[i2];
            if (subSystem instanceof IRemoteFileSubSystem) {
                this.fs = (IRemoteFileSubSystem)subSystem;
            } else if (subSystem instanceof IRemoteCmdSubSystem) {
                this.rcs = (IRemoteCmdSubSystem)subSystem;
            }
            ++i2;
        }
        try {
            this.fs.connect((IProgressMonitor)new NullProgressMonitor(), false);
        }
        catch (Exception e) {
            throw new RemoteConnectionException(RemoteMessages.RemoteLaunchDelegate_error_no_fs, e);
        }
    }

    public String getId() {
        return this.rseHost.getName();
    }

    public void upload(IPath localPath, IPath remotePath, IProgressMonitor monitor) throws RemoteConnectionException {
        File f = localPath.toFile();
        this.uploadRecursive(f, remotePath, monitor);
    }

    private void uploadRecursive(File f, IPath remotePath, IProgressMonitor monitor) throws RemoteConnectionException {
        try {
            if (f.isDirectory()) {
                File[] children = f.listFiles();
                int i = 0;
                while (i < children.length) {
                    File child = children[i];
                    if (child.isDirectory()) {
                        IPath remoteChildPath = remotePath.append(child.getName());
                        this.createFolder(remoteChildPath, monitor);
                        this.uploadRecursive(child, remoteChildPath, monitor);
                    }
                    ++i;
                }
            } else {
                this.fs.upload(f.getAbsolutePath().toString(), "UTF-8", remotePath.append(f.getName()).toString(), "UTF-8", monitor);
            }
        }
        catch (SystemMessageException e1) {
            throw new RemoteConnectionException(e1.getLocalizedMessage(), e1);
        }
    }

    public void createFolder(IPath remoteFolderPath, IProgressMonitor monitor) throws RemoteConnectionException {
        try {
            IRemoteFile rf = this.fs.getRemoteFileObject(remoteFolderPath.toString(), monitor);
            this.fs.createFolder(rf, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (SystemMessageException e1) {
            throw new RemoteConnectionException(e1.getLocalizedMessage(), e1);
        }
    }

    public int runCommand(String command, IPath remoteWorkingDir, ArrayList<String> output, IProgressMonitor monitor) throws RemoteConnectionException {
        try {
            IRemoteFile rf = this.fs.getRemoteFileObject(remoteWorkingDir.toString(), monitor);
            RemoteCommand rc = new RemoteCommand(this.rcs, rf);
            IRemoteCommandShell shell = rc.run();
            rc.sendCommand(command);
            while (!rc.isFinished() && !monitor.isCanceled()) {
                Thread.sleep(100L);
            }
            rc.finish();
            int i = 0;
            while (i < shell.getSize()) {
                Object outputLine = shell.getOutputAt(i);
                output.add(outputLine.toString());
                ++i;
            }
            return rc.getReturnCode();
        }
        catch (Exception e1) {
            throw new RemoteConnectionException(e1.getLocalizedMessage(), e1);
        }
    }

    public void delete(IPath remotePath, IProgressMonitor monitor) throws RemoteConnectionException {
        try {
            IRemoteFile rf = this.fs.getRemoteFileObject(remotePath.toString(), monitor);
            this.deleteRecursive(rf, monitor);
        }
        catch (SystemMessageException e1) {
            throw new RemoteConnectionException(e1.getLocalizedMessage(), e1);
        }
    }

    private void deleteRecursive(IRemoteFile rf, IProgressMonitor monitor) throws RemoteConnectionException {
        try {
            if (rf.isDirectory()) {
                IRemoteFile[] children = this.fs.list(rf, 0, monitor);
                int i = 0;
                while (i < children.length) {
                    IRemoteFile remotelogfile = children[i];
                    this.deleteRecursive(remotelogfile, monitor);
                    ++i;
                }
            }
            this.fs.delete(rf, monitor);
        }
        catch (SystemMessageException e1) {
            throw new RemoteConnectionException(e1.getLocalizedMessage(), e1);
        }
    }

    public void download(IPath remotePath, IPath localPath, IProgressMonitor monitor) throws RemoteConnectionException {
        try {
            IRemoteFile rf = this.fs.getRemoteFileObject(remotePath.toString(), monitor);
            this.downloadRecursive(rf, localPath, monitor);
        }
        catch (SystemMessageException e1) {
            throw new RemoteConnectionException(e1.getLocalizedMessage(), e1);
        }
    }

    private void downloadRecursive(IRemoteFile rf, IPath localPath, IProgressMonitor monitor) throws RemoteConnectionException {
        try {
            if (rf.isDirectory()) {
                IPath dirPath = localPath;
                IRemoteFile[] children = this.fs.list(rf, 0, monitor);
                int i = 0;
                while (i < children.length) {
                    IRemoteFile remotelogfile = children[i];
                    if (remotelogfile.isDirectory()) {
                        dirPath = localPath.append(remotelogfile.getName());
                        File f = dirPath.toFile();
                        f.mkdir();
                    }
                    this.downloadRecursive(remotelogfile, dirPath, monitor);
                    ++i;
                }
            } else {
                this.fs.download(rf, localPath.append(rf.getName()).toString(), "UTF-8", monitor);
            }
        }
        catch (SystemMessageException e1) {
            throw new RemoteConnectionException(e1.getLocalizedMessage(), e1);
        }
    }

    private class RemoteCommand
    extends RemoteCommandShellOperation {
        private boolean finished;

        public RemoteCommand(IRemoteCmdSubSystem cmdSubSystem, IRemoteFile pwd) {
            super(cmdSubSystem, pwd);
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void handleCommandFinished(String cmd) {
            this.finished = true;
        }

        public void handleOutputChanged(String command, Object output) {
        }

        public void finish() {
            super.finish();
            if (this._remoteCmdShell != null && this._cmdSubSystem != null && !this._remoteCmdShell.isActive()) {
                try {
                    this._cmdSubSystem.removeShell((Object)this._remoteCmdShell);
                }
                catch (Exception exception) {}
            }
        }
    }
}

