/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.profiling.launch.remote;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.linuxtools.internal.profiling.launch.remote.ProfileRemoteLaunchPlugin;
import org.eclipse.linuxtools.internal.profiling.launch.remote.RemoteLaunchConstants;
import org.eclipse.linuxtools.internal.profiling.launch.remote.RemoteMessages;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemModelChangeEvent;
import org.eclipse.rse.core.events.ISystemModelChangeListener;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemStartHere;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public abstract class RemoteTab
extends AbstractLaunchConfigurationTab {
    private TableViewer tableViewer;
    private boolean isInitializing;
    private IHost[] hosts;
    private String name;

    public RemoteTab(String name) {
        this.name = name;
        ISystemRegistry registry = SystemStartHere.getSystemRegistry();
        this.hosts = registry.getHosts();
        registry.addSystemModelChangeListener((ISystemModelChangeListener)new RemoteModelListener());
    }

    protected void localCreateControl(Composite top) {
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout());
        top.setLayoutData((Object)new GridData(4, 4, true, true));
        Label peersLabel = new Label(top, 0);
        peersLabel.setText(RemoteMessages.RemoteTab_label_hosts);
        this.tableViewer = new TableViewer(top, 67584);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(4, 1, true, false));
        String[] titles = new String[]{RemoteMessages.RemoteTab_header_name, RemoteMessages.RemoteTab_header_hostname, RemoteMessages.RemoteTab_header_type};
        int[] bounds = new int[]{200, 100, 250, 100};
        int i = 0;
        while (i < titles.length) {
            TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
            column.getColumn().setText(titles[i]);
            column.getColumn().setWidth(bounds[i]);
            column.getColumn().setResizable(true);
            column.getColumn().setMoveable(true);
            ++i;
        }
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new RemoteSystemLabelProvider());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RemoteTab.this.updateLaunchConfigurationDialog();
            }
        });
        while (!RSECorePlugin.isInitComplete((int)0)) {
            try {
                RSECorePlugin.waitForInitCompletion();
            }
            catch (InterruptedException interruptedException) {}
        }
        ISystemRegistry registry = SystemStartHere.getSystemRegistry();
        this.hosts = registry.getHosts();
        this.tableViewer.setInput((Object)this.hosts);
        this.localCreateControl(top);
        this.setControl((Control)top);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.linuxtools.profiling.launch.remote.REMOTE_HOSTID", RemoteLaunchConstants.DEFAULT_REMOTE_HOSTID);
    }

    public void localInitializeFrom(ILaunchConfiguration configuration) throws CoreException {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.isInitializing = true;
        try {
            String hostID = configuration.getAttribute("org.eclipse.linuxtools.profiling.launch.remote.REMOTE_HOSTID", RemoteLaunchConstants.DEFAULT_REMOTE_HOSTID);
            if (hostID != null) {
                IHost[] hosts = (IHost[])this.tableViewer.getInput();
                int i = 0;
                while (i < hosts.length) {
                    if (hosts[i].getName().equals(hostID)) {
                        this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)hosts[i]));
                    }
                    ++i;
                }
            }
            this.localInitializeFrom(configuration);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.isInitializing = false;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        IHost host;
        ISelection selected = this.tableViewer.getSelection();
        if (selected == null) {
            configuration.setAttribute("org.eclipse.linuxtools.profiling.launch.remote.REMOTE_HOSTID", null);
        } else if (selected instanceof IStructuredSelection && (host = (IHost)((IStructuredSelection)selected).getFirstElement()) != null) {
            configuration.setAttribute("org.eclipse.linuxtools.profiling.launch.remote.REMOTE_HOSTID", host.getName());
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        boolean valid = false;
        ISelection selected = this.tableViewer.getSelection();
        valid = selected != null && selected instanceof IStructuredSelection && !((IStructuredSelection)selected).isEmpty();
        return valid;
    }

    public String getName() {
        return this.name;
    }

    public Image getImage() {
        return ProfileRemoteLaunchPlugin.imageDescriptorFromPlugin((String)"org.eclipse.linuxtools.profiling.launch.remote", (String)"icons/system_view.gif").createImage();
    }

    protected void updateLaunchConfigurationDialog() {
        if (!this.isInitializing) {
            super.updateLaunchConfigurationDialog();
        }
    }

    private void refreshViewer() {
        if (this.tableViewer != null && this.tableViewer.getContentProvider() != null) {
            this.tableViewer.setInput((Object)this.hosts);
            this.tableViewer.refresh();
        }
    }

    private class RemoteModelListener
    implements ISystemModelChangeListener {
        private RemoteModelListener() {
        }

        public void systemModelResourceChanged(ISystemModelChangeEvent arg0) {
            ISystemRegistry registry = SystemStartHere.getSystemRegistry();
            RemoteTab.this.hosts = registry.getHosts();
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    RemoteTab.this.refreshViewer();
                }
            });
        }
    }

    private class RemoteSystemLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private RemoteSystemLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = null;
            IHost host = (IHost)element;
            switch (columnIndex) {
                case 0: {
                    text = host.getName();
                    break;
                }
                case 1: {
                    text = host.getHostName();
                    break;
                }
                case 2: {
                    text = host.getSystemType().getLabel();
                }
            }
            return text;
        }
    }
}

