/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.profiling.launch.ui.rdt.proxy;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.linuxtools.profiling.launch.ui.IRemoteResourceSelectorProxy;
import org.eclipse.linuxtools.profiling.launch.ui.rdt.proxy.Activator;
import org.eclipse.linuxtools.profiling.launch.ui.rdt.proxy.Messages;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.ui.IRemoteUIFileManager;
import org.eclipse.ptp.remote.ui.IRemoteUIServices;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.swt.widgets.Shell;

public class RDTResourceSelectorProxy
implements IRemoteResourceSelectorProxy {
    private URI getEmptyPathURI(String scheme) {
        try {
            return new URI(scheme, null, "/", null);
        }
        catch (URISyntaxException e) {
            Activator.log(4, Messages.RDTResourceSelectorProxy_URI_syntax_error, e);
            return null;
        }
    }

    private URI selectResource(String scheme, String initialPath, String prompt, Shell shell, ResourceType resourceType) {
        URI uri;
        boolean schemeSwitch = false;
        try {
            uri = new URI(initialPath);
            if (!scheme.equals(uri.getScheme())) {
                uri = this.getEmptyPathURI(scheme);
                schemeSwitch = true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            uri = this.getEmptyPathURI(scheme);
            schemeSwitch = true;
        }
        IRemoteServices services = PTPRemoteCorePlugin.getDefault().getRemoteServices(uri);
        services.initialize();
        IRemoteUIServices uiServices = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(services);
        IRemoteUIFileManager uiFileManager = uiServices.getUIFileManager();
        uiFileManager.showConnections(true);
        IRemoteConnection connection = null;
        if (!schemeSwitch) {
            connection = services.getConnectionManager().getConnection(uri);
            uiFileManager.setConnection(connection);
        }
        String selectedPath = null;
        switch (resourceType) {
            case FILE: {
                selectedPath = uiFileManager.browseFile(shell, prompt, uri.getPath(), 0);
                break;
            }
            case DIRECTORY: {
                selectedPath = uiFileManager.browseDirectory(shell, prompt, uri.getPath(), 0);
                break;
            }
            default: {
                Activator.log(4, String.valueOf(Messages.RDTResourceSelectorProxy_unsupported_resourceType) + (Object)((Object)resourceType));
                return null;
            }
        }
        URI selectedURI = null;
        if (selectedPath != null) {
            connection = uiFileManager.getConnection();
            IRemoteFileManager remoteFileManager = services.getFileManager(connection);
            selectedURI = remoteFileManager.toURI(selectedPath);
        }
        return selectedURI;
    }

    public URI selectFile(String scheme, String initialPath, String prompt, Shell shell) {
        return this.selectResource(scheme, initialPath, prompt, shell, ResourceType.FILE);
    }

    public URI selectDirectory(String scheme, String initialPath, String prompt, Shell shell) {
        return this.selectResource(scheme, initialPath, prompt, shell, ResourceType.DIRECTORY);
    }

    private static enum ResourceType {
        FILE,
        DIRECTORY;

    }
}

