/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.consolelog;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.TreeMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.linuxtools.systemtap.ui.consolelog.dialogs.ErrorMessage;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.ConsoleLogPlugin;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.DMRequest;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.DMResponse;

public final class ClientSession
extends Thread {
    private static ClientSession instance = null;
    private static int portnumber;
    private static int clientID;
    private static boolean connected;
    private static String hostname;
    private static int scriptnumber;
    private static InputStream in;
    private static TreeMap<Integer, LinkedBlockingQueue<byte[]>> mbox;

    private ClientSession() {
        hostname = ConsoleLogPlugin.getDefault().getPreferenceStore().getString("host");
        portnumber = ConsoleLogPlugin.getDefault().getPreferenceStore().getInt("port");
        mbox = new TreeMap();
        connected = this.createConnection();
        scriptnumber = 15;
        if (connected) {
            this.start();
        }
    }

    public synchronized boolean sendRequest(DMRequest req) {
        try {
            Socket tmp = new Socket(hostname, portnumber);
            OutputStream out = tmp.getOutputStream();
            out.write(req.getData());
            out.flush();
            out.flush();
            out.close();
            return true;
        }
        catch (UnknownHostException uhe) {
            new ErrorMessage("Unknown host!", "Check if server is running").open();
            System.err.println("Unknown host: " + uhe.getMessage());
            connected = false;
            return false;
        }
        catch (IOException ioe) {
            new ErrorMessage("Unable to send request!", "Check if server is running").open();
            System.err.println("Req I/O error " + ioe.getMessage());
            connected = false;
            return false;
        }
    }

    public DMResponse recvResponse(int scriptnum) {
        if (!mbox.containsKey(scriptnum)) {
            return null;
        }
        try {
            DMResponse dm = new DMResponse(mbox.get(scriptnum).take());
            return dm;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public byte[] recvData(int scriptnum, int size) {
        if (!mbox.containsKey(scriptnum)) {
            return null;
        }
        try {
            return mbox.get(scriptnum).take();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Interruptedrecvdata");
            return null;
        }
    }

    public boolean addSubscription(int scriptnum) {
        if (mbox.containsKey(scriptnum)) {
            return false;
        }
        mbox.put(scriptnum, new LinkedBlockingQueue());
        return true;
    }

    public boolean delSubscription(int scriptnum) {
        if (!mbox.containsKey(scriptnum)) {
            return false;
        }
        mbox.get(scriptnum).clear();
        mbox.remove(scriptnum);
        return true;
    }

    public static synchronized ClientSession getInstance() {
        if (instance == null) {
            instance = new ClientSession();
        } else if (!ClientSession.isConnected()) {
            connected = instance.createConnection();
            scriptnumber = 15;
            if (connected) {
                instance.start();
            }
        }
        return instance;
    }

    public static int getNewScriptId() {
        return scriptnumber++;
    }

    public static boolean isConnected() {
        return connected;
    }

    public int getcid() {
        return clientID;
    }

    public void run() {
        while (!Thread.interrupted()) {
            byte[] headBuffer = new byte[24];
            try {
                in.read(headBuffer, 0, headBuffer.length);
                DMResponse header = new DMResponse(headBuffer);
                if (!header.isValid()) continue;
                byte[] bodyBuffer = new byte[header.getsize()];
                in.read(bodyBuffer, 0, bodyBuffer.length);
                if (header.getsource() == 3) {
                    if (!mbox.containsKey(header.getscriptID())) {
                        mbox.put(header.getscriptID(), new LinkedBlockingQueue());
                    }
                    mbox.get(header.getscriptID()).put(header.tobytes());
                    mbox.get(header.getscriptID()).put(bodyBuffer);
                    continue;
                }
                if (!mbox.containsKey(header.getscriptID())) {
                    mbox.put(header.getscriptID(), new LinkedBlockingQueue());
                }
                mbox.get(header.getscriptID()).put(header.tobytes());
                mbox.get(header.getscriptID()).put(bodyBuffer);
            }
            catch (InterruptedException ie) {
                System.err.println("Interrupted: " + ie.getMessage());
                break;
            }
            catch (IOException ioe) {
                new ErrorMessage("I/O Error Check host!", "See stderr for more details").open();
                System.err.println("i/o error: " + ioe.getMessage());
                return;
            }
            catch (Exception e) {
                new ErrorMessage("Check if DMD is running", "See stderr for more details").open();
                System.err.println("Server terminated unexpectedly?," + e.getMessage());
                return;
            }
        }
        this.destroyConnection();
    }

    public boolean createConnection() {
        DMResponse respacket;
        DMRequest ccpacket = new DMRequest(1, 0, 0, 0);
        byte[] buffer = new byte[24];
        hostname = ConsoleLogPlugin.getDefault().getPreferenceStore().getString("host");
        portnumber = ConsoleLogPlugin.getDefault().getPreferenceStore().getInt("port");
        OutputStream out = null;
        try {
            Socket tmp = new Socket(hostname, portnumber);
            out = tmp.getOutputStream();
            in = tmp.getInputStream();
            out.write(ccpacket.getData());
            out.flush();
            in.read(buffer, 0, buffer.length);
            respacket = new DMResponse(buffer);
        }
        catch (UnknownHostException uhe) {
            new ErrorMessage("Unknown host!", "See stderr for more details").open();
            System.err.println("Unknown host: " + uhe.getMessage());
            return false;
        }
        catch (IOException ioe) {
            new ErrorMessage("Connection I/O error!", "See stderr for more details").open();
            System.err.println("Con I/O error: " + ioe.getMessage());
            return false;
        }
        if (!respacket.isValid()) {
            return false;
        }
        clientID = respacket.getclientID();
        return true;
    }

    public boolean destroyConnection() {
        DMRequest dcpacket = new DMRequest(6, 0, clientID, 0);
        try {
            this.sendRequest(dcpacket);
            in.close();
            connected = false;
            return true;
        }
        catch (IOException e) {
            new ErrorMessage("Connection close error!", "See stderr for more details").open();
            System.err.println("Close error: " + e.getMessage());
            return false;
        }
    }
}

