/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.consolelog;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.eclipse.linuxtools.systemtap.ui.consolelog.dialogs.ErrorMessage;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.ConsoleLogPlugin;

public class ScpClient {
    private Session session;

    public ScpClient() throws Exception {
        String user = ConsoleLogPlugin.getDefault().getPreferenceStore().getString("scpuser");
        String host = ConsoleLogPlugin.getDefault().getPreferenceStore().getString("host");
        try {
            JSch jsch = new JSch();
            this.session = jsch.getSession(user, host, 22);
            this.session.setPassword(ConsoleLogPlugin.getDefault().getPreferenceStore().getString("scppassword"));
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            this.session.setConfig(config);
            this.session.connect();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            new ErrorMessage("Error in connection", "File Transfer failed.\n See stderr for more details").open();
            throw e;
        }
    }

    public void transfer(String fromFile, String toFile) throws Exception {
        FileInputStream fis = null;
        String rfile = toFile;
        String lfile = fromFile;
        String command = "scp -t " + rfile;
        try {
            int len;
            Channel channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            if (ScpClient.checkAck(in) != 0) {
                System.out.println("err");
            }
            long filesize = new File(lfile).length();
            command = "C0644 " + filesize + " ";
            command = lfile.lastIndexOf(47) > 0 ? String.valueOf(command) + lfile.substring(lfile.lastIndexOf(47) + 1) : String.valueOf(command) + lfile;
            command = String.valueOf(command) + "\n";
            out.write(command.getBytes());
            out.flush();
            if (ScpClient.checkAck(in) != 0) {
                System.out.println("err");
            }
            fis = new FileInputStream(lfile);
            byte[] buf = new byte[1024];
            while ((len = fis.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, len);
            }
            fis.close();
            fis = null;
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            if (ScpClient.checkAck(in) != 0) {
                System.out.println("err");
            }
            out.close();
            channel.disconnect();
            this.session.disconnect();
        }
        catch (Exception e) {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
            throw e;
        }
    }

    static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
        }
        return b;
    }

    public static class MyUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        String passwd;
        JTextField passwordField = new JPasswordField(20);
        final GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        private Container panel;

        public String getPassword() {
            return this.passwd;
        }

        public boolean promptYesNo(String str) {
            Object[] options = new Object[]{"yes", "no"};
            int foo = JOptionPane.showOptionDialog(null, str, "Warning", -1, 2, null, options, options[0]);
            return foo == 0;
        }

        public String getPassphrase() {
            return null;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptPassword(String message) {
            Object[] ob = new Object[]{this.passwordField};
            int result = JOptionPane.showConfirmDialog(null, ob, message, 2);
            if (result == 0) {
                this.passwd = this.passwordField.getText();
                return true;
            }
            return false;
        }

        public void showMessage(String message) {
            JOptionPane.showMessageDialog(null, message);
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            this.panel = new JPanel();
            this.panel.setLayout(new GridBagLayout());
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbc.gridx = 0;
            this.panel.add((Component)new JLabel(instruction), this.gbc);
            ++this.gbc.gridy;
            this.gbc.gridwidth = -1;
            JTextField[] texts = new JTextField[prompt.length];
            int i = 0;
            while (i < prompt.length) {
                this.gbc.fill = 0;
                this.gbc.gridx = 0;
                this.gbc.weightx = 1.0;
                this.panel.add((Component)new JLabel(prompt[i]), this.gbc);
                this.gbc.gridx = 1;
                this.gbc.fill = 2;
                this.gbc.weighty = 1.0;
                texts[i] = echo[i] ? new JTextField(20) : new JPasswordField(20);
                this.panel.add((Component)texts[i], this.gbc);
                ++this.gbc.gridy;
                ++i;
            }
            if (JOptionPane.showConfirmDialog(null, this.panel, String.valueOf(destination) + ": " + name, 2, 3) == 0) {
                String[] response = new String[prompt.length];
                int i2 = 0;
                while (i2 < prompt.length) {
                    response[i2] = texts[i2].getText();
                    ++i2;
                }
                return response;
            }
            return null;
        }
    }
}

