/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.request;

import org.eclipse.linuxtools.internal.tmf.core.Tracer;
import org.eclipse.linuxtools.internal.tmf.core.request.TmfCoalescedDataRequest;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;

public class TmfCoalescedEventRequest<T extends ITmfEvent>
extends TmfCoalescedDataRequest<T>
implements ITmfEventRequest<T> {
    private TmfTimeRange fRange;

    public TmfCoalescedEventRequest(Class<T> dataType) {
        this(dataType, TmfTimeRange.ETERNITY, Integer.MAX_VALUE, 1000, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfCoalescedEventRequest(Class<T> dataType, ITmfDataRequest.ExecutionType priority) {
        this(dataType, TmfTimeRange.ETERNITY, Integer.MAX_VALUE, 1000, priority);
    }

    public TmfCoalescedEventRequest(Class<T> dataType, TmfTimeRange range) {
        this(dataType, range, Integer.MAX_VALUE, 1000, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfCoalescedEventRequest(Class<T> dataType, TmfTimeRange range, ITmfDataRequest.ExecutionType priority) {
        this(dataType, range, Integer.MAX_VALUE, 1000, priority);
    }

    public TmfCoalescedEventRequest(Class<T> dataType, TmfTimeRange range, int nbRequested) {
        this(dataType, range, nbRequested, 1000, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfCoalescedEventRequest(Class<T> dataType, TmfTimeRange range, int nbRequested, ITmfDataRequest.ExecutionType priority) {
        this(dataType, range, nbRequested, 1000, priority);
    }

    public TmfCoalescedEventRequest(Class<T> dataType, TmfTimeRange range, int nbRequested, int blockSize) {
        this(dataType, range, 0L, nbRequested, blockSize, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfCoalescedEventRequest(Class<T> dataType, TmfTimeRange range, int nbRequested, int blockSize, ITmfDataRequest.ExecutionType priority) {
        this(dataType, range, 0L, nbRequested, blockSize, priority);
    }

    public TmfCoalescedEventRequest(Class<T> dataType, TmfTimeRange range, long index, int nbRequested, int blockSize, ITmfDataRequest.ExecutionType priority) {
        super(dataType, index, nbRequested, blockSize, priority);
        this.fRange = range;
        if (Tracer.isRequestTraced()) {
            String type = this.getClass().getName();
            type = type.substring(type.lastIndexOf(46) + 1);
            String message = "CREATED " + (this.getExecType() == ITmfDataRequest.ExecutionType.BACKGROUND ? "(BG)" : "(FG)") + " Type=" + type + " Index=" + this.getIndex() + " NbReq=" + this.getNbRequested() + " Range=" + this.getRange() + " DataType=" + this.getDataType().getSimpleName();
            Tracer.traceRequest(this, message);
        }
    }

    @Override
    public void addRequest(ITmfDataRequest<T> request) {
        super.addRequest(request);
        if (request instanceof ITmfEventRequest) {
            this.merge((ITmfEventRequest)request);
        }
    }

    @Override
    public boolean isCompatible(ITmfDataRequest<T> request) {
        if (request instanceof ITmfEventRequest && super.isCompatible(request)) {
            return this.overlaps((ITmfEventRequest)request);
        }
        return false;
    }

    private boolean overlaps(ITmfEventRequest<T> request) {
        ITmfTimestamp endTime;
        ITmfTimestamp startTime = request.getRange().getStartTime();
        return startTime.compareTo(endTime = request.getRange().getEndTime()) <= 0 && this.fRange.getStartTime().compareTo(this.fRange.getEndTime()) <= 0;
    }

    private void merge(ITmfEventRequest<T> request) {
        ITmfTimestamp startTime = request.getRange().getStartTime();
        ITmfTimestamp endTime = request.getRange().getEndTime();
        if (!this.fRange.contains(startTime) && this.fRange.getStartTime().compareTo(startTime) > 0) {
            this.fRange = new TmfTimeRange(startTime, this.fRange.getEndTime());
        }
        if (!this.fRange.contains(endTime) && this.fRange.getEndTime().compareTo(endTime) < 0) {
            this.fRange = new TmfTimeRange(this.fRange.getStartTime(), endTime);
        }
    }

    @Override
    public void handleData(T data) {
        super.handleData(data);
        long index = this.getIndex() + (long)this.getNbRead() - 1L;
        for (ITmfDataRequest request : this.fRequests) {
            TmfDataRequest req;
            if (data == null) {
                request.handleData(null);
                continue;
            }
            long start = request.getIndex();
            long end = start + (long)request.getNbRequested();
            if (request instanceof TmfEventRequest) {
                req = (TmfEventRequest)request;
                if (req.isCompleted() || index < start || index >= end) continue;
                ITmfTimestamp ts = data.getTimestamp();
                if (!((TmfEventRequest)req).getRange().contains(ts) || !req.getDataType().isInstance(data)) continue;
                req.handleData(data);
                continue;
            }
            req = (TmfDataRequest)request;
            if (req.isCompleted() || index < start || index >= end || !req.getDataType().isInstance(data)) continue;
            req.handleData(data);
        }
    }

    @Override
    public TmfTimeRange getRange() {
        return this.fRange;
    }

    @Override
    public void setStartIndex(int index) {
        this.setIndex(index);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof TmfCoalescedEventRequest) {
            TmfCoalescedEventRequest request = (TmfCoalescedEventRequest)other;
            return request.getDataType() == this.getDataType() && request.getIndex() == this.getIndex() && request.getNbRequested() == this.getNbRequested() && request.getRange().equals(this.getRange());
        }
        if (other instanceof TmfCoalescedDataRequest) {
            return super.equals(other);
        }
        return false;
    }

    @Override
    public String toString() {
        return "[TmfCoalescedEventRequest(" + this.getRequestId() + "," + this.getDataType().getSimpleName() + "," + this.getRange() + "," + this.getIndex() + "," + this.getNbRequested() + "," + this.getBlockSize() + ")]";
    }
}

