/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.parsers.custom;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomEventContent;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTraceDefinition;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTxtEvent;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTxtEventType;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTxtTraceContext;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.event.TmfEventType;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.io.BufferedRandomAccessFile;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfEventParser;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfContext;
import org.eclipse.linuxtools.tmf.core.trace.TmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;

public class CustomTxtTrace
extends TmfTrace<CustomTxtEvent>
implements ITmfEventParser<CustomTxtEvent> {
    private static final TmfLocation<Long> NULL_LOCATION = new TmfLocation(null);
    private static final int DEFAULT_CACHE_SIZE = 100;
    private final CustomTxtTraceDefinition fDefinition;
    private final CustomTxtEventType fEventType;
    private BufferedRandomAccessFile fFile;

    public CustomTxtTrace(CustomTxtTraceDefinition definition) {
        this.fDefinition = definition;
        this.fEventType = new CustomTxtEventType(this.fDefinition);
        this.setCacheSize(100);
    }

    public CustomTxtTrace(IResource resource, CustomTxtTraceDefinition definition, String path, int cacheSize) throws TmfTraceException {
        this(definition);
        this.setCacheSize(cacheSize > 0 ? cacheSize : 100);
        this.initTrace(resource, path, CustomTxtEvent.class);
    }

    public void initTrace(IResource resource, String path, Class<CustomTxtEvent> eventType) throws TmfTraceException {
        super.initTrace(resource, path, eventType);
        try {
            this.fFile = new BufferedRandomAccessFile(this.getPath(), "r");
        }
        catch (IOException e) {
            throw new TmfTraceException(e.getMessage(), (Throwable)e);
        }
        this.indexTrace(false);
    }

    public synchronized void dispose() {
        super.dispose();
        if (this.fFile != null) {
            try {
                try {
                    this.fFile.close();
                }
                catch (IOException iOException) {
                    this.fFile = null;
                }
            }
            finally {
                this.fFile = null;
            }
        }
    }

    public synchronized TmfContext seekEvent(ITmfLocation<?> location) {
        CustomTxtTraceContext context = new CustomTxtTraceContext((ITmfLocation<?>)NULL_LOCATION, -1L);
        if (NULL_LOCATION.equals(location) || this.fFile == null) {
            return context;
        }
        try {
            String line;
            if (location == null) {
                this.fFile.seek(0L);
            } else if (location.getLocation() instanceof Long) {
                this.fFile.seek(((Long)location.getLocation()).longValue());
            }
            long rawPos = this.fFile.getFilePointer();
            while ((line = this.fFile.getNextLine()) != null) {
                for (CustomTxtTraceDefinition.InputLine input : this.getFirstLines()) {
                    Matcher matcher = input.getPattern().matcher(line);
                    if (!matcher.find()) continue;
                    context.setLocation((ITmfLocation)new TmfLocation((Comparable)Long.valueOf(rawPos)));
                    context.firstLineMatcher = matcher;
                    context.firstLine = line;
                    context.nextLineLocation = this.fFile.getFilePointer();
                    context.inputLine = input;
                    return context;
                }
                rawPos = this.fFile.getFilePointer();
            }
            return context;
        }
        catch (FileNotFoundException e) {
            Activator.getDefault().logError("Error seeking event. File not found: " + this.getPath(), e);
            return context;
        }
        catch (IOException e) {
            Activator.getDefault().logError("Error seeking event. File: " + this.getPath(), e);
            return context;
        }
    }

    public synchronized TmfContext seekEvent(double ratio) {
        if (this.fFile == null) {
            return new CustomTxtTraceContext((ITmfLocation<?>)NULL_LOCATION, -1L);
        }
        try {
            long pos = (long)(ratio * (double)this.fFile.length());
            while (pos > 0L) {
                this.fFile.seek(pos - 1L);
                if (this.fFile.read() == 10) break;
                --pos;
            }
            TmfLocation location = new TmfLocation((Comparable)Long.valueOf(pos));
            TmfContext context = this.seekEvent((ITmfLocation<?>)location);
            context.setRank(-1L);
            return context;
        }
        catch (IOException e) {
            Activator.getDefault().logError("Error seeking event. File: " + this.getPath(), e);
            return new CustomTxtTraceContext((ITmfLocation<?>)NULL_LOCATION, -1L);
        }
    }

    public synchronized double getLocationRatio(ITmfLocation<?> location) {
        if (this.fFile == null) {
            return 0.0;
        }
        try {
            if (location.getLocation() instanceof Long) {
                return (double)((Long)location.getLocation()).longValue() / (double)this.fFile.length();
            }
        }
        catch (IOException e) {
            Activator.getDefault().logError("Error seeking event. File: " + this.getPath(), e);
        }
        return 0.0;
    }

    public ITmfLocation<?> getCurrentLocation() {
        return null;
    }

    public synchronized CustomTxtEvent parseEvent(ITmfContext tmfContext) {
        TmfContext context = this.seekEvent((ITmfLocation<?>)tmfContext.getLocation());
        return this.parse((ITmfContext)context);
    }

    public synchronized CustomTxtEvent getNext(ITmfContext context) {
        ITmfContext savedContext = context.clone();
        CustomTxtEvent event = this.parse(context);
        if (event != null) {
            this.updateAttributes(savedContext, event.getTimestamp());
            context.increaseRank();
        }
        return event;
    }

    private synchronized CustomTxtEvent parse(ITmfContext tmfContext) {
        if (this.fFile == null) {
            return null;
        }
        if (!(tmfContext instanceof CustomTxtTraceContext)) {
            return null;
        }
        CustomTxtTraceContext context = (CustomTxtTraceContext)tmfContext;
        if (!(context.getLocation().getLocation() instanceof Long) || NULL_LOCATION.equals((Object)context.getLocation())) {
            return null;
        }
        CustomTxtEvent event = this.parseFirstLine(context);
        HashMap<CustomTxtTraceDefinition.InputLine, Integer> countMap = new HashMap<CustomTxtTraceDefinition.InputLine, Integer>();
        CustomTxtTraceDefinition.InputLine currentInput = null;
        if (context.inputLine.childrenInputs != null && context.inputLine.childrenInputs.size() > 0) {
            currentInput = context.inputLine.childrenInputs.get(0);
            countMap.put(currentInput, 0);
        }
        try {
            String line;
            if (this.fFile.getFilePointer() != context.nextLineLocation) {
                this.fFile.seek(context.nextLineLocation);
            }
            long rawPos = this.fFile.getFilePointer();
            while ((line = this.fFile.getNextLine()) != null) {
                boolean processed = false;
                if (currentInput == null) {
                    for (CustomTxtTraceDefinition.InputLine input : this.getFirstLines()) {
                        Matcher matcher = input.getPattern().matcher(line);
                        if (!matcher.find()) continue;
                        context.setLocation((ITmfLocation)new TmfLocation((Comparable)Long.valueOf(rawPos)));
                        context.firstLineMatcher = matcher;
                        context.firstLine = line;
                        context.nextLineLocation = this.fFile.getFilePointer();
                        context.inputLine = input;
                        return event;
                    }
                } else {
                    if ((Integer)countMap.get(currentInput) >= currentInput.getMinCount()) {
                        Matcher matcher;
                        List<CustomTxtTraceDefinition.InputLine> nextInputs = currentInput.getNextInputs(countMap);
                        if (nextInputs.size() == 0 || nextInputs.get(nextInputs.size() - 1).getMinCount() == 0) {
                            for (CustomTxtTraceDefinition.InputLine input : this.getFirstLines()) {
                                matcher = input.getPattern().matcher(line);
                                if (!matcher.find()) continue;
                                context.setLocation((ITmfLocation)new TmfLocation((Comparable)Long.valueOf(rawPos)));
                                context.firstLineMatcher = matcher;
                                context.firstLine = line;
                                context.nextLineLocation = this.fFile.getFilePointer();
                                context.inputLine = input;
                                return event;
                            }
                        }
                        for (CustomTxtTraceDefinition.InputLine input : nextInputs) {
                            CustomTxtTraceDefinition.InputLine inputLine;
                            matcher = input.getPattern().matcher(line);
                            if (!matcher.find()) continue;
                            event.processGroups(input, matcher);
                            currentInput = input;
                            if (countMap.get(currentInput) == null) {
                                countMap.put(currentInput, 1);
                            } else {
                                countMap.put(currentInput, countMap.get(currentInput) + 1);
                            }
                            Iterator<CustomTxtTraceDefinition.InputLine> iter = countMap.keySet().iterator();
                            while (iter.hasNext()) {
                                inputLine = iter.next();
                                if (inputLine.level <= currentInput.level) continue;
                                iter.remove();
                            }
                            if (currentInput.childrenInputs != null && currentInput.childrenInputs.size() > 0) {
                                currentInput = currentInput.childrenInputs.get(0);
                                countMap.put(currentInput, 0);
                            } else if (countMap.get(currentInput) >= currentInput.getMaxCount()) {
                                if (currentInput.getNextInputs(countMap).size() > 0) {
                                    if (countMap.get(currentInput = currentInput.getNextInputs(countMap).get(0)) == null) {
                                        countMap.put(currentInput, 0);
                                    }
                                    iter = countMap.keySet().iterator();
                                    while (iter.hasNext()) {
                                        inputLine = iter.next();
                                        if (inputLine.level <= currentInput.level) continue;
                                        iter.remove();
                                    }
                                } else {
                                    currentInput = null;
                                }
                            }
                            processed = true;
                            break;
                        }
                    }
                    if (!processed) {
                        Matcher matcher = currentInput.getPattern().matcher(line);
                        if (matcher.find()) {
                            event.processGroups(currentInput, matcher);
                            countMap.put(currentInput, countMap.get(currentInput) + 1);
                            if (currentInput.childrenInputs != null && currentInput.childrenInputs.size() > 0) {
                                currentInput = currentInput.childrenInputs.get(0);
                                countMap.put(currentInput, 0);
                            } else if (countMap.get(currentInput) >= currentInput.getMaxCount()) {
                                if (currentInput.getNextInputs(countMap).size() > 0) {
                                    if (countMap.get(currentInput = currentInput.getNextInputs(countMap).get(0)) == null) {
                                        countMap.put(currentInput, 0);
                                    }
                                    Iterator<CustomTxtTraceDefinition.InputLine> iter = countMap.keySet().iterator();
                                    while (iter.hasNext()) {
                                        CustomTxtTraceDefinition.InputLine inputLine = iter.next();
                                        if (inputLine.level <= currentInput.level) continue;
                                        iter.remove();
                                    }
                                } else {
                                    currentInput = null;
                                }
                            }
                        }
                        ((StringBuffer)event.getContent().getValue()).append("\n").append(line);
                    }
                }
                rawPos = this.fFile.getFilePointer();
            }
        }
        catch (IOException e) {
            Activator.getDefault().logError("Error seeking event. File: " + this.getPath(), e);
        }
        for (Map.Entry entry : countMap.entrySet()) {
            if ((Integer)entry.getValue() >= ((CustomTxtTraceDefinition.InputLine)entry.getKey()).getMinCount()) continue;
            event = null;
        }
        context.setLocation((ITmfLocation)NULL_LOCATION);
        return event;
    }

    public List<CustomTxtTraceDefinition.InputLine> getFirstLines() {
        return this.fDefinition.inputs;
    }

    public CustomTxtEvent parseFirstLine(CustomTxtTraceContext context) {
        CustomTxtEvent event = new CustomTxtEvent(this.fDefinition, (ITmfTrace<?>)this, TmfTimestamp.ZERO, "", (TmfEventType)this.fEventType, "");
        event.processGroups(context.inputLine, context.firstLineMatcher);
        event.setContent((ITmfEventField)new CustomEventContent(event, new StringBuffer(context.firstLine)));
        return event;
    }

    public CustomTraceDefinition getDefinition() {
        return this.fDefinition;
    }

    public boolean validate(IProject project, String path) {
        return this.fileExists(path);
    }
}

