/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.statistics.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.linuxtools.tmf.ui.views.statistics.model.AbsTmfStatisticsTree;
import org.eclipse.linuxtools.tmf.ui.views.statistics.model.TmfStatisticsTreeNode;

public class TmfStatisticsTreeRootFactory {
    private static final Map<String, AbsTmfStatisticsTree> fTreeInstances = new HashMap<String, AbsTmfStatisticsTree>();

    public static TmfStatisticsTreeNode getStatTreeRoot(String traceUniqueId) {
        AbsTmfStatisticsTree tree = TmfStatisticsTreeRootFactory.getStatTree(traceUniqueId);
        if (tree == null) {
            return null;
        }
        return tree.getOrCreate(AbsTmfStatisticsTree.ROOT);
    }

    public static AbsTmfStatisticsTree getStatTree(String traceUniqueId) {
        if (traceUniqueId == null) {
            return null;
        }
        AbsTmfStatisticsTree tree = fTreeInstances.get(traceUniqueId);
        return tree;
    }

    public static void addStatsTreeRoot(String traceUniqueId, AbsTmfStatisticsTree statsData) {
        if (traceUniqueId == null || statsData == null) {
            return;
        }
        fTreeInstances.put(traceUniqueId, statsData);
        statsData.getOrCreate(AbsTmfStatisticsTree.ROOT);
    }

    public static boolean containsTreeRoot(String traceUniqueId) {
        return fTreeInstances.containsKey(traceUniqueId);
    }

    public static void removeStatTreeRoot(String traceUniqueId) {
        if (traceUniqueId != null && fTreeInstances.containsKey(traceUniqueId)) {
            fTreeInstances.remove(traceUniqueId);
        }
    }

    public static void removeAll() {
        fTreeInstances.clear();
    }
}

