/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.launch.remote;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.linuxtools.internal.valgrind.launch.ValgrindLaunchConfigurationDelegate;
import org.eclipse.linuxtools.internal.valgrind.launch.remote.Messages;
import org.eclipse.linuxtools.internal.valgrind.launch.remote.ValgrindRemoteLaunchConstants;
import org.eclipse.linuxtools.internal.valgrind.ui.ValgrindUIPlugin;
import org.eclipse.linuxtools.internal.valgrind.ui.ValgrindViewPart;
import org.eclipse.linuxtools.profiling.launch.remote.RemoteConnection;
import org.eclipse.linuxtools.profiling.launch.remote.RemoteConnectionException;
import org.eclipse.linuxtools.valgrind.core.IValgrindMessage;
import org.eclipse.linuxtools.valgrind.launch.IValgrindOutputDirectoryProvider;

public class ValgrindRemoteLaunchDelegate
extends ValgrindLaunchConfigurationDelegate {
    private SubMonitor monitor;
    private IPath localOutputDir;
    private IPath remoteBinFile;
    private RemoteConnection rc;

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor m) throws CoreException {
        if (m == null) {
            m = new NullProgressMonitor();
        }
        this.process = null;
        this.monitor = SubMonitor.convert((IProgressMonitor)m, (String)Messages.ValgrindRemoteLaunchDelegate_task_name, (int)10);
        if (this.monitor.isCanceled()) {
            return;
        }
        this.config = config;
        this.launch = launch;
        try {
            try {
                ValgrindUIPlugin.getDefault().resetView();
                this.getPlugin().setCurrentLaunchConfiguration(null);
                this.getPlugin().setCurrentLaunch(null);
                this.rc = new RemoteConnection(config);
                this.monitor.worked(1);
                IPath exePath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
                IPath remoteDir = Path.fromOSString((String)config.getAttribute("org.eclipse.linuxtools.valgrind.launch.remote.REMOTE_DESTDIR", ValgrindRemoteLaunchConstants.DEFAULT_REMOTE_DESTDIR));
                this.remoteBinFile = remoteDir.append(exePath.lastSegment());
                this.rc.upload(exePath, remoteDir, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)this.monitor, 1));
                IPath remoteLogDir = Path.fromOSString((String)config.getAttribute("org.eclipse.linuxtools.valgrind.launch.remote.REMOTE_OUTPUTDIR", "/tmp"));
                this.outputPath = remoteLogDir.append("eclipse-valgrind-" + System.currentTimeMillis());
                this.rc.createFolder(this.outputPath, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)this.monitor, 1));
                IPath valgrindLocation = Path.fromOSString((String)config.getAttribute("org.eclipse.linuxtools.valgrind.launch.remote.REMOTE_VALGRINDLOC", "/usr/bin/valgrind"));
                String[] arguments = this.getProgramArgumentsArray(config);
                IValgrindOutputDirectoryProvider provider = this.getPlugin().getOutputDirectoryProvider();
                try {
                    this.localOutputDir = provider.getOutputPath();
                    this.createDirectory(this.localOutputDir);
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                this.toolID = this.getTool(config);
                this.dynamicDelegate = this.getDynamicDelegate(this.toolID);
                String[] opts = this.getValgrindArgumentsArray(config);
                config.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
                config.getAttribute("org.eclipse.cdt.launch.use_terminal", true);
                String command = valgrindLocation.toString();
                String[] stringArray = opts;
                int n = opts.length;
                int n2 = 0;
                while (n2 < n) {
                    String opt = stringArray[n2];
                    command = String.valueOf(command) + " " + opt;
                    ++n2;
                }
                command = String.valueOf(command) + " " + this.remoteBinFile.toString();
                stringArray = arguments;
                n = arguments.length;
                n2 = 0;
                while (n2 < n) {
                    String argument = stringArray[n2];
                    command = String.valueOf(command) + " " + argument;
                    ++n2;
                }
                ArrayList commandOutput = new ArrayList();
                int returnValue = this.rc.runCommand(command, remoteDir, commandOutput, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)this.monitor, 1));
                this.rc.delete(this.remoteBinFile, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)this.monitor, 1));
                if (returnValue == 0) {
                    this.rc.download(this.outputPath, this.localOutputDir, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)this.monitor, 1));
                }
                this.rc.delete(this.outputPath, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)this.monitor, 1));
                if (returnValue != 0) {
                    StringBuffer buf = new StringBuffer();
                    int i = 0;
                    while (i < commandOutput.size()) {
                        buf.append((String)commandOutput.get(i));
                        buf.append("\n");
                        ++i;
                    }
                    this.abort(buf.toString(), null, 150);
                }
                this.getPlugin().setCurrentLaunchConfiguration(config);
                this.getPlugin().setCurrentLaunch(launch);
                IValgrindMessage[] messages = this.parseLogs(this.localOutputDir);
                this.launchStr = this.createLaunchStr();
                ValgrindUIPlugin.getDefault().createView(this.launchStr, this.toolID);
                ValgrindViewPart view = ValgrindUIPlugin.getDefault().getView();
                view.setMessages(messages);
                this.monitor.worked(1);
                this.dynamicDelegate.handleLaunch(config, launch, this.localOutputDir, (IProgressMonitor)this.monitor.newChild(2));
                this.dynamicDelegate.initializeView(view.getDynamicView(), this.launchStr, (IProgressMonitor)this.monitor.newChild(1));
                ValgrindUIPlugin.getDefault().refreshView();
                ValgrindUIPlugin.getDefault().showView();
                this.monitor.worked(1);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.monitor.done();
                m.done();
            }
            catch (RemoteConnectionException e) {
                this.abort(e.getLocalizedMessage(), null, 150);
                this.monitor.done();
                m.done();
            }
        }
        finally {
            this.monitor.done();
            m.done();
        }
    }

    protected String createLaunchStr() {
        return String.valueOf(this.config.getName()) + " [" + this.getPlugin().getToolName(this.toolID) + " on " + this.rc.getId() + "] ";
    }

    protected String getPluginID() {
        return "org.eclipse.linuxtools.valgrind.launch";
    }

    public void onError(Throwable t) {
    }
}

