/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.launch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexManager;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementVisitor;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.linuxtools.internal.callgraph.core.PluginConstants;
import org.eclipse.linuxtools.internal.callgraph.core.SystemTapUIErrorMessages;
import org.eclipse.linuxtools.internal.callgraph.launch.ListTreeContentProvider;
import org.eclipse.linuxtools.internal.callgraph.launch.Messages;
import org.eclipse.linuxtools.internal.callgraph.launch.RuledTreeSelectionDialog;
import org.eclipse.linuxtools.internal.callgraph.launch.SystemTapOptionsTab;
import org.eclipse.linuxtools.internal.callgraph.launch.TranslationUnitVisitor;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchShortcut;
import org.eclipse.swt.widgets.Button;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class SystemTapLaunchShortcut
extends ProfileLaunchShortcut {
    protected IEditorPart editor;
    protected ILaunchConfiguration config;
    private static final String USER_SELECTED_ALL = "ALL";
    protected String name;
    protected String binaryPath;
    protected String scriptPath;
    protected String arguments;
    protected String outputPath;
    protected String binName;
    protected String dirPath;
    protected String generatedScript;
    protected String parserID;
    protected String viewID;
    protected boolean needToGenerate;
    protected boolean overwrite;
    protected boolean useColours;
    protected String resourceToSearchFor;
    protected boolean searchForResource;
    protected IBinary bin;
    private Button OKButton;
    private boolean testMode = false;
    protected String secondaryID = "";
    private final String[] escapableChars = new String[]{"(", ")", " "};

    public void reLaunch(IEditorPart editor, String mode) {
        this.launch(editor, mode);
    }

    public void initialize() {
        this.name = "";
        this.dirPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        this.binaryPath = "";
        this.arguments = "";
        this.outputPath = PluginConstants.getDefaultIOPath();
        this.overwrite = true;
        this.generatedScript = "";
        this.needToGenerate = false;
        this.useColours = false;
        this.secondaryID = "";
    }

    protected ILaunchConfigurationType getLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.eclipse.linuxtools.callgraph.launch.systemtapLaunch");
    }

    protected void setDefaultProfileAttributes(ILaunchConfigurationWorkingCopy wc) {
        SystemTapOptionsTab tab = new SystemTapOptionsTab();
        tab.setDefaults(wc);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean existsConfiguration(ILaunchConfigurationWorkingCopy wc) {
        ILaunchConfigurationType configType = this.getLaunchConfigType();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            int i = 0;
            while (true) {
                if (i >= configs.length) {
                    return false;
                }
                if (configs[i] != null && configs[i].exists() && this.checkIfAttributesAreEqual((ILaunchConfiguration)wc, configs[i])) {
                    this.config = configs[i];
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean checkIfAttributesAreEqual(ILaunchConfiguration first, ILaunchConfiguration second) {
        try {
            if (first.getAttributes().equals(second.getAttributes())) {
                return true;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }

    protected void finishLaunch(String name, String mode, ILaunchConfigurationWorkingCopy wc) throws Exception {
        if (!this.finishLaunchHelper()) {
            return;
        }
        if (wc != null) {
            wc.setAttribute("org.eclipse.linuxtools.callgraph.launch.SCRIPT_PATH", this.scriptPath);
            if (!SystemTapLaunchShortcut.invalid(this.binaryPath)) {
                wc.setAttribute("org.eclipse.linuxtools.callgraph.launch.BINARY_PATH", this.binaryPath);
            }
            this.outputPath = this.escapeSpecialCharacters(this.outputPath);
            wc.setAttribute("org.eclipse.linuxtools.callgraph.launch.OUTPUT_PATH", this.outputPath);
            wc.setAttribute("org.eclipse.linuxtools.callgraph.launch.ARGUMENTS", this.arguments);
            wc.setAttribute("org.eclipse.linuxtools.callgraph.launch.GENERATED_SCRIPT", this.generatedScript);
            wc.setAttribute("org.eclipse.linuxtools.callgraph.launch.NEED_TO_GENERATE", this.needToGenerate);
            wc.setAttribute("org.eclipse.linuxtools.callgraph.launch.OVERWRITE", this.overwrite);
            wc.setAttribute("org.eclipse.linuxtools.callgraph.launch.USE_COLOUR", this.useColours);
            wc.setAttribute("org.eclipse.linuxtools.callgraph.launch.PARSER_CLASS", this.parserID);
            wc.setAttribute("org.eclipse.linuxtools.callgraph.launch.VIEW_CLASS", this.viewID);
            wc.setAttribute("org.eclipse.linuxtools.callgraph.launch.SECONDARY_VIEW_ID", this.setSecondaryViewID());
            if (!this.testMode) {
                DebugUITools.launch((ILaunchConfiguration)wc, (String)mode);
            }
        } else {
            throw new Exception(String.valueOf(Messages.getString("SystemTapLaunchShortcut.NullConfiguration")) + name);
        }
    }

    private static boolean invalid(String str) {
        return str == null || str.length() < 1;
    }

    private boolean finishLaunchHelper() throws Exception {
        if (SystemTapLaunchShortcut.invalid(this.scriptPath)) {
            this.scriptPath = this.setScriptPath();
        }
        if (SystemTapLaunchShortcut.invalid(this.scriptPath)) {
            SystemTapUIErrorMessages mess = new SystemTapUIErrorMessages(Messages.getString("SystemTapLaunchShortcut.ErrorMessageName"), Messages.getString("SystemTapLaunchShortcut.ErrorMessageTitle"), String.valueOf(Messages.getString("SystemTapLaunchShortcut.ErrorMessage")) + this.name);
            mess.schedule();
            return false;
        }
        if (SystemTapLaunchShortcut.invalid(this.parserID)) {
            this.parserID = this.setParserID();
        }
        if (SystemTapLaunchShortcut.invalid(this.parserID)) {
            SystemTapUIErrorMessages mess = new SystemTapUIErrorMessages(Messages.getString("SystemTapLaunchShortcut.InvalidParser1"), Messages.getString("SystemTapLaunchShortcut.InvalidParser2"), Messages.getString("SystemTapLaunchShortcut.InvalidParser3"));
            mess.schedule();
            return false;
        }
        if (SystemTapLaunchShortcut.invalid(this.viewID)) {
            this.viewID = this.setViewID();
        }
        if (SystemTapLaunchShortcut.invalid(this.viewID)) {
            SystemTapUIErrorMessages mess = new SystemTapUIErrorMessages(Messages.getString("SystemTapLaunchShortcut.InvalidView1"), Messages.getString("SystemTapLaunchShortcut.InvalidView2"), Messages.getString("SystemTapLaunchShortcut.InvalidView3"));
            mess.schedule();
            return false;
        }
        if (this.needToGenerate) {
            if (SystemTapLaunchShortcut.invalid(this.generatedScript)) {
                this.generatedScript = this.generateScript();
            }
            if (SystemTapLaunchShortcut.invalid(this.generatedScript)) {
                SystemTapUIErrorMessages mess = new SystemTapUIErrorMessages(Messages.getString("SystemTapLaunchShortcut.InvalidGeneration1"), Messages.getString("SystemTapLaunchShortcut.InvalidGeneration2"), Messages.getString("SystemTapLaunchShortcut.InvalidGeneration3"));
                mess.schedule();
                return false;
            }
        }
        return true;
    }

    public String getName(IBinary bin) {
        this.binName = bin != null ? bin.getPath().toString() : "";
        return this.binName;
    }

    protected ILaunchConfiguration createConfiguration(IBinary bin) {
        if (bin != null) {
            return super.createConfiguration(bin);
        }
        try {
            return this.getLaunchConfigType().newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(Messages.getString("SystemTapLaunchShortcut.Invalid")));
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected ILaunchConfigurationWorkingCopy createConfiguration(String name) {
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            ILaunchConfigurationType configType = this.getLaunchConfigType();
            wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(name));
            this.setDefaultProfileAttributes(wc);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return wc;
    }

    protected ILaunchConfigurationWorkingCopy createConfiguration(IBinary bin, String name) {
        ILaunchConfigurationWorkingCopy wc = null;
        if (bin != null) {
            try {
                String projectName = bin.getResource().getProjectRelativePath().toString();
                ILaunchConfigurationType configType = this.getLaunchConfigType();
                wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(String.valueOf(name) + " - " + bin.getElementName()));
                wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", projectName);
                wc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", bin.getCProject().getElementName());
                wc.setMappedResources(new IResource[]{bin.getResource(), bin.getResource().getProject()});
                wc.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
                this.setDefaultProfileAttributes(wc);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else {
            try {
                wc = this.getLaunchConfigType().newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(name));
                this.setDefaultProfileAttributes(wc);
            }
            catch (CoreException e) {
                e.printStackTrace();
                return null;
            }
        }
        return wc;
    }

    protected void failedToLaunch(String reason) {
        SystemTapUIErrorMessages mess = new SystemTapUIErrorMessages(Messages.getString("SystemTapLaunchShortcut.StapLaunchFailed"), Messages.getString("SystemTapLaunchShortcut.StapLaunchFailedTitle"), String.valueOf(Messages.getString("SystemTapLaunchShortcut.StapLaunchFailedMessage")) + reason);
        mess.schedule();
    }

    public void errorHandler() {
    }

    public ILaunchConfigurationType outsideGetLaunchConfigType() {
        return this.getLaunchConfigType();
    }

    public ILaunchConfiguration getConfig() {
        return this.config;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public String getDirPath() {
        return this.dirPath;
    }

    public String getArguments() {
        return this.arguments;
    }

    public String getBinaryPath() {
        return this.binaryPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getFunctionsFromBinary(IBinary bin, String targetResource) {
        Object[] unitList;
        block20: {
            ITranslationUnit e;
            int n;
            ITranslationUnit[] iTranslationUnitArray;
            String funcs = "";
            if (bin == null) {
                return funcs;
            }
            ArrayList<ICContainer> list = new ArrayList<ICContainer>();
            TranslationUnitVisitor v = new TranslationUnitVisitor();
            for (ICElement b : bin.getCProject().getChildrenOfType(12)) {
                Object c = (ICContainer)b;
                iTranslationUnitArray = c.getTranslationUnits();
                n = iTranslationUnitArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITranslationUnit tu = iTranslationUnitArray[n2];
                    if (this.searchForResource && tu.getElementName().contains(targetResource)) {
                        tu.accept((ICElementVisitor)v);
                        return String.valueOf(funcs) + v.getFunctions();
                    }
                    if (!list.contains(c)) {
                        list.add((ICContainer)c);
                    }
                    ++n2;
                }
                while (c.getChildrenOfType(12).size() > 0) {
                    e = null;
                    for (ICElement d : c.getChildrenOfType(12)) {
                        e = (ICContainer)d;
                        ITranslationUnit[] iTranslationUnitArray2 = e.getTranslationUnits();
                        int n3 = iTranslationUnitArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ITranslationUnit tu = iTranslationUnitArray2[n4];
                            if (this.searchForResource && tu.getElementName().contains(targetResource)) {
                                tu.accept((ICElementVisitor)v);
                                return String.valueOf(funcs) + v.getFunctions();
                            }
                            if (!list.contains(c)) {
                                list.add((ICContainer)c);
                            }
                            ++n4;
                        }
                    }
                    c = e;
                }
            }
            int numberOfFiles = this.numberOfValidFiles(list.toArray());
            if (numberOfFiles == 1) {
                for (ICContainer c : list) {
                    iTranslationUnitArray = c.getTranslationUnits();
                    n = iTranslationUnitArray.length;
                    int n5 = 0;
                    while (n5 < n) {
                        e = iTranslationUnitArray[n5];
                        if (SystemTapLaunchShortcut.validElement((ICElement)e)) {
                            e.accept((ICElementVisitor)v);
                            funcs = String.valueOf(funcs) + v.getFunctions();
                        }
                        ++n5;
                    }
                }
                return funcs;
            }
            unitList = this.chooseUnit(list, numberOfFiles);
            if (unitList == null) return null;
            if (unitList.length != 0) break block20;
            return null;
        }
        try {
            if (unitList.length == 1 && unitList[0].toString().equals(USER_SELECTED_ALL)) {
                return "*";
            }
            StringBuilder tmpFunc = new StringBuilder();
            for (String item : SystemTapLaunchShortcut.getAllFunctions(bin.getCProject(), unitList)) {
                tmpFunc.append(item);
                tmpFunc.append(" ");
            }
            return tmpFunc.toString();
        }
        catch (CModelException e) {
            e.printStackTrace();
            return null;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected Object[] chooseUnit(List<ICContainer> list, int numberOfValidFiles) {
        ICElement c;
        int n;
        int n2;
        ICElement[] iCElementArray;
        ICElement[] array;
        Object obj;
        int n3;
        int n4;
        Object[] objectArray;
        ArrayList<Object> output;
        ListTreeContentProvider prov = new ListTreeContentProvider();
        RuledTreeSelectionDialog dialog = new RuledTreeSelectionDialog(this.getActiveWorkbenchShell(), (ILabelProvider)new WorkbenchLabelProvider(), prov);
        dialog.setTitle(Messages.getString("SystemTapLaunchShortcut.SelectFiles"));
        dialog.setMessage(Messages.getString("SystemTapLaunchShortcut.SelectFilesMsg"));
        dialog.setInput(list);
        dialog.setHelpAvailable(false);
        dialog.setStatusLineAboveButtons(false);
        dialog.setEmptyListMessage(Messages.getString("SystemTapLaunchShortcut.NoFiles"));
        dialog.setContainerMode(true);
        Object[] topLevel = prov.findElements(list);
        dialog.setInitialSelections(topLevel);
        dialog.setSize(this.cap(topLevel.length * 10, 30, 55), this.cap((int)((double)topLevel.length * 1.5), 3, 13));
        dialog.create();
        this.OKButton = dialog.getOkButton();
        Object[] result = null;
        if (this.testMode) {
            this.OKButton.setSelection(true);
            result = list.toArray();
            output = new ArrayList<Object>();
            try {
                objectArray = result;
                n4 = result.length;
                n3 = 0;
                while (n3 < n4) {
                    obj = objectArray[n3];
                    if (obj instanceof ICContainer) {
                        iCElementArray = array = ((ICContainer)obj).getChildren();
                        n2 = array.length;
                        n = 0;
                        while (n < n2) {
                            c = iCElementArray[n];
                            if (SystemTapLaunchShortcut.validElement(c) && c.getElementName().contains("main") && !output.contains(c)) {
                                output.add(c);
                            }
                            ++n;
                        }
                    }
                    ++n3;
                }
                if (output.size() >= numberOfValidFiles) {
                    output.clear();
                    output.add(USER_SELECTED_ALL);
                }
            }
            catch (CModelException e) {
                e.printStackTrace();
            }
            result = output.toArray();
        } else {
            if (dialog.open() == 1) {
                return null;
            }
            result = dialog.getResult();
        }
        if (result == null) {
            return null;
        }
        output = new ArrayList();
        try {
            objectArray = result;
            n4 = result.length;
            n3 = 0;
            while (n3 < n4) {
                obj = objectArray[n3];
                if (obj instanceof ICContainer) {
                    iCElementArray = array = ((ICContainer)obj).getChildren();
                    n2 = array.length;
                    n = 0;
                    while (n < n2) {
                        c = iCElementArray[n];
                        if (SystemTapLaunchShortcut.validElement(c) && !output.contains(c)) {
                            output.add(c);
                        }
                        ++n;
                    }
                } else if (obj instanceof ICElement && SystemTapLaunchShortcut.validElement((ICElement)obj) && !output.contains(obj)) {
                    output.add(obj);
                }
                ++n3;
            }
            if (output.size() >= numberOfValidFiles) {
                output.clear();
                output.add(USER_SELECTED_ALL);
            }
        }
        catch (CModelException e) {
            e.printStackTrace();
        }
        return output.toArray();
    }

    private int numberOfValidFiles(Object[] list) throws CModelException {
        int output = 0;
        Object[] objectArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Object parent = objectArray[n2];
            if (parent instanceof ICContainer) {
                ICContainer cont = (ICContainer)parent;
                ICElement[] iCElementArray = cont.getChildren();
                int n3 = iCElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICElement ele = iCElementArray[n4];
                    if (ele instanceof ICContainer) {
                        output += this.numberOfValidFiles(((ICContainer)ele).getChildren());
                    }
                    if (ele instanceof ICElement && SystemTapLaunchShortcut.validElement(ele)) {
                        ++output;
                    }
                    ++n4;
                }
            } else if (parent instanceof ICElement && SystemTapLaunchShortcut.validElement((ICElement)parent)) {
                ++output;
            }
            ++n2;
        }
        return output;
    }

    public ILaunchConfiguration getNewConfiguration() throws CoreException {
        ILaunchConfigurationType configType = this.getLaunchConfigType();
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName("TestingConfiguration"));
        return wc.doSave();
    }

    public static ArrayList<String> getAllFunctions(ICProject project, Object[] listOfFiles) {
        try {
            GetFunctionsJob j = new GetFunctionsJob(project.getHandleIdentifier(), project, listOfFiles);
            j.schedule();
            j.join();
            ArrayList<String> functionList = j.getFunctionList();
            return functionList;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean specialContains(Object[] list, String path) {
        Object[] objectArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement el;
            Object val = objectArray[n2];
            if (val instanceof ICElement && (el = (ICElement)val).getPath().toString().contains(path)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private int cap(int number, int low, int high) {
        if (number > high) {
            return high;
        }
        if (number < low) {
            return low;
        }
        return number;
    }

    public String generateScript() throws IOException {
        return null;
    }

    public String setParserID() {
        return "org.eclipse.linuxtools.callgraph.core.systemtaptextparser";
    }

    public String getScript() {
        return this.generatedScript;
    }

    public Button getButton() {
        return this.OKButton;
    }

    public void setTestMode(boolean val) {
        this.testMode = val;
    }

    public String setViewID() {
        return "org.eclipse.linuxtools.callgraph.core.staptextview";
    }

    public static boolean validElement(ICElement e) {
        return e.getElementName().endsWith(".c") || e.getElementName().endsWith(".cpp") || e.getElementName().endsWith(".h");
    }

    /*
     * Loose catch block
     */
    public void launch(IBinary bin, String mode) {
        block9: {
            this.initialize();
            this.bin = bin;
            this.binName = this.getName(bin);
            this.name = "DefaultSystemTapLaunch";
            try {
                try {
                    ILaunchConfigurationWorkingCopy wc = this.createConfiguration(bin, this.name);
                    this.binaryPath = bin.getResource().getLocation().toString();
                    this.arguments = this.binaryPath = this.escapeSpecialCharacters(this.binaryPath);
                    this.outputPath = PluginConstants.getDefaultIOPath();
                    this.finishLaunch(this.name, mode, wc);
                }
                catch (IOException e) {
                    SystemTapUIErrorMessages mess = new SystemTapUIErrorMessages("LaunchShortcutScriptGen", Messages.getString("LaunchStapGraph.ScriptGenErr"), Messages.getString("LaunchStapGraph.ScriptGenErrMsg"));
                    mess.schedule();
                    e.printStackTrace();
                    this.resourceToSearchFor = "";
                    this.searchForResource = false;
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                    this.resourceToSearchFor = "";
                    this.searchForResource = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.resourceToSearchFor = "";
                    this.searchForResource = false;
                    break block9;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                this.resourceToSearchFor = "";
                this.searchForResource = false;
            }
        }
    }

    public abstract String setScriptPath();

    public String setSecondaryViewID() {
        return "";
    }

    protected String escapeSpecialCharacters(String str) {
        String res = str;
        int i = 0;
        while (i < this.escapableChars.length) {
            res = res.replace(this.escapableChars[i], "\\" + this.escapableChars[i]);
            ++i;
        }
        return res;
    }

    private static class GetFunctionsJob
    extends Job {
        private ArrayList<String> functionList = new ArrayList();
        private ICProject project;
        private Object[] listOfFiles;

        public GetFunctionsJob(String name, ICProject p, Object[] o) {
            super(name);
            this.listOfFiles = o;
            this.project = p;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IIndexManager manager = CCorePlugin.getIndexManager();
            IIndex index = null;
            IProgressMonitor m = monitor;
            if (m == null) {
                m = new NullProgressMonitor();
            }
            m.worked(1);
            try {
                IIndexFile[] blah;
                index = manager.getIndex(this.project);
                index.acquireReadLock();
                IIndexFile[] iIndexFileArray = blah = index.getAllFiles();
                int n = blah.length;
                int n2 = 0;
                while (n2 < n) {
                    IIndexFile file = iIndexFileArray[n2];
                    String fullFilePath = file.getLocation().getFullPath();
                    if (fullFilePath != null && SystemTapLaunchShortcut.specialContains(this.listOfFiles, fullFilePath)) {
                        IIndexName[] indexNamesArray;
                        IIndexName[] iIndexNameArray = indexNamesArray = file.findNames(0, Integer.MAX_VALUE);
                        int n3 = indexNamesArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IIndexBinding binder;
                            IIndexName name = iIndexNameArray[n4];
                            if (name.isDefinition() && SystemTapLaunchShortcut.specialContains(this.listOfFiles, name.getFile().getLocation().getFullPath()) && (binder = index.findBinding((IName)name)) instanceof IFunction && !this.functionList.contains(binder.getName())) {
                                this.functionList.add(binder.getName());
                            }
                            ++n4;
                        }
                        m.worked(1);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            index.releaseReadLock();
            return Status.OK_STATUS;
        }

        public ArrayList<String> getFunctionList() {
            return this.functionList;
        }
    }
}

