/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.FloatDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IDefinitionScope;
import org.eclipse.linuxtools.internal.ctf.core.event.io.BitBuffer;

public class FloatDefinition
extends Definition {
    private final FloatDeclaration declaration;
    private double value;

    public FloatDefinition(FloatDeclaration declaration, IDefinitionScope definitionScope, String fieldName) {
        super(definitionScope, fieldName);
        this.declaration = declaration;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double val) {
        this.value = val;
    }

    @Override
    public FloatDeclaration getDeclaration() {
        return this.declaration;
    }

    @Override
    public void read(BitBuffer input) {
        int mant;
        int exp = this.declaration.getExponent();
        this.value = exp + (mant = this.declaration.getMantissa()) == 32 ? FloatDefinition.readRawFloat32(input, mant, exp) : (exp + mant == 64 ? FloatDefinition.readRawFloat64(input, mant, exp) : Double.NaN);
    }

    private static double readRawFloat64(BitBuffer input, int manBits, int expBits) {
        long low = input.getInt(32, false);
        long high = input.getInt(32, false);
        long temp = (high &= 0xFFFFFFFFL) << 32 | (low &= 0xFFFFFFFFL);
        return FloatDefinition.createFloat(temp, manBits - 1, expBits);
    }

    private static double createFloat(long rawValue, int manBits, int expBits) {
        long manShift = 1L << manBits;
        long manMask = manShift - 1L;
        long expMask = (1L << expBits) - 1L;
        int exp = (int)(rawValue >> manBits & expMask) + 1;
        long man = rawValue & manMask;
        double expPow = Math.pow(2.0, exp - (1 << expBits - 1));
        double ret = (float)man * 1.0f;
        ret /= (double)manShift;
        ret += 1.0;
        return ret *= expPow;
    }

    private static double readRawFloat32(BitBuffer input, int manBits, int expBits) {
        long temp = input.getInt(32, false);
        return FloatDefinition.createFloat(temp, manBits - 1, expBits);
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }
}

