/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.trace;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.eclipse.linuxtools.ctf.core.event.CTFCallsite;
import org.eclipse.linuxtools.ctf.core.event.CTFClock;
import org.eclipse.linuxtools.ctf.core.event.EventDeclaration;
import org.eclipse.linuxtools.ctf.core.event.EventDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.ArrayDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StructDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.Metadata;
import org.eclipse.linuxtools.ctf.core.trace.MetadataComparator;
import org.eclipse.linuxtools.ctf.core.trace.MetadataFileFilter;
import org.eclipse.linuxtools.ctf.core.trace.Utils;
import org.eclipse.linuxtools.internal.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.internal.ctf.core.event.metadata.exceptions.ParseException;
import org.eclipse.linuxtools.internal.ctf.core.trace.Stream;
import org.eclipse.linuxtools.internal.ctf.core.trace.StreamInput;
import org.eclipse.linuxtools.internal.ctf.core.trace.StreamInputPacketIndex;

public class CTFTrace
implements IDefinitionScope {
    private static final String OFFSET = "offset";
    private final File path;
    private final Metadata metadata;
    private Long major;
    private Long minor;
    private UUID uuid;
    private ByteOrder byteOrder;
    private StructDeclaration packetHeaderDecl = null;
    private StructDefinition packetHeaderDef;
    private final HashMap<Long, Stream> streams;
    private final HashMap<String, String> environment;
    private final HashMap<String, CTFClock> clocks;
    private final List<FileChannel> streamFileChannels;
    private static final FileFilter metadataFileFilter = new MetadataFileFilter();
    private static final Comparator<File> metadataComparator = new MetadataComparator();
    private final HashMap<Long, HashMap<Long, EventDeclaration>> eventDecs;
    private final HashMap<StreamInput, HashMap<Long, EventDefinition>> eventDefs;
    private final HashMap<StreamInput, StreamInputPacketIndex> indexes;
    private HashMap<String, LinkedList<CTFCallsite>> callsitesByName = new HashMap();
    private TreeSet<CTFCallsite> callsitesByIP = new TreeSet();
    private CTFClock singleClock;
    private long singleOffset;

    public String toString() {
        return "CTFTrace [path=" + this.path + ", major=" + this.major + ", minor=" + this.minor + ", uuid=" + this.uuid + "]";
    }

    public CTFTrace(String path) throws CTFReaderException {
        this(new File(path));
    }

    public CTFTrace(File path) throws CTFReaderException {
        this.path = path;
        this.metadata = new Metadata(this);
        this.streams = new HashMap();
        this.environment = new HashMap();
        this.clocks = new HashMap();
        this.streamFileChannels = new LinkedList<FileChannel>();
        this.eventDecs = new HashMap();
        this.eventDefs = new HashMap();
        if (!this.path.isDirectory()) {
            throw new CTFReaderException("Path must be a valid directory");
        }
        this.metadata.parse();
        if (this.packetHeaderDecl != null) {
            this.packetHeaderDef = this.packetHeaderDecl.createDefinition(this, "packet.header");
        }
        File[] files = path.listFiles(metadataFileFilter);
        Arrays.sort(files, metadataComparator);
        this.indexes = new HashMap();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File streamFile = fileArray[n2];
            this.openStreamInput(streamFile);
            ++n2;
        }
        for (Map.Entry<Long, Stream> stream : this.streams.entrySet()) {
            Set<StreamInput> inputs = stream.getValue().getStreamInputs();
            for (StreamInput s : inputs) {
                for (Map.Entry<Long, EventDeclaration> pairs : s.getStream().getEvents().entrySet()) {
                    Long eventNum = pairs.getKey();
                    EventDeclaration eventDec = pairs.getValue();
                    this.getEvents(s.getStream().getId()).put(eventNum, eventDec);
                }
                s.setupIndex();
            }
        }
    }

    protected void finalize() throws Throwable {
        for (FileChannel fc : this.streamFileChannels) {
            if (fc == null) continue;
            try {
                fc.close();
            }
            catch (IOException iOException) {}
        }
        super.finalize();
    }

    public HashMap<Long, EventDeclaration> getEvents(Long streamId) {
        return this.eventDecs.get(streamId);
    }

    public StreamInputPacketIndex getIndex(StreamInput id) {
        if (!this.indexes.containsKey(id)) {
            this.indexes.put(id, new StreamInputPacketIndex());
        }
        return this.indexes.get(id);
    }

    public HashMap<Long, EventDefinition> getEventDefs(StreamInput id) {
        if (!this.eventDefs.containsKey(id)) {
            this.eventDefs.put(id, new HashMap());
        }
        return this.eventDefs.get(id);
    }

    public EventDeclaration getEventType(long streamId, long id) {
        return this.getEvents(streamId).get(id);
    }

    public Stream getStream(Long id) {
        return this.streams.get(id);
    }

    public int nbStreams() {
        return this.streams.size();
    }

    public void setMajor(long major) {
        this.major = major;
    }

    public void setMinor(long minor) {
        this.minor = minor;
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public void setPacketHeader(StructDeclaration packetHeader) {
        this.packetHeaderDecl = packetHeader;
    }

    public boolean majortIsSet() {
        return this.major != null;
    }

    public boolean minorIsSet() {
        return this.minor != null;
    }

    public boolean UUIDIsSet() {
        return this.uuid != null;
    }

    public boolean byteOrderIsSet() {
        return this.byteOrder != null;
    }

    public boolean packetHeaderIsSet() {
        return this.packetHeaderDecl != null;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public long getMajor() {
        return this.major;
    }

    public long getMinor() {
        return this.minor;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public StructDeclaration getPacketHeader() {
        return this.packetHeaderDecl;
    }

    public File getTraceDirectory() {
        return this.path;
    }

    public Map<Long, Stream> getStreams() {
        return this.streams;
    }

    @Override
    public String getPath() {
        return this.path.getPath();
    }

    private void openStreamInput(File streamFile) throws CTFReaderException {
        Stream stream;
        MappedByteBuffer byteBuffer;
        FileChannel fc;
        if (!streamFile.canRead()) {
            throw new CTFReaderException("Unreadable file : " + streamFile.getPath());
        }
        try {
            fc = new FileInputStream(streamFile).getChannel();
            this.streamFileChannels.add(fc);
            byteBuffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, 4096L);
        }
        catch (IOException iOException) {
            throw new CTFReaderException();
        }
        BitBuffer streamBitBuffer = new BitBuffer(byteBuffer, this.getByteOrder());
        if (this.packetHeaderDef != null) {
            this.packetHeaderDef.read(streamBitBuffer);
            IntegerDefinition magicDef = (IntegerDefinition)this.packetHeaderDef.lookupDefinition("magic");
            int magic = (int)magicDef.getValue();
            if (magic != -1040441407) {
                throw new CTFReaderException("CTF magic mismatch");
            }
            ArrayDefinition uuidDef = (ArrayDefinition)this.packetHeaderDef.lookupDefinition("uuid");
            if (uuidDef != null) {
                byte[] uuidArray = new byte[16];
                int i = 0;
                while (i < 16) {
                    IntegerDefinition uuidByteDef = (IntegerDefinition)uuidDef.getElem(i);
                    uuidArray[i] = (byte)uuidByteDef.getValue();
                    ++i;
                }
                UUID otheruuid = Utils.makeUUID(uuidArray);
                if (!this.uuid.equals(otheruuid)) {
                    throw new CTFReaderException("UUID mismatch");
                }
            }
            IntegerDefinition streamIDDef = (IntegerDefinition)this.packetHeaderDef.lookupDefinition("stream_id");
            assert (streamIDDef != null);
            long streamID = streamIDDef.getValue();
            stream = this.streams.get(streamID);
        } else {
            stream = this.streams.get(null);
        }
        StreamInput streamInput = new StreamInput(stream, fc, streamFile);
        stream.addInput(streamInput);
    }

    @Override
    public Definition lookupDefinition(String lookupPath) {
        if (lookupPath.equals("trace.packet.header")) {
            return this.packetHeaderDef;
        }
        return null;
    }

    public void addStream(Stream stream) throws ParseException {
        if (this.streams.get(null) != null) {
            throw new ParseException("Stream without id with multiple streams");
        }
        if (stream.getId() == null && this.streams.size() != 0) {
            throw new ParseException("Stream without id with multiple streams");
        }
        if (this.streams.get(stream.getId()) != null) {
            throw new ParseException("Stream id already exists");
        }
        this.streams.put(stream.getId(), stream);
        this.eventDecs.put(stream.getId(), new HashMap());
    }

    public HashMap<String, String> getEnvironment() {
        return this.environment;
    }

    public String lookupEnvironment(String key) {
        return this.environment.get(key);
    }

    public void addEnvironmentVar(String varName, String varValue) {
        this.environment.put(varName, varValue);
    }

    public void addClock(String nameValue, CTFClock ctfClock) {
        this.clocks.put(nameValue, ctfClock);
    }

    public CTFClock getClock(String name) {
        return this.clocks.get(name);
    }

    public final CTFClock getClock() {
        if (this.clocks.size() == 1) {
            if (this.singleClock == null) {
                this.singleClock = this.clocks.get(this.clocks.keySet().toArray()[0]);
                if (this.singleClock.getProperty(OFFSET) != null) {
                    this.singleOffset = (Long)this.getClock().getProperty(OFFSET);
                } else {
                    this.singleClock.addAttribute(OFFSET, 0);
                }
            }
            return this.singleClock;
        }
        return null;
    }

    public final long getOffset() {
        if (this.getClock() == null) {
            return 0L;
        }
        return this.singleOffset;
    }

    public boolean hasEvents(Long id) {
        return this.eventDecs.containsKey(id);
    }

    public HashMap<Long, EventDeclaration> createEvents(Long id) {
        HashMap<Long, EventDeclaration> value = this.eventDecs.get(id);
        if (value == null) {
            value = new HashMap();
            this.eventDecs.put(id, value);
        }
        return value;
    }

    public void addCallsite(String eventName, String funcName, long ip, String fileName, long lineNumber) {
        CTFCallsite cs = new CTFCallsite(eventName, funcName, ip, fileName, lineNumber);
        LinkedList<CTFCallsite> csl = this.callsitesByName.get(eventName);
        if (csl == null) {
            csl = new LinkedList();
            this.callsitesByName.put(eventName, csl);
        }
        ListIterator iter = csl.listIterator();
        int index = 0;
        while (index < csl.size()) {
            if (((CTFCallsite)iter.next()).compareTo(cs) < 0) break;
            ++index;
        }
        csl.add(index, cs);
        this.callsitesByIP.add(cs);
    }

    public List<CTFCallsite> getCallsiteCandidates(String eventName) {
        LinkedList<CTFCallsite> retVal = this.callsitesByName.get(eventName);
        if (retVal == null) {
            retVal = new LinkedList();
        }
        return retVal;
    }

    public CTFCallsite getCallsite(String eventName) {
        return this.callsitesByName.get(eventName).getFirst();
    }

    public CTFCallsite getCallsite(long ip) {
        CTFCallsite cs = new CTFCallsite(null, null, ip, null, 0L);
        return this.callsitesByIP.ceiling(cs);
    }

    public CTFCallsite getCallsite(String eventName, long ip) {
        CTFCallsite dummyCs;
        LinkedList<CTFCallsite> candidates = this.callsitesByName.get(eventName);
        int pos = Collections.binarySearch(candidates, dummyCs = new CTFCallsite(null, null, ip, null, -1L)) + 1;
        if (pos >= candidates.size()) {
            return null;
        }
        return candidates.get(pos);
    }
}

