/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng2.kernel.core.trace;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.CTFTrace;
import org.eclipse.linuxtools.internal.lttng2.kernel.core.stateprovider.CtfKernelStateInput;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfTrace;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateChangeInput;
import org.eclipse.linuxtools.tmf.core.statesystem.StateSystemManager;

public class CtfKernelTrace
extends CtfTmfTrace {
    public static final String HISTORY_TREE_FILE_NAME = "stateHistory.ht";

    public boolean validate(IProject project, String path) {
        CTFTrace temp;
        try {
            temp = new CTFTrace(path);
        }
        catch (CTFReaderException cTFReaderException) {
            return false;
        }
        String dom = (String)temp.getEnvironment().get("domain");
        return dom != null && dom.equals("\"kernel\"");
    }

    protected void buildStateSystem() throws TmfTraceException {
        IResource resource = this.getResource();
        String supplDirectory = null;
        try {
            supplDirectory = resource.getPersistentProperty(TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER);
        }
        catch (CoreException e) {
            throw new TmfTraceException(e.toString(), (Throwable)e);
        }
        File htFile = new File(String.valueOf(supplDirectory) + File.separator + HISTORY_TREE_FILE_NAME);
        CtfKernelStateInput htInput = new CtfKernelStateInput(this);
        this.ss = StateSystemManager.loadStateHistory((File)htFile, (IStateChangeInput)htInput, (boolean)false);
    }
}

