/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.profiling.launch;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.TextConsole;

public abstract class ProfileLaunchConfigurationDelegate
extends AbstractCLaunchDelegate {
    protected boolean testOutput(String outputPath) {
        try {
            File tempFile = new File(outputPath);
            tempFile.delete();
            tempFile.createNewFile();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    protected IProcess createProcess(ILaunchConfiguration config, ILaunch launch) throws CoreException, IOException {
        File workDir = this.getWorkingDirectory(config);
        if (workDir == null) {
            workDir = new File(System.getProperty("user.home", "."));
        }
        String cmd = this.generateCommand(config);
        File script = File.createTempFile("org.eclipse.linuxtools.profiling.launch" + System.currentTimeMillis(), ".sh");
        String data = "#!/bin/sh\nexec " + cmd;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(script);
            out.write(data.getBytes());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        String[] commandArray = this.prepareCommand("sh " + script.getAbsolutePath());
        Process subProcess = this.execute(commandArray, this.getEnvironment(config), workDir, true);
        IProcess process = this.createNewProcess(launch, subProcess, commandArray[0]);
        process.setAttribute(IProcess.ATTR_CMDLINE, cmd);
        return process;
    }

    public abstract String generateCommand(ILaunchConfiguration var1);

    protected String[] prepareCommand(String cmd) {
        String[] tmp = cmd.split(" ");
        ArrayList<String> cmdLine = new ArrayList<String>();
        String[] stringArray = tmp;
        int n = tmp.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            cmdLine.add(str);
            ++n2;
        }
        return cmdLine.toArray(new String[cmdLine.size()]);
    }

    public Process execute(String[] commandArray, String[] env, File wd, boolean usePty) {
        Process process = null;
        try {
            process = wd == null ? ProcessFactory.getFactory().exec(commandArray, env) : (PTY.isSupported() && usePty ? ProcessFactory.getFactory().exec(commandArray, env, wd, new PTY()) : ProcessFactory.getFactory().exec(commandArray, env, wd));
        }
        catch (IOException iOException) {
            return null;
        }
        return process;
    }

    protected IProcess createNewProcess(ILaunch launch, Process systemProcess, String programName) {
        return DebugPlugin.newProcess((ILaunch)launch, (Process)systemProcess, (String)this.renderProcessLabel(programName));
    }

    public static TextConsole getConsole(String search) {
        int i = 0;
        while (i < ConsolePlugin.getDefault().getConsoleManager().getConsoles().length) {
            if (ConsolePlugin.getDefault().getConsoleManager().getConsoles()[i].getName().contains(search)) {
                return (TextConsole)ConsolePlugin.getDefault().getConsoleManager().getConsoles()[i];
            }
            ++i;
        }
        return null;
    }

    public static String getMainConsoleText(String search) {
        TextConsole proc = ProfileLaunchConfigurationDelegate.getConsole(search);
        return proc.getDocument().get();
    }

    public static IDocument getConsoleDocument(String search) {
        return ProfileLaunchConfigurationDelegate.getConsole(search).getDocument();
    }
}

