/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.profiling.ui;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementVisitor;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.linuxtools.internal.profiling.ui.ProfileUIPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileUIUtils {
    public static void openEditorAndSelect(String path, int line) throws PartInitException, BadLocationException {
        IFileStore file;
        IWorkbenchPage activePage;
        IEditorPart editor;
        Path p = new Path(path);
        if (p.toFile().exists() && (editor = IDE.openEditorOnFileStore((IWorkbenchPage)(activePage = ProfileUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage()), (IFileStore)(file = EFS.getLocalFileSystem().getStore((IPath)p)))) instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            if (line > 0) {
                IDocumentProvider provider = textEditor.getDocumentProvider();
                IDocument document = provider.getDocument((Object)textEditor.getEditorInput());
                int start = document.getLineOffset(line - 1);
                textEditor.selectAndReveal(start, 0);
            }
        }
    }

    public static void openEditorAndSelect(ISourceLookupResult result, int line) throws PartInitException, BadLocationException {
        IWorkbenchPage activePage;
        IEditorPart editor;
        Object sourceElement;
        IEditorInput input = result.getEditorInput();
        String editorID = result.getEditorId();
        if ((input == null || editorID == null) && (sourceElement = result.getSourceElement()) != null) {
            if (sourceElement instanceof LocalFileStorage) {
                IPath filePath = ((LocalFileStorage)sourceElement).getFullPath();
                URI fileURI = URIUtil.toURI((IPath)filePath);
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IFile[] files = root.findFilesForLocationURI(fileURI);
                if (files.length > 0) {
                    sourceElement = files[0];
                }
            }
            IDebugModelPresentation pres = DebugUITools.newDebugModelPresentation((String)CDebugCorePlugin.getUniqueIdentifier());
            input = pres.getEditorInput(sourceElement);
            editorID = pres.getEditorId(input, sourceElement);
            pres.dispose();
        }
        if (input != null && editorID != null && (editor = IDE.openEditor((IWorkbenchPage)(activePage = ProfileUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage()), (IEditorInput)input, (String)editorID)) instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            if (line > 0) {
                IDocumentProvider provider = textEditor.getDocumentProvider();
                IDocument document = provider.getDocument((Object)textEditor.getEditorInput());
                IRegion lineRegion = document.getLineInformation(line - 1);
                textEditor.selectAndReveal(lineRegion.getOffset(), lineRegion.getLength());
            }
        }
    }

    public static void openEditorAndSelect(String path, int offset, int length) throws PartInitException {
        IFileStore fileStore;
        IWorkbenchPage activePage;
        IEditorPart editor;
        Path p = new Path(path);
        if (p.toFile().exists() && (editor = IDE.openEditorOnFileStore((IWorkbenchPage)(activePage = ProfileUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage()), (IFileStore)(fileStore = EFS.getLocalFileSystem().getStore((IPath)p)))) instanceof ITextEditor) {
            ITextEditor text = (ITextEditor)editor;
            text.selectAndReveal(offset, length);
        }
    }

    public static ICProject findCProjectWithAbsolutePath(final String absPath) throws CoreException {
        ICProject[] cProjects;
        final String workspaceLoc = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        final ArrayList ret = new ArrayList();
        ICElementVisitor vis = new ICElementVisitor(){

            public boolean visit(ICElement element) {
                if (element.getElementType() == 12 || element.getElementType() == 11) {
                    return true;
                }
                if (absPath.equals(String.valueOf(workspaceLoc) + element.getPath().toFile().getAbsolutePath())) {
                    ret.add(element.getCProject());
                }
                return false;
            }
        };
        ICProject[] iCProjectArray = cProjects = CCorePlugin.getDefault().getCoreModel().getCModel().getCProjects();
        int n = cProjects.length;
        int n2 = 0;
        while (n2 < n) {
            ICProject proj = iCProjectArray[n2];
            proj.accept(vis);
            ++n2;
        }
        return ret.size() == 0 ? null : (ICProject)ret.get(0);
    }

    /*
     * Exception decompiling
     */
    public static HashMap<String, int[]> findFunctionsInProject(ICProject project, String functionName, int numArgs, String fileHint) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static HashMap<String, int[]> findFunctionsInProject(ICProject project, String functionName, int numArgs, String fileHint, boolean needResult) {
        HashMap<String, int[]> map = ProfileUIUtils.findFunctionsInProject(project, functionName, numArgs, fileHint);
        if (needResult && map.size() == 0 && (map = ProfileUIUtils.findFunctionsInProject(project, functionName, -1, fileHint)).size() == 0) {
            return ProfileUIUtils.findFunctionsInProject(project, functionName, -1, null);
        }
        return map;
    }
}

