/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rdt.proxy;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.linuxtools.internal.rdt.proxy.Messages;
import org.eclipse.linuxtools.internal.rdt.proxy.RemoteProcessClosure;
import org.eclipse.linuxtools.profiling.launch.IRemoteCommandLauncher;
import org.eclipse.linuxtools.rdt.proxy.Activator;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.core.RemoteProcessAdapter;

public class RDTCommandLauncher
implements IRemoteCommandLauncher {
    public static final int COMMAND_CANCELED = 1;
    public static final int ILLEGAL_COMMAND = -1;
    public static final int OK = 0;
    protected IRemoteProcess fProcess = null;
    protected boolean fShowCommand = false;
    protected String[] fCommandArgs;
    protected String fErrorMessage = "";
    private String lineSeparator;
    private URI uri;
    protected static final long DELAY = 50L;

    public RDTCommandLauncher(IProject project) {
        this.uri = project.getLocationURI();
        this.lineSeparator = System.getProperty("line.separator", "\n");
    }

    public RDTCommandLauncher(URI uri) {
        this.uri = uri;
        this.lineSeparator = System.getProperty("line.separator", "\n");
    }

    public void showCommand(boolean show) {
        this.fShowCommand = show;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public void setErrorMessage(String error) {
        this.fErrorMessage = error;
    }

    public String[] getCommandArgs() {
        return this.fCommandArgs;
    }

    public String getCommandLine() {
        return this.getCommandLine(this.getCommandArgs());
    }

    protected String[] constructCommandArray(String command, String[] commandArgs) {
        String[] args = new String[1 + commandArgs.length];
        args[0] = command;
        System.arraycopy(commandArgs, 0, args, 1, commandArgs.length);
        return args;
    }

    public Process execute(IPath commandPath, String[] args, String[] env, IPath changeToDirectory, IProgressMonitor monitor) {
        try {
            this.fCommandArgs = this.constructCommandArray(commandPath.toOSString(), args);
            this.fShowCommand = true;
            IRemoteServices services = PTPRemoteCorePlugin.getDefault().getRemoteServices(this.uri);
            IRemoteConnection connection = services.getConnectionManager().getConnection(this.uri);
            IRemoteFileManager fm = services.getFileManager(connection);
            IRemoteProcessBuilder builder = services.getProcessBuilder(connection, Arrays.asList(this.fCommandArgs));
            if (changeToDirectory != null) {
                builder.directory(fm.getResource(changeToDirectory.toString()));
            }
            Map envMap = builder.environment();
            int i = 0;
            while (i < env.length) {
                String s = env[i];
                String[] tokens = s.split("=", 2);
                switch (tokens.length) {
                    case 1: {
                        envMap.put(tokens[0], null);
                        break;
                    }
                    case 2: {
                        envMap.put(tokens[0], tokens[1]);
                        break;
                    }
                    default: {
                        Activator.log(2, String.valueOf(Messages.RDTCommandLauncher_malformed_env_var_string) + s);
                    }
                }
                ++i;
            }
            this.fProcess = builder.start();
            this.fErrorMessage = "";
        }
        catch (IOException e) {
            this.setErrorMessage(e.getMessage());
            return null;
        }
        return new RemoteProcessAdapter(this.fProcess);
    }

    public int waitAndRead(OutputStream output, OutputStream err, IProgressMonitor monitor) {
        if (this.fShowCommand) {
            this.printCommandLine(output);
        }
        if (this.fProcess == null) {
            return -1;
        }
        RemoteProcessClosure closure = new RemoteProcessClosure(this.fProcess, output, err);
        closure.runNonBlocking();
        while (!monitor.isCanceled() && closure.isAlive()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        int state = 0;
        if (monitor.isCanceled()) {
            closure.terminate();
            state = 1;
            this.setErrorMessage(Activator.getResourceString("CommandLauncher.error.commandCanceled"));
        }
        try {
            this.fProcess.waitFor();
        }
        catch (InterruptedException interruptedException) {}
        return state;
    }

    protected void printCommandLine(OutputStream os) {
        if (os != null) {
            String cmd = this.getCommandLine(this.getCommandArgs());
            try {
                os.write(cmd.getBytes());
                os.flush();
            }
            catch (IOException iOException) {}
        }
    }

    protected String getCommandLine(String[] commandArgs) {
        StringBuffer buf = new StringBuffer();
        if (this.fCommandArgs != null) {
            String[] stringArray = commandArgs;
            int n = commandArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String commandArg = stringArray[n2];
                buf.append(commandArg);
                buf.append(' ');
                ++n2;
            }
            buf.append(this.lineSeparator);
        }
        return buf.toString();
    }
}

