/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rdt.proxy;

import java.net.URI;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.rdt.proxy.Activator;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;

public class RDTFileProxy
implements IRemoteFileProxy {
    private IRemoteFileManager manager;

    private void initialize(URI uri) throws CoreException {
        IRemoteServices services = PTPRemoteCorePlugin.getDefault().getRemoteServices(uri);
        services.initialize();
        IRemoteConnection connection = services.getConnectionManager().getConnection(uri);
        if (connection == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.rdt.proxy", Activator.getResourceString("Connection.error")));
        }
        this.manager = services.getFileManager(connection);
    }

    public RDTFileProxy(URI uri) throws CoreException {
        this.initialize(uri);
    }

    public RDTFileProxy(IProject project) throws CoreException {
        URI uri = project.getLocationURI();
        this.initialize(uri);
    }

    public URI toURI(IPath path) {
        return this.manager.toURI(path);
    }

    public URI toURI(String path) {
        return this.manager.toURI(path);
    }

    public String toPath(URI uri) {
        return this.manager.toPath(uri);
    }

    public String getDirectorySeparator() {
        return this.manager.getDirectorySeparator();
    }

    public IFileStore getResource(String path) {
        return this.manager.getResource(path);
    }
}

