/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rdt.proxy;

import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.internal.rdt.proxy.RDTCommandLauncher;
import org.eclipse.linuxtools.internal.rdt.proxy.RDTFileProxy;
import org.eclipse.linuxtools.profiling.launch.IRemoteCommandLauncher;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.IRemoteProxyManager;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;

public class RDTProxyManager
implements IRemoteProxyManager {
    public IRemoteFileProxy getFileProxy(URI uri) throws CoreException {
        return new RDTFileProxy(uri);
    }

    public IRemoteFileProxy getFileProxy(IProject project) throws CoreException {
        return new RDTFileProxy(project);
    }

    public IRemoteCommandLauncher getLauncher(URI uri) {
        return new RDTCommandLauncher(uri);
    }

    public IRemoteCommandLauncher getLauncher(IProject project) {
        return new RDTCommandLauncher(project);
    }

    public String getOS(URI uri) {
        IRemoteServices services = PTPRemoteCorePlugin.getDefault().getRemoteServices(uri);
        IRemoteConnection connection = services.getConnectionManager().getConnection(uri);
        String os = connection.getProperty("os.name");
        if (os == null || os.length() == 0) {
            return "Linux";
        }
        return os;
    }

    public String getOS(IProject project) {
        URI uri = project.getLocationURI();
        return this.getOS(uri);
    }
}

