/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.consolelog;

import java.io.IOException;
import org.eclipse.linuxtools.systemtap.ui.consolelog.LoggedCommand2;
import org.eclipse.linuxtools.systemtap.ui.structures.IPasswordPrompt;
import org.eclipse.linuxtools.systemtap.ui.structures.runnable.StreamGobbler;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;

public class LocalLoggedCommand
extends LoggedCommand2 {
    private String[] cmd;
    private String[] envVars;
    private Process process;

    public LocalLoggedCommand(String[] cmd, String[] envVars, IPasswordPrompt prompt, int monitorDelay, String moduleName) {
        super(cmd, envVars, prompt, monitorDelay, moduleName);
        this.envVars = envVars;
        this.cmd = cmd;
    }

    protected boolean init() {
        try {
            this.process = RuntimeProcessFactory.getFactory().exec(this.cmd, this.envVars, null);
            this.errorGobbler = new StreamGobbler(this.process.getErrorStream());
            this.inputGobbler = new StreamGobbler(this.process.getInputStream());
            this.transferListeners();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void run() {
        this.errorGobbler.start();
        this.inputGobbler.start();
        try {
            this.process.waitFor();
        }
        catch (InterruptedException interruptedException) {}
        this.stop();
    }

    public synchronized void stop() {
        if (!this.stopped) {
            this.process.destroy();
            this.stopped = true;
            if (this.errorGobbler != null) {
                this.errorGobbler.stop();
            }
            if (this.inputGobbler != null) {
                this.inputGobbler.stop();
            }
        }
    }
}

