/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.dataset;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.internal.systemtap.ui.graphingapi.ui.Localization;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.dataset.DataSetFactory;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.dataset.DataSetWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SelectDataSetWizardPage
extends WizardPage {
    private SelectionListener buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (e.widget instanceof Button) {
                Button target = (Button)e.widget;
                int i = 0;
                while (i < SelectDataSetWizardPage.this.btnDataSets.length) {
                    if (target == SelectDataSetWizardPage.this.btnDataSets[i]) {
                        SelectDataSetWizardPage.this.dataSetID = SelectDataSetWizardPage.this.btnDataSets[i].getData().toString();
                        SelectDataSetWizardPage.this.wizard.getContainer().updateButtons();
                    }
                    ++i;
                }
            }
        }
    };
    private Button[] btnDataSets;
    private String dataSetID;
    private DataSetWizard wizard;

    public SelectDataSetWizardPage() {
        super("selectDataSetType");
        this.setTitle(Localization.getString("SelectDataSetWizardPage.SelectDataSetType"));
        this.dataSetID = "";
        this.btnDataSets = null;
    }

    public void createControl(Composite parent) {
        this.wizard = (DataSetWizard)super.getWizard();
        Composite comp = new Composite(parent, 0);
        GridData layoutData = new GridData(1808);
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        GridLayout gridLayout = new GridLayout(2, false);
        comp.setLayout((Layout)gridLayout);
        String[] ids = DataSetFactory.getIDs();
        this.btnDataSets = new Button[ids.length];
        int i = 0;
        while (i < this.btnDataSets.length) {
            this.btnDataSets[i] = new Button(comp, 16);
            this.btnDataSets[i].setText(DataSetFactory.getName(ids[i]));
            this.btnDataSets[i].addSelectionListener(this.buttonListener);
            this.btnDataSets[i].setData((Object)ids[i]);
            Label lblDesc = new Label(comp, 64);
            lblDesc.setText(DataSetFactory.getDescription(this.btnDataSets[i].getData().toString()));
            Label separator = new Label(comp, 258);
            GridData separatorData = new GridData(768);
            separatorData.horizontalSpan = 2;
            separator.setLayoutData((Object)separatorData);
            ++i;
        }
        this.setControl((Control)comp);
    }

    public boolean canFlipToNextPage() {
        return !this.dataSetID.isEmpty();
    }

    public IWizardPage getNextPage() {
        return DataSetFactory.getParsingWizardPage(this.dataSetID);
    }

    public void dispose() {
        super.dispose();
        if (this.btnDataSets != null) {
            int i = 0;
            while (i < this.btnDataSets.length) {
                this.btnDataSets[i].removeSelectionListener(this.buttonListener);
                this.btnDataSets[i].dispose();
                this.btnDataSets[i] = null;
                ++i;
            }
        }
        this.btnDataSets = null;
    }
}

