/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.hidden;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.Localization;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.hidden.TreeExpandCollapseAction;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPEditor;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.views.KernelBrowserView;
import org.eclipse.linuxtools.systemtap.ui.ide.IDESessionSettings;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.linuxtools.systemtap.ui.structures.TreeNode;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class KernelSourceAction
extends Action
implements ISelectionListener,
ActionFactory.IWorkbenchAction {
    private final IWorkbenchWindow window;
    public static final String ID = "org.eclipse.linuxtools.systemtap.ui.ide.KBAction";
    private KernelBrowserView viewer;
    private IStructuredSelection selection;
    private TreeExpandCollapseAction expandAction;

    public KernelSourceAction(IWorkbenchWindow window, KernelBrowserView browser) {
        LogManager.logDebug((String)("Start KernelSourceAction: window-" + window + ", browser-" + (Object)((Object)browser)), (Object)((Object)this));
        LogManager.logInfo((String)"Initializing", (Object)((Object)this));
        this.window = window;
        this.setId(ID);
        this.setActionDefinitionId(ID);
        this.setText(Localization.getString("KernelSourceAction.Insert"));
        this.setToolTipText(Localization.getString("KernelSourceAction.InsertSelectedFunction"));
        window.getSelectionService().addSelectionListener((ISelectionListener)this);
        this.viewer = browser;
        this.expandAction = new TreeExpandCollapseAction(KernelBrowserView.class);
        LogManager.logDebug((String)"End KernelSourceAction:", (Object)((Object)this));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection incoming) {
        if (incoming instanceof IStructuredSelection) {
            LogManager.logDebug((String)"Changing selection", (Object)((Object)this));
            this.selection = (IStructuredSelection)incoming;
            this.setEnabled(this.selection.size() == 1);
        } else {
            LogManager.logDebug((String)"Disabling, selection not IStructuredSelection", (Object)((Object)this));
            this.setEnabled(false);
        }
    }

    public void dispose() {
        LogManager.logInfo((String)"Disposing", (Object)((Object)this));
        this.window.getSelectionService().removeSelectionListener((ISelectionListener)this);
    }

    private IEditorInput createEditorInput(IFileStore fs) {
        FileStoreEditorInput input = new FileStoreEditorInput(fs);
        LogManager.logDebug((String)("createEditorInput: returnVal-" + input), (Object)((Object)this));
        return input;
    }

    public void run() {
        LogManager.logDebug((String)"Start run", (Object)((Object)this));
        IWorkbench wb = PlatformUI.getWorkbench();
        ISelection incoming = this.viewer.getViewer().getSelection();
        IStructuredSelection selection = (IStructuredSelection)incoming;
        Object o = selection.getFirstElement();
        if (o instanceof TreeNode) {
            TreeNode t = (TreeNode)o;
            if (t.isClickable()) {
                IFileStore fs = (IFileStore)t.getData();
                if (fs != null) {
                    IEditorInput input = this.createEditorInput(fs);
                    try {
                        IEditorPart editor = wb.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                        if (editor instanceof STPEditor) {
                            IDESessionSettings.activeSTPEditor = (STPEditor)editor;
                        }
                        wb.getActiveWorkbenchWindow().getActivePage().openEditor(input, "org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.c.CEditor");
                        LogManager.logDebug((String)"Editor opened", (Object)((Object)this));
                    }
                    catch (PartInitException e) {
                        LogManager.logCritical((String)("PartInitException run: " + e.getMessage()), (Object)((Object)this));
                    }
                }
            } else {
                this.expandAction.run();
            }
        }
        LogManager.logDebug((String)"End run", (Object)((Object)this));
    }
}

