/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp;

import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class STPPartitionScanner
extends RuleBasedPartitionScanner {
    public static final String STP_COMMENT = "__stp_comment";
    public static final String STP_KEYWORD = "__stp_keyword";
    public static final String STP_STRING = "__stp_string";
    public static final String STP_CONDITIONAL = "__stp_conditional";
    public static String[] STP_PARTITION_TYPES = new String[]{"__dftl_partition_content_type", "__stp_comment", "__stp_keyword", "__stp_string", "__stp_conditional"};

    public STPPartitionScanner() {
        Token stpComment = new Token((Object)STP_COMMENT);
        Token stpString = new Token((Object)STP_STRING);
        Token stpConditional = new Token((Object)STP_CONDITIONAL);
        EmptyCommentRule emptyCommentRule = new EmptyCommentRule((IToken)stpComment);
        this.setPredicateRules(new IPredicateRule[]{new MultiLineRule("/*", "*/", (IToken)stpComment), new EndOfLineRule("/*", (IToken)stpComment), new EndOfLineRule("#", (IToken)stpComment), new EndOfLineRule("//", (IToken)stpComment), emptyCommentRule, new EndOfLineRule("#if", (IToken)stpConditional), new EndOfLineRule("#else", (IToken)stpConditional), new EndOfLineRule("#endif", (IToken)stpConditional), new EndOfLineRule("#define", (IToken)stpConditional), new SingleLineRule("\"", "\"", (IToken)stpString, '\\'), new SingleLineRule("'", "'", (IToken)stpString, '\\')});
    }

    static class EmptyCommentDetector
    implements IWordDetector {
        EmptyCommentDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '/';
        }

        public boolean isWordPart(char c) {
            return c == '*' || c == '/';
        }
    }

    static class EmptyCommentRule
    extends WordRule
    implements IPredicateRule {
        private IToken fSuccessToken;

        public EmptyCommentRule(IToken successToken) {
            super((IWordDetector)new EmptyCommentDetector());
            this.fSuccessToken = successToken;
            this.addWord("/**/", this.fSuccessToken);
        }

        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            return this.evaluate(scanner);
        }

        public IToken getSuccessToken() {
            return this.fSuccessToken;
        }
    }
}

