/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.RunScriptByPathAction;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.ConsoleLogPlugin;
import org.eclipse.ui.PlatformUI;

public class SystemTapScriptLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        RunScriptByPathAction action = new RunScriptByPathAction();
        IPreferenceStore preferenceStore = ConsoleLogPlugin.getDefault().getPreferenceStore();
        String path = configuration.getAttribute("ScriptPath", "");
        action.init(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), path);
        String userName = configuration.getAttribute("userName", "");
        preferenceStore.setValue("scpuser", userName);
        String password = configuration.getAttribute("userPassword", "");
        preferenceStore.setValue("scppassword", password);
        boolean runAsCurrentUser = configuration.getAttribute("executeAsCurrentUser", true);
        boolean runLocal = configuration.getAttribute("executeOnLocalHost", true);
        action.setLocalScript(runLocal && runAsCurrentUser);
        String hostName = configuration.getAttribute("hostName", "localhost");
        preferenceStore.setValue("host", hostName);
        action.run();
    }
}

