/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher.Messages;
import org.eclipse.linuxtools.systemtap.ui.editor.PathEditorInput;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.ResourceUtil;

public class SystemTapScriptLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    static final String SCRIPT_PATH_ATTR = "ScriptPath";
    static final String CURRENT_USER_ATTR = "executeAsCurrentUser";
    static final String USER_NAME_ATTR = "userName";
    static final String USER_PASS_ATTR = "userPassword";
    static final String LOCAL_HOST_ATTR = "executeOnLocalHost";
    static final String HOST_NAME_ATTR = "hostName";
    private Text scriptPathText;
    private Button currentUserCheckButton;
    private Text userNameText;
    private Text userPasswordText;
    private Button localHostCheckButton;
    private Text hostNameText;
    private Label userNameLabel;
    private Label userPasswordLabel;
    private Label hostNamelabel;

    public void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        Composite top = new Composite(parent, 0);
        this.setControl((Control)top);
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(4, 4, true, true));
        Group scriptSettingsGroup = new Group(top, 16);
        scriptSettingsGroup.setText(Messages.SystemTapScriptLaunchConfigurationTab_0);
        scriptSettingsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        layout = new GridLayout();
        layout.numColumns = 2;
        scriptSettingsGroup.setLayout((Layout)layout);
        this.scriptPathText = new Text((Composite)scriptSettingsGroup, 2052);
        this.scriptPathText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scriptPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemTapScriptLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button selectScriptButon = new Button((Composite)scriptSettingsGroup, 0);
        GridData gridData = new GridData();
        gridData.widthHint = 110;
        selectScriptButon.setLayoutData((Object)gridData);
        selectScriptButon.setText(Messages.SystemTapScriptLaunchConfigurationTab_1);
        Group userSettingsGroup = new Group(top, 16);
        layout = new GridLayout();
        userSettingsGroup.setLayout((Layout)layout);
        layout.numColumns = 2;
        userSettingsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.currentUserCheckButton = new Button((Composite)userSettingsGroup, 32);
        this.currentUserCheckButton.setText(Messages.SystemTapScriptLaunchConfigurationTab_2);
        this.currentUserCheckButton.setSelection(true);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.currentUserCheckButton.setLayoutData((Object)gridData);
        this.userNameLabel = new Label((Composite)userSettingsGroup, 0);
        this.userNameLabel.setText(Messages.SystemTapScriptLaunchConfigurationTab_3);
        this.userNameText = new Text((Composite)userSettingsGroup, 2052);
        this.userNameText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.userPasswordLabel = new Label((Composite)userSettingsGroup, 0);
        this.userPasswordLabel.setText(Messages.SystemTapScriptLaunchConfigurationTab_4);
        this.userPasswordText = new Text((Composite)userSettingsGroup, 0x400804);
        this.userPasswordText.setLayoutData((Object)new GridData(4, 4, true, false));
        userSettingsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        userSettingsGroup.setText(Messages.SystemTapScriptLaunchConfigurationTab_5);
        this.currentUserCheckButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.update();
            }

            private void update() {
                boolean enable = !SystemTapScriptLaunchConfigurationTab.this.currentUserCheckButton.getSelection();
                SystemTapScriptLaunchConfigurationTab.this.setUserGroupEnablement(enable);
                SystemTapScriptLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.userNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemTapScriptLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.userPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemTapScriptLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.setUserGroupEnablement(false);
        Group hostSettingsGroup = new Group(top, 16);
        hostSettingsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        hostSettingsGroup.setText(Messages.SystemTapScriptLaunchConfigurationTab_6);
        layout = new GridLayout();
        hostSettingsGroup.setLayout((Layout)layout);
        layout.numColumns = 2;
        this.localHostCheckButton = new Button((Composite)hostSettingsGroup, 32);
        this.localHostCheckButton.setText(Messages.SystemTapScriptLaunchConfigurationTab_7);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.hostNamelabel = new Label((Composite)hostSettingsGroup, 0);
        this.hostNamelabel.setText(Messages.SystemTapScriptLaunchConfigurationTab_8);
        this.hostNameText = new Text((Composite)hostSettingsGroup, 2052);
        this.hostNameText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.localHostCheckButton.setLayoutData((Object)gridData);
        this.localHostCheckButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.update();
            }

            private void update() {
                SystemTapScriptLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.hostNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemTapScriptLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void setUserGroupEnablement(boolean enable) {
        this.userNameText.setEnabled(enable);
        this.userNameLabel.setEnabled(enable);
        this.userPasswordText.setEnabled(enable);
        this.userPasswordLabel.setEnabled(enable);
    }

    private void setHostGroupEnablement(boolean enable) {
        this.hostNamelabel.setEnabled(enable);
        this.hostNameText.setEnabled(enable);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(SCRIPT_PATH_ATTR, this.getSelectedScriptPath());
        configuration.setAttribute(CURRENT_USER_ATTR, true);
        configuration.setAttribute(USER_NAME_ATTR, "");
        configuration.setAttribute(USER_PASS_ATTR, "");
        configuration.setAttribute(LOCAL_HOST_ATTR, true);
        configuration.setAttribute(HOST_NAME_ATTR, "");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.scriptPathText.setText(configuration.getAttribute(SCRIPT_PATH_ATTR, ""));
            this.currentUserCheckButton.setSelection(configuration.getAttribute(CURRENT_USER_ATTR, true));
            this.userNameText.setText(configuration.getAttribute(USER_NAME_ATTR, ""));
            this.userPasswordText.setText(configuration.getAttribute(USER_PASS_ATTR, ""));
            this.localHostCheckButton.setSelection(configuration.getAttribute(LOCAL_HOST_ATTR, true));
            this.hostNameText.setText(configuration.getAttribute(HOST_NAME_ATTR, ""));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(SCRIPT_PATH_ATTR, this.scriptPathText.getText());
        configuration.setAttribute(CURRENT_USER_ATTR, this.currentUserCheckButton.getSelection());
        configuration.setAttribute(USER_NAME_ATTR, this.userNameText.getText());
        configuration.setAttribute(USER_PASS_ATTR, this.userPasswordText.getText());
        configuration.setAttribute(LOCAL_HOST_ATTR, this.localHostCheckButton.getSelection());
        configuration.setAttribute(HOST_NAME_ATTR, this.hostNameText.getText());
        boolean enable = !this.currentUserCheckButton.getSelection();
        this.setUserGroupEnablement(enable);
        enable = !this.localHostCheckButton.getSelection();
        this.setHostGroupEnablement(enable);
    }

    public String getName() {
        return Messages.SystemTapScriptLaunchConfigurationTab_9;
    }

    private String getSelectedScriptPath() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        String pathString = "";
        if (window != null) {
            Object selectedElement;
            ISelection selection = window.getSelectionService().getSelection();
            if (selection instanceof TreeSelection && (selectedElement = ((TreeSelection)selection).getFirstElement()) instanceof IFile) {
                IPath path = ((IFile)selectedElement).getLocation();
                pathString = path.toOSString();
            }
            if (selection instanceof TextSelection) {
                IEditorPart ed = window.getActivePage().getActiveEditor();
                pathString = ed.getEditorInput() instanceof PathEditorInput ? ((PathEditorInput)ed.getEditorInput()).getPath().toString() : ResourceUtil.getFile((IEditorInput)ed.getEditorInput()).getLocation().toString();
            }
        }
        if (pathString.endsWith(".stp")) {
            return pathString;
        }
        return "";
    }
}

