/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.ide.actions;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPEditor;
import org.eclipse.linuxtools.systemtap.ui.editor.PathEditorInput;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.linuxtools.systemtap.ui.structures.TreeDefinitionNode;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class DefinitionAction
extends Action
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate {
    private IStructuredSelection selection = null;

    public DefinitionAction() {
        LogManager.logInfo((String)"initialized", (Object)((Object)this));
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        LogManager.logDebug((String)("Start run: action-" + action), (Object)((Object)this));
        if (!this.isEnabled()) {
            return;
        }
        Object o = this.selection.getFirstElement();
        if (!(o instanceof TreeDefinitionNode)) {
            return;
        }
        TreeDefinitionNode t = (TreeDefinitionNode)o;
        String filename = t.getDefinition();
        Path p = new Path(filename);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        PathEditorInput input = new PathEditorInput((IPath)p, window);
        try {
            IEditorPart editorPart = window.getActivePage().openEditor((IEditorInput)input, "org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPEditor");
            STPEditor editor = (STPEditor)editorPart;
            int line = t.getData().toString().startsWith("probe") ? this.probeFind(t, editor) : this.functionFind(t, editor);
            editor.jumpToLocation(++line, 0);
        }
        catch (PartInitException e) {
            LogManager.logCritical((String)("Exception run: " + e.getMessage()), (Object)((Object)this));
            e.printStackTrace();
        }
        LogManager.logDebug((String)"End run:", (Object)((Object)this));
    }

    private int functionFind(TreeDefinitionNode t, STPEditor editor) {
        String func = t.toString();
        int line = editor.find("function " + (func = func.substring(0, func.indexOf(40))));
        if (line < 0) {
            line = editor.find(func);
        }
        return Math.max(line, 0);
    }

    private int probeFind(TreeDefinitionNode t, STPEditor editor) {
        int line = editor.find("probe " + t.toString());
        if (line < 0) {
            line = editor.find(t.getData().toString());
        }
        if (line < 0) {
            line = editor.find(t.getData().toString().replace(" ", ""));
        }
        return Math.max(line, 0);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            LogManager.logDebug((String)("this.selection changed: oldValue: " + this.selection + " newValue: " + selection), (Object)((Object)this));
            this.selection = (IStructuredSelection)selection;
            Object o = this.selection.getFirstElement();
            if (o instanceof TreeDefinitionNode) {
                TreeDefinitionNode t = (TreeDefinitionNode)o;
                String s = t.getDefinition();
                if (s != null) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(false);
        }
    }

    public void dispose() {
        LogManager.logInfo((String)"disposing", (Object)((Object)this));
    }

    public void init(IWorkbenchWindow window) {
    }
}

