/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.ide.actions;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.Localization;
import org.eclipse.linuxtools.systemtap.ui.consolelog.dialogs.SelectServerDialog;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.ConsoleLogPlugin;
import org.eclipse.linuxtools.systemtap.ui.editor.PathEditorInput;
import org.eclipse.linuxtools.systemtap.ui.ide.actions.RunScriptBaseAction;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.ResourceUtil;

public class RunScriptAction
extends RunScriptBaseAction {
    public void run() {
        LogManager.logDebug((String)"Start run:", (Object)((Object)this));
        this.continueRun = true;
        if (!(this.getRunLocal() || ConsoleLogPlugin.getDefault().getPreferenceStore().getBoolean("rememberServer") || new SelectServerDialog(this.fWindow.getShell()).open())) {
            return;
        }
        super.run();
    }

    protected String getFilePath() {
        IEditorPart ed = this.fWindow.getActivePage().getActiveEditor();
        if (ed.getEditorInput() instanceof PathEditorInput) {
            return ((PathEditorInput)ed.getEditorInput()).getPath().toString();
        }
        return ResourceUtil.getFile((IEditorInput)ed.getEditorInput()).getLocation().toString();
    }

    protected boolean isValid() {
        IEditorPart ed = this.fWindow.getActivePage().getActiveEditor();
        if (this.isValidFile(ed) && this.isValidDirectory(this.getFilePath())) {
            return true;
        }
        return true;
    }

    private boolean isValidFile(IEditorPart ed) {
        if (ed == null) {
            String msg = MessageFormat.format(Localization.getString("RunScriptAction.NoScriptFile"), null);
            LogManager.logInfo((String)"Initializing", MessageDialog.class);
            MessageDialog.openWarning((Shell)this.fWindow.getShell(), (String)Localization.getString("RunScriptAction.Problem"), (String)msg);
            LogManager.logInfo((String)"Disposing", MessageDialog.class);
            return false;
        }
        if (ed.isDirty()) {
            ed.doSave((IProgressMonitor)new ProgressMonitorPart((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Layout)new FillLayout()));
        }
        return true;
    }
}

