/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.ide.actions;

import com.jcraft.jsch.JSchException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.Localization;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPEditor;
import org.eclipse.linuxtools.systemtap.ui.consolelog.ClientSession;
import org.eclipse.linuxtools.systemtap.ui.consolelog.ScpClient;
import org.eclipse.linuxtools.systemtap.ui.consolelog.Subscription;
import org.eclipse.linuxtools.systemtap.ui.consolelog.dialogs.SelectServerDialog;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.IErrorParser;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ScriptConsole;
import org.eclipse.linuxtools.systemtap.ui.ide.IDESessionSettings;
import org.eclipse.linuxtools.systemtap.ui.ide.structures.StapErrorParser;
import org.eclipse.linuxtools.systemtap.ui.ide.structures.TapsetLibrary;
import org.eclipse.linuxtools.systemtap.ui.structures.IPasswordPrompt;
import org.eclipse.linuxtools.systemtap.ui.structures.PasswordPrompt;
import org.eclipse.linuxtools.systemtap.ui.systemtapgui.preferences.EnvironmentVariablesPreferencePage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RunScriptBaseAction
extends Action
implements IWorkbenchWindowActionDelegate {
    protected boolean runLocal = false;
    protected boolean continueRun = true;
    protected String fileName = null;
    protected String tmpfileName = null;
    protected String serverfileName = null;
    protected IWorkbenchWindow fWindow;
    private IAction act;
    protected Subscription subscription;
    protected int SCRIPT_ID;
    protected ScriptConsole console;

    public void dispose() {
        this.fWindow = null;
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        if (this.isValid()) {
            if (!this.getRunLocal()) {
                try {
                    ScpClient scpclient = new ScpClient();
                    this.serverfileName = this.fileName.substring(this.fileName.lastIndexOf(47) + 1);
                    this.tmpfileName = "/tmp/" + this.serverfileName;
                    scpclient.transfer(this.fileName, this.tmpfileName);
                }
                catch (JSchException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            final String[] script = this.buildStandardScript();
            final String[] envVars = this.getEnvironmentVariables();
            if (this.continueRun) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (!RunScriptBaseAction.this.getRunLocal()) {
                            ScriptConsole console = ScriptConsole.getInstance((String)RunScriptBaseAction.this.serverfileName);
                            console.run(script, envVars, (IPasswordPrompt)new PasswordPrompt(IDESessionSettings.password), (IErrorParser)new StapErrorParser());
                        } else {
                            ScriptConsole console = ScriptConsole.getInstance((String)RunScriptBaseAction.this.fileName);
                            console.runLocally(script, envVars, (IPasswordPrompt)new PasswordPrompt(IDESessionSettings.password), (IErrorParser)new StapErrorParser());
                        }
                    }
                });
            }
        }
    }

    protected abstract String getFilePath();

    protected abstract boolean isValid();

    protected boolean isValidDirectory(String fileName) {
        this.fileName = fileName;
        if (IDESessionSettings.tapsetLocation.trim().length() == 0) {
            TapsetLibrary.getTapsetLocation(IDEPlugin.getDefault().getPreferenceStore());
        }
        if (fileName.contains(IDESessionSettings.tapsetLocation)) {
            String msg = MessageFormat.format(Localization.getString("RunScriptAction.TapsetDirectoryRun"), null);
            MessageDialog.openWarning((Shell)this.fWindow.getShell(), (String)Localization.getString("RunScriptAction.Error"), (String)msg);
            return false;
        }
        return true;
    }

    protected String[] buildScript() {
        return this.buildStandardScript();
    }

    protected String[] buildStandardScript() {
        ArrayList<String> cmdList = new ArrayList<String>();
        this.getImportedTapsets(cmdList);
        if (this.isGuru()) {
            cmdList.add("-g");
        }
        String[] script = this.finalizeScript(cmdList);
        return script;
    }

    protected void getImportedTapsets(ArrayList<String> cmdList) {
        IPreferenceStore preferenceStore = IDEPlugin.getDefault().getPreferenceStore();
        String[] tapsets = preferenceStore.getString("TapsetPreference").split(File.pathSeparator);
        if (tapsets != null && tapsets.length > 0 && tapsets[0].trim().length() > 0) {
            int i = 0;
            while (i < tapsets.length) {
                cmdList.add("-I");
                cmdList.add(tapsets[i]);
                ++i;
            }
        }
    }

    protected boolean isGuru() {
        try {
            File f = new File(this.fileName);
            FileReader fr = new FileReader(f);
            int curr = 0;
            int prev = 0;
            boolean front = false;
            boolean imbedded = false;
            boolean inLineComment = false;
            boolean inBlockComment = false;
            while (-1 != (curr = fr.read())) {
                if (!inLineComment && !inBlockComment && 37 == prev && 123 == curr) {
                    front = true;
                } else {
                    if (!inLineComment && !inBlockComment && 37 == prev && 125 == curr && front) {
                        imbedded = true;
                        break;
                    }
                    if (!inBlockComment && (47 == prev && 47 == curr || 35 == curr)) {
                        inLineComment = true;
                    } else if (!inLineComment && 47 == prev && 42 == curr) {
                        inBlockComment = true;
                    } else if (10 == curr) {
                        inLineComment = false;
                    } else if (42 == prev && 47 == curr) {
                        inBlockComment = false;
                    }
                }
                prev = curr;
            }
            fr.close();
            if (imbedded) {
                return true;
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        return false;
    }

    protected boolean createClientSession() {
        if (!ClientSession.isConnected() && new SelectServerDialog(this.fWindow.getShell()).open()) {
            this.subscription = new Subscription(this.fileName, this.isGuru());
        }
        return true;
    }

    protected String[] finalizeScript(ArrayList<String> cmdList) {
        String modname;
        String[] script = new String[cmdList.size() + 4];
        script[0] = "stap";
        script[script.length - 1] = !this.getRunLocal() ? this.tmpfileName : this.fileName;
        int i = 0;
        while (i < cmdList.size()) {
            script[i + 1] = cmdList.get(i).toString();
            ++i;
        }
        script[script.length - 3] = "-m";
        if (!this.getRunLocal()) {
            modname = this.serverfileName.substring(0, this.serverfileName.indexOf(46));
        } else {
            modname = this.fileName.substring(this.fileName.lastIndexOf(47) + 1);
            modname = modname.substring(0, modname.indexOf(46));
        }
        if (modname.indexOf(45) != -1) {
            modname = modname.substring(0, modname.indexOf(45));
        }
        script[script.length - 2] = modname;
        return script;
    }

    protected String[] getEnvironmentVariables() {
        return EnvironmentVariablesPreferencePage.getEnvironmentVariables();
    }

    public void selectionChanged(IAction act, ISelection select) {
        this.act = act;
        this.setEnablement(false);
        this.buildEnablementChecks();
    }

    private void buildEnablementChecks() {
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor() instanceof STPEditor) {
            this.setEnablement(true);
        }
    }

    private void setEnablement(boolean enabled) {
        this.act.setEnabled(enabled);
    }

    protected Subscription getSubscription() {
        return this.subscription;
    }

    public void setLocalScript(boolean enabled) {
        this.runLocal = enabled;
    }

    public boolean getRunLocal() {
        return this.runLocal;
    }
}

