/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.statesystem;

import java.io.IOException;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.IStateHistoryBackend;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.StateSystem;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.StateSystemBuildRequest;
import org.eclipse.linuxtools.tmf.core.component.TmfComponent;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentRangeUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.core.signal.TmfStateSystemBuildCompleted;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateChangeInput;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateSystemBuilder;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateSystemQuerier;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;

public class HistoryBuilder
extends TmfComponent {
    private final IStateChangeInput sci;
    private final StateSystem ss;
    private final IStateHistoryBackend hb;
    private boolean started = true;

    public HistoryBuilder(IStateChangeInput stateChangeInput, IStateHistoryBackend backend, boolean buildManually) throws IOException {
        if (stateChangeInput == null || backend == null) {
            throw new IllegalArgumentException();
        }
        this.sci = stateChangeInput;
        this.hb = backend;
        this.ss = new StateSystem(this.hb, true);
        this.sci.assignTargetStateSystem(this.ss);
        if (buildManually) {
            TmfSignalManager.deregister(this);
            this.buildManually();
        } else {
            this.started = false;
        }
    }

    public static IStateSystemBuilder openExistingHistory(IStateHistoryBackend hb) throws IOException {
        return new StateSystem(hb, false);
    }

    public IStateSystemBuilder getStateSystemBuilder() {
        return this.ss;
    }

    public IStateSystemQuerier getStateSystemQuerier() {
        return this.ss;
    }

    private void buildManually() {
        StateSystemBuildRequest request = new StateSystemBuildRequest(this);
        this.sci.getTrace().sendRequest(request);
        try {
            request.waitForCompletion();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @TmfSignalHandler
    public void experimentRangeUpdated(TmfExperimentRangeUpdatedSignal signal) {
        if (!this.started) {
            this.started = true;
            StateSystemBuildRequest request = new StateSystemBuildRequest(this);
            TmfExperiment<?> exp = TmfExperiment.getCurrentExperiment();
            if (exp == null) {
                return;
            }
            exp.sendRequest(request);
        }
    }

    IStateChangeInput getInputPlugin() {
        return this.sci;
    }

    void close(boolean deleteFiles) {
        this.sci.dispose();
        if (deleteFiles) {
            this.hb.removeFiles();
        } else {
            TmfStateSystemBuildCompleted doneSig = new TmfStateSystemBuildCompleted((Object)this, this.sci.getTrace());
            TmfSignalManager.dispatchSignal(doneSig);
        }
        TmfSignalManager.deregister(this);
    }
}

