/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.ctfadaptor;

import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEventField;

final class CTFIntegerField
extends CtfTmfEventField {
    private final long longValue;
    private final int base;

    CTFIntegerField(long longValue, String name, int base) {
        super(name);
        this.longValue = longValue;
        this.base = base;
    }

    int getBase() {
        return this.base;
    }

    @Override
    public int getFieldType() {
        return 0;
    }

    @Override
    public Long getValue() {
        return this.longValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append('=');
        switch (this.base) {
            case 2: {
                sb.append("0b");
                sb.append(Long.toBinaryString(this.longValue));
                break;
            }
            case 8: {
                sb.append('0');
                sb.append(Long.toOctalString(this.longValue));
                break;
            }
            case 10: {
                sb.append(this.longValue);
                break;
            }
            case 16: {
                sb.append("0x");
                sb.append(Long.toHexString(this.longValue));
                break;
            }
            default: {
                sb.append(this.longValue);
            }
        }
        return sb.toString();
    }
}

