/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.launch.remote;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.linuxtools.internal.valgrind.launch.remote.Messages;
import org.eclipse.linuxtools.internal.valgrind.launch.remote.ValgrindRemoteLaunchConstants;
import org.eclipse.linuxtools.profiling.launch.remote.RemoteTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ValgrindRemoteTab
extends RemoteTab {
    private Text destDirText;
    private Text tmpDirText;
    private Text valgrindLocText;
    private boolean isInitializing;

    public ValgrindRemoteTab() {
        super(Messages.ValgrindRemoteTab_tab_name);
    }

    protected void localCreateControl(Composite top) {
        Composite pathTop = new Composite(top, 0);
        pathTop.setLayout((Layout)new GridLayout(2, false));
        pathTop.setLayoutData((Object)new GridData(4, 4, true, true));
        Label valgrindLocLabel = new Label(pathTop, 0);
        valgrindLocLabel.setText(Messages.ValgrindRemoteTab_label_location_VG);
        this.valgrindLocText = new Text(pathTop, 2048);
        this.valgrindLocText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.valgrindLocText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ValgrindRemoteTab.this.updateLaunchConfigurationDialog();
            }
        });
        Label destDirLabel = new Label(pathTop, 0);
        destDirLabel.setText(Messages.ValgrindRemoteTab_label_dest_wd);
        this.destDirText = new Text(pathTop, 2048);
        this.destDirText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.destDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ValgrindRemoteTab.this.updateLaunchConfigurationDialog();
            }
        });
        Label tmpDirLabel = new Label(pathTop, 0);
        tmpDirLabel.setText(Messages.ValgrindRemoteTab_label_tmp_dir);
        this.tmpDirText = new Text(pathTop, 2048);
        this.tmpDirText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.tmpDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ValgrindRemoteTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.remote.REMOTE_VALGRINDLOC", "/usr/bin/valgrind");
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.remote.REMOTE_DESTDIR", ValgrindRemoteLaunchConstants.DEFAULT_REMOTE_DESTDIR);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.remote.REMOTE_OUTPUTDIR", "/tmp");
    }

    public void localInitializeFrom(ILaunchConfiguration configuration) throws CoreException {
        String tmpDir;
        String destDir;
        String valgrindLoc = configuration.getAttribute("org.eclipse.linuxtools.valgrind.launch.remote.REMOTE_VALGRINDLOC", "/usr/bin/valgrind");
        if (valgrindLoc != null) {
            this.valgrindLocText.setText(valgrindLoc);
        }
        if ((destDir = configuration.getAttribute("org.eclipse.linuxtools.valgrind.launch.remote.REMOTE_DESTDIR", ValgrindRemoteLaunchConstants.DEFAULT_REMOTE_DESTDIR)) != null) {
            this.destDirText.setText(destDir);
        }
        if ((tmpDir = configuration.getAttribute("org.eclipse.linuxtools.valgrind.launch.remote.REMOTE_OUTPUTDIR", "/tmp")) != null) {
            this.tmpDirText.setText(tmpDir);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.remote.REMOTE_VALGRINDLOC", this.valgrindLocText.getText());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.remote.REMOTE_DESTDIR", this.destDirText.getText());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.remote.REMOTE_OUTPUTDIR", this.tmpDirText.getText());
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean valid = super.isValid(launchConfig);
        if (valid) {
            boolean bl = valid = this.valgrindLocText.getText().length() > 0;
            if (valid) {
                boolean bl2 = valid = this.destDirText.getText().length() > 0;
                if (valid) {
                    boolean bl3 = valid = this.tmpDirText.getText().length() > 0;
                    if (!valid) {
                        this.setErrorMessage(Messages.ValgrindRemoteTab_error_tmp_dir);
                    }
                } else {
                    this.setErrorMessage(Messages.ValgrindRemoteTab_error_dest_wd);
                }
            } else {
                this.setErrorMessage(Messages.ValgrindRemoteTab_error_location_VG);
            }
        } else {
            this.setErrorMessage(Messages.ValgrindRemoteTab_error_peer);
        }
        return valid;
    }

    public String getName() {
        return Messages.ValgrindRemoteTab_tab_name;
    }

    protected void updateLaunchConfigurationDialog() {
        if (!this.isInitializing) {
            super.updateLaunchConfigurationDialog();
        }
    }
}

