/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests.container;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.ContainerInfo;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.integration.tests.image.AbstractImageBotTest;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockDockerConnectionManager;
import org.eclipse.linuxtools.docker.reddeer.condition.ContainerIsDeployedCondition;
import org.eclipse.linuxtools.docker.reddeer.core.ui.wizards.ImageRunSelectionPage;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerImagesTab;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerInfoFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockImageFactory;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BasicSecurityTest
extends AbstractImageBotTest {
    private static final String IMAGE_NAME = "busybox";
    private static final String IMAGE_TAG = "latest";
    private static final String CONTAINER_NAME = "test_run_busybox";

    @Before
    public void before() throws DockerException, InterruptedException {
        BasicSecurityTest.deleteAllConnections();
        this.getConnection();
        this.pullImage(IMAGE_NAME, IMAGE_TAG);
    }

    @Test
    public void testBasicSecurity() {
        DockerImagesTab imagesTab = this.openDockerImagesTab();
        imagesTab.runImage("busybox:latest");
        ImageRunSelectionPage firstPage = new ImageRunSelectionPage((ReferencedComposite)imagesTab);
        firstPage.setContainerName(CONTAINER_NAME);
        firstPage.setAllocatePseudoTTY();
        firstPage.setKeepSTDINOpen();
        firstPage.setBasicSecurity();
        firstPage.finish();
        if (this.mockitoIsUsed()) {
            this.runContainer();
            this.getConnection().refresh();
            new WaitUntil((WaitCondition)new ContainerIsDeployedCondition(CONTAINER_NAME, this.getConnection()));
        }
        new WaitWhile((WaitCondition)new JobIsRunning());
        PropertySheet propertiesView = this.openPropertiesTabForContainer("Inspect", CONTAINER_NAME);
        String readonlyProp = propertiesView.getProperty(new String[]{"HostConfig", "ReadonlyRootfs"}).getPropertyValue();
        Assert.assertTrue((String)"Container is not running read-only!", (boolean)readonlyProp.equals("true"));
        String tmpfsProp = propertiesView.getProperty(new String[]{"HostConfig", "Tmpfs", "/run"}).getPropertyValue();
        Assert.assertTrue((String)"Container /run is not tmpfs rw,exec!", (boolean)tmpfsProp.equals("rw,exec"));
        tmpfsProp = propertiesView.getProperty(new String[]{"HostConfig", "Tmpfs", "/tmp"}).getPropertyValue();
        Assert.assertTrue((String)"Container /tmp is not tmpfs rw,exec!", (boolean)tmpfsProp.equals("rw,exec"));
        String capDropProp = propertiesView.getProperty(new String[]{"HostConfig", "CapDrop", ""}).getPropertyValue();
        Assert.assertTrue((String)"Container does not have capDrop all!", (boolean)capDropProp.equals("all"));
    }

    @Override
    @After
    public void after() {
        this.deleteContainerIfExists(CONTAINER_NAME);
    }

    private void runContainer() {
        DockerClient client = MockDockerClientFactory.container((Container)MockContainerFactory.name((String)CONTAINER_NAME, (String[])new String[0]).status("Stopped").build(), (ContainerInfo)MockContainerInfoFactory.link((String)"busybox:latest").id("TestTestTestTestTest").ipAddress("127.0.0.1").build()).image(MockImageFactory.id((String)"987654321abcde").name("fnichol/uhttpd:latest", new String[0]).build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from((String)"default", (DockerClient)client).withDefaultTCPConnectionSettings();
        MockDockerConnectionManager.configureConnectionManager(new IDockerConnection[]{dockerConnection});
    }
}

