/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests.container;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.ContainerInfo;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.integration.tests.image.AbstractImageBotTest;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockDockerConnectionManager;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockDockerTerminal;
import org.eclipse.linuxtools.docker.reddeer.condition.ContainerIsDeployedCondition;
import org.eclipse.linuxtools.docker.reddeer.core.ui.wizards.ImageRunSelectionPage;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerImagesTab;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerTerminal;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerInfoFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockImageFactory;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.condition.ConsoleHasNoChange;
import org.eclipse.reddeer.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LinkContainersTest
extends AbstractImageBotTest {
    private static final String IMAGE_ALPINE_CURL = "byrnedo/alpine-curl";
    private static final String CONTAINER_NAME_HTTP_SERVER = "test_run_httpd";
    private static final String CONTAINER_NAME_CLIENT_ALPINE = "test_connect_httpd";

    @Before
    public void before() {
        LinkContainersTest.deleteAllConnections();
        this.getConnection();
        this.pullImage(IMAGE_ALPINE_CURL);
        this.pullImage("fnichol/uhttpd");
    }

    private ImageRunSelectionPage openImageRunSelectionPage(String containerName, boolean publishAllExposedPorts, DockerImagesTab imagesTab) {
        ImageRunSelectionPage page = new ImageRunSelectionPage((ReferencedComposite)imagesTab);
        page.setContainerName(containerName);
        page.setPublishAllExposedPorts(publishAllExposedPorts);
        return page;
    }

    @Test
    public void testLinkContainers() {
        this.runUhttpServer("fnichol/uhttpd", CONTAINER_NAME_HTTP_SERVER);
        this.runAlpineLinux(IMAGE_ALPINE_CURL, CONTAINER_NAME_CLIENT_ALPINE);
    }

    public void runUhttpServer(String imageName, String containerName) {
        DockerImagesTab imagesTab = this.openDockerImagesTab();
        imagesTab.runImage(imageName);
        ImageRunSelectionPage firstPage = this.openImageRunSelectionPage(containerName, false, imagesTab);
        firstPage.setContainerName(containerName);
        firstPage.setPublishAllExposedPorts(false);
        firstPage.finish();
        if (this.mockitoIsUsed()) {
            this.mockServerContainer();
            new WaitUntil((WaitCondition)new ContainerIsDeployedCondition(containerName, this.getConnection()));
        } else {
            new WaitWhile((WaitCondition)new JobIsRunning());
            new WaitWhile((WaitCondition)new ConsoleHasNoChange());
        }
    }

    public void runAlpineLinux(String imageName, String containerName) {
        String terminalText;
        String serverAddress = this.getHttpServerAddress(CONTAINER_NAME_HTTP_SERVER);
        DockerImagesTab imagesTab = this.openDockerImagesTab();
        imagesTab.runImage(imageName);
        ImageRunSelectionPage firstPage = this.openImageRunSelectionPage(containerName, false, imagesTab);
        firstPage.setContainerName(containerName);
        firstPage.setCommand(String.valueOf(serverAddress) + ":80");
        firstPage.addLinkToContainer(CONTAINER_NAME_HTTP_SERVER, "http_server");
        firstPage.setPublishAllExposedPorts(false);
        firstPage.setAllocatePseudoTTY();
        firstPage.setKeepSTDINOpen();
        firstPage.finish();
        new WaitWhile((WaitCondition)new JobIsRunning());
        DockerTerminal dt = new DockerTerminal();
        dt.open();
        if (this.mockitoIsUsed()) {
            this.mockServerContainer();
            dt = MockDockerTerminal.setText("text").build();
        }
        Assert.assertTrue((String)"No output from terminal!", (!(terminalText = dt.getTextFromPage("/" + containerName)).isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Containers are not linked!", (!terminalText.contains("Connection refused") ? 1 : 0) != 0);
    }

    private String getHttpServerAddress(String containerName) {
        PropertySheet propertiesView = new PropertySheet();
        propertiesView.open();
        this.getConnection().getContainer(containerName).select();
        propertiesView.selectTab("Inspect");
        return propertiesView.getProperty(new String[]{"NetworkSettings", "IPAddress"}).getPropertyValue();
    }

    @Override
    @After
    public void after() {
        this.deleteContainerIfExists(CONTAINER_NAME_CLIENT_ALPINE);
        this.deleteContainerIfExists(CONTAINER_NAME_HTTP_SERVER);
        this.deleteImageIfExists(IMAGE_ALPINE_CURL);
    }

    private void mockServerContainer() {
        DockerClient client = MockDockerClientFactory.container((Container)MockContainerFactory.name((String)CONTAINER_NAME_HTTP_SERVER, (String[])new String[0]).status("Stopped").build(), (ContainerInfo)MockContainerInfoFactory.link((String)"alpine").privilegedMode(true).id("TestServerTestServer").ipAddress("127.0.0.1").build()).image(MockImageFactory.id((String)"1a2b3c4d5e6f7g").name("fnichol/uhttpd:latest", new String[0]).build()).image(MockImageFactory.id((String)"1a2b3c4d5e6f7g").name("byrnedo/alpine-curl:latest", new String[0]).build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from((String)"default", (DockerClient)client).withDefaultTCPConnectionSettings();
        MockDockerConnectionManager.configureConnectionManager(new IDockerConnection[]{dockerConnection});
    }
}

