/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests.container;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.ContainerInfo;
import java.io.File;
import java.io.IOException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.integration.tests.image.AbstractImageBotTest;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockDockerConnectionManager;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockUtils;
import org.eclipse.linuxtools.docker.reddeer.condition.ContainerIsDeployedCondition;
import org.eclipse.linuxtools.docker.reddeer.core.ui.wizards.ImageRunResourceVolumesVariablesPage;
import org.eclipse.linuxtools.docker.reddeer.core.ui.wizards.ImageRunSelectionPage;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerImagesTab;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockContainerInfoFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerClientFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockDockerConnectionFactory;
import org.eclipse.linuxtools.internal.docker.ui.testutils.MockImageFactory;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.condition.ConsoleHasNoChange;
import org.eclipse.reddeer.eclipse.ui.browser.WebBrowserView;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VolumeMountTest
extends AbstractImageBotTest {
    private static final String CONTAINER_NAME = "test_mount_volumes";
    private static final String VOLUME_PATH = "resources/test-volumes";
    private static final String CONTAINER_PATH = "/www";
    private static final String INDEX_PAGE = "index.html";
    private static final String INDEX_PAGE_PATH = "resources/test-volumes/index.html";
    private static final String HOST_PORT = "80";

    @Before
    public void before() throws DockerException, InterruptedException {
        this.clearConsole();
        VolumeMountTest.deleteAllConnections();
        this.getConnection();
        this.pullImage("fnichol/uhttpd", "latest");
    }

    @Test
    public void testVolumeMount() throws IOException {
        DockerImagesTab imagesTab = this.openDockerImagesTab();
        imagesTab.runImage("fnichol/uhttpd:latest");
        ImageRunSelectionPage firstPage = new ImageRunSelectionPage((ReferencedComposite)imagesTab);
        firstPage.setContainerName(CONTAINER_NAME);
        firstPage.setPublishAllExposedPorts(true);
        firstPage.next();
        ImageRunResourceVolumesVariablesPage secondPage = new ImageRunResourceVolumesVariablesPage((ReferencedComposite)firstPage);
        String volumePath = new File(VOLUME_PATH).getCanonicalPath();
        secondPage.addDataVolumeToHost(CONTAINER_PATH, volumePath);
        secondPage.finish();
        new WaitWhile((WaitCondition)new JobIsRunning());
        if (!this.mockitoIsUsed()) {
            new WaitWhile((WaitCondition)new ConsoleHasNoChange());
        } else {
            this.runServer();
            new WaitUntil((WaitCondition)new ContainerIsDeployedCondition(CONTAINER_NAME, this.getConnection()));
        }
        String indexPage = this.getIndexPageContent();
        String indexPageResource = this.getResourceAsString(INDEX_PAGE_PATH);
        Assert.assertEquals((String)"resources/test-volumes/index.html wasnt mounted/displayed properly.", (Object)indexPage, (Object)indexPageResource);
    }

    private String getIndexPageContent() throws IOException {
        String containerIP = this.getContainerIP(CONTAINER_NAME);
        String url = "http://" + containerIP + ":" + HOST_PORT + "/" + INDEX_PAGE;
        WebBrowserView browserView = new WebBrowserView();
        browserView.open();
        if (this.mockitoIsUsed()) {
            browserView = MockUtils.getBrowserView(INDEX_PAGE_PATH, this.getResourceAsString(INDEX_PAGE_PATH));
        }
        browserView.openPageURL(url);
        return browserView.getText();
    }

    private void runServer() {
        DockerClient client = MockDockerClientFactory.container((Container)MockContainerFactory.name((String)CONTAINER_NAME, (String[])new String[0]).status("Stopped").build(), (ContainerInfo)MockContainerInfoFactory.link((String)"alpine").volume(VOLUME_PATH).id("TestTestTestTestTest").ipAddress("127.0.0.1").build()).image(MockImageFactory.id((String)"987654321abcde").name("fnichol/uhttpd:latest", new String[0]).build()).build();
        DockerConnection dockerConnection = MockDockerConnectionFactory.from((String)"default", (DockerClient)client).withDefaultTCPConnectionSettings();
        MockDockerConnectionManager.configureConnectionManager(new IDockerConnection[]{dockerConnection});
    }

    @Override
    @After
    public void after() {
        this.deleteContainerIfExists(CONTAINER_NAME);
    }
}

