/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests.image;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.eclipse.linuxtools.docker.integration.tests.image.AbstractImageBotTest;
import org.eclipse.linuxtools.docker.integration.tests.mock.MockUtils;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerImagesTab;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PushImageTest
extends AbstractImageBotTest {
    private static final String DOCKERFILE_FOLDER = "resources/test-variables";
    private static final String DOCKER_HUB_PASSWORD = "dockerHubPassword";
    private static final String DOCKER_HUB_EMAIL = "dockerHubEmail";
    private static final String DOCKER_HUB_USERNAME = "dockerHubUsername";
    private static final String IMAGE_NAME = "test_push";
    private static final String REGISTRY_ACCOUNT = String.valueOf(System.getProperty("dockerHubUsername")) + "@https://index.docker.io";
    private static String IMAGE_TAG = String.valueOf(System.getProperty("dockerHubUsername")) + "/variables";
    private String imageNewTag = "";
    private String dockerHubUsername = "";
    private String dockerHubEmail = "";
    private String dockerHubPassword = "";

    @Before
    public void before() {
        PushImageTest.deleteAllConnections();
        this.createConnection();
        this.checkCredentials();
        if (this.mockitoIsUsed()) {
            MockUtils.pullImage("default", IMAGE_NAME, this.imageNewTag);
            IMAGE_TAG = "test_push:/variables";
            this.getConnection().refresh();
        }
    }

    @Test
    public void pushImage() {
        DockerImagesTab imagesTab = this.openDockerImagesTab();
        this.buildImage(IMAGE_NAME, DOCKERFILE_FOLDER, imagesTab);
        this.assertConsoleSuccess();
        this.setUpRegister("https://index.docker.io", this.dockerHubEmail, this.dockerHubUsername, this.dockerHubPassword);
        PushImageTest.setSecureStorage("password");
        String seconds = String.valueOf(new Date().getTime());
        this.imageNewTag = String.valueOf(IMAGE_TAG) + ":" + seconds;
        this.addTagToImage(IMAGE_NAME, this.imageNewTag);
        if (!this.mockitoIsUsed()) {
            this.getConnection().getImage(IMAGE_TAG, seconds).pushImage(REGISTRY_ACCOUNT, false, false);
        }
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.VERY_LONG);
        this.deleteImage(IMAGE_TAG, seconds);
        this.pullImage(IMAGE_TAG, seconds, "https://index.docker.io");
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.VERY_LONG);
        Assert.assertTrue((String)"Image has not been pushed/pulled!", (boolean)this.imageIsDeployed(IMAGE_TAG));
    }

    private void checkCredentials() {
        this.dockerHubUsername = System.getProperty(DOCKER_HUB_USERNAME);
        this.dockerHubEmail = System.getProperty(DOCKER_HUB_EMAIL);
        this.dockerHubPassword = System.getProperty(DOCKER_HUB_PASSWORD);
        if (!this.mockitoIsUsed()) {
            Assert.assertFalse((String)("At least one of credentials is null or empty! dockerHubUsername:" + this.dockerHubUsername + " dockerHubEmail:" + this.dockerHubEmail + " dockerHubPassword:" + this.dockerHubPassword + " Aborting test..."), (StringUtils.isBlank((String)this.dockerHubUsername) || StringUtils.isBlank((String)this.dockerHubEmail) || StringUtils.isBlank((String)this.dockerHubPassword) ? 1 : 0) != 0);
        } else {
            this.dockerHubUsername = "user";
            this.dockerHubPassword = "password";
            this.dockerHubEmail = "some@email.com";
        }
    }

    @Override
    @After
    public void after() {
        this.deleteRegister("https://index.docker.io");
        this.deleteImageContainerAfter(this.imageNewTag);
        this.cleanUpWorkspace();
    }
}

