/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests.mock;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.exceptions.DockerCertificateException;
import org.eclipse.linuxtools.docker.core.EnumDockerConnectionState;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettings;
import org.eclipse.linuxtools.docker.core.IDockerImageInfo;
import org.eclipse.linuxtools.docker.core.IRegistryAccount;
import org.eclipse.linuxtools.internal.docker.core.DockerClientFactory;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.TCPConnectionSettings;
import org.eclipse.linuxtools.internal.docker.core.UnixSocketConnectionSettings;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class MockDockerConnection {
    public static Builder from(String name, DockerClient dockerClient) {
        return new Builder(name, dockerClient);
    }

    public static class Builder {
        private final DockerConnection.Builder connectionBuilder;
        private final DockerClient dockerClient;

        private Builder(String name, DockerClient dockerClient) {
            this.connectionBuilder = new DockerConnection.Builder().name(name);
            this.dockerClient = dockerClient;
        }

        public DockerConnection withUnixSocketConnectionSettings(String pathToSocket) {
            DockerConnection connection = (DockerConnection)Mockito.spy((Object)this.connectionBuilder.unixSocketConnection(new UnixSocketConnectionSettings(pathToSocket)));
            Builder.configureDockerClientFactory(connection, this.dockerClient);
            Builder.configureMockBehaviour(connection);
            return connection;
        }

        public DockerConnection withDefaultTCPConnectionSettings() {
            return this.withTCPConnectionSettings(null, null);
        }

        public DockerConnection withTCPConnectionSettings(String host, String pathToCerts) {
            DockerConnection connection = (DockerConnection)Mockito.spy((Object)this.connectionBuilder.tcpConnection(new TCPConnectionSettings(host, pathToCerts)));
            Builder.configureDockerClientFactory(connection, this.dockerClient);
            Builder.configureMockBehaviour(connection);
            return connection;
        }

        public DockerConnection withState(EnumDockerConnectionState state) {
            DockerConnection connection = this.withDefaultTCPConnectionSettings();
            Mockito.when((Object)connection.getState()).thenReturn((Object)state);
            return connection;
        }

        private static void configureMockBehaviour(DockerConnection connection) {
            IDockerImageInfo imageInfo = (IDockerImageInfo)Mockito.mock(IDockerImageInfo.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
            Mockito.when((Object)connection.getImageInfo(Matchers.anyString())).thenReturn((Object)imageInfo);
        }

        private static void configureDockerClientFactory(DockerConnection connection, DockerClient dockerClient) {
            DockerClientFactory dockerClientFactory = (DockerClientFactory)Mockito.mock(DockerClientFactory.class);
            connection.setDockerClientFactory(dockerClientFactory);
            try {
                Mockito.when((Object)dockerClientFactory.getClient((IDockerConnectionSettings)Matchers.any())).thenReturn((Object)dockerClient);
                Mockito.when((Object)dockerClientFactory.getClient((IDockerConnectionSettings)Matchers.any(), (IRegistryAccount)Matchers.any())).thenReturn((Object)dockerClient);
            }
            catch (DockerCertificateException dockerCertificateException) {
                // empty catch block
            }
        }
    }
}

