/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.integration.tests.ui;

import org.eclipse.linuxtools.docker.integration.tests.image.AbstractImageBotTest;
import org.eclipse.linuxtools.docker.reddeer.ui.DockerImagesTab;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.reddeer.swt.api.TableItem;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ImageTabTest
extends AbstractImageBotTest {
    @Before
    public void before() {
        this.clearConsole();
        ImageTabTest.deleteAllConnections();
        this.getConnection();
    }

    @Test
    public void testImageTab() {
        this.pullImage("hello-world");
        DockerImagesTab imageTab = new DockerImagesTab();
        imageTab.activate();
        imageTab.refresh();
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.DEFAULT);
        String idFromTable = "";
        String repoTagsFromTable = "";
        String createdFromTable = "";
        String sizeFromTable = "";
        for (TableItem item : imageTab.getTableItems()) {
            if (!item.getText(1).contains("hello-world")) continue;
            idFromTable = item.getText();
            repoTagsFromTable = item.getText(1);
            createdFromTable = item.getText(2);
            sizeFromTable = item.getText(3).replaceAll(".", "").replaceAll(" MB", "");
            item.click();
        }
        idFromTable = idFromTable.replace("sha256:", "");
        this.getConnection().getImage(this.getCompleteImageName("hello-world")).select();
        PropertySheet propertiesView = new PropertySheet();
        propertiesView.open();
        propertiesView.selectTab("Info");
        String idProp = propertiesView.getProperty(new String[]{"Id"}).getPropertyValue();
        String repoTagsProp = propertiesView.getProperty(new String[]{"RepoTags"}).getPropertyValue();
        String createdProp = propertiesView.getProperty(new String[]{"Created"}).getPropertyValue();
        String sizeProp = propertiesView.getProperty(new String[]{"VirtualSize"}).getPropertyValue();
        Assert.assertTrue((String)"Id in table and in Properties do not match!", (boolean)idProp.contains(idFromTable));
        Assert.assertTrue((String)"RepoTags in table and in Properties do not match!", (boolean)repoTagsProp.equals(repoTagsFromTable));
        Assert.assertTrue((String)"Created in table and in Properties do not match!", (boolean)createdProp.equals(createdFromTable));
        Assert.assertTrue((String)"Size in table and in Properties do not match!", (boolean)sizeProp.startsWith(sizeFromTable));
    }

    @Test
    public void testImageTabSearch() {
        this.pullImage("hello-world");
        DockerImagesTab imageTab = new DockerImagesTab();
        imageTab.activate();
        imageTab.refresh();
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.DEFAULT);
        imageTab.searchImage("aaa");
        Assert.assertTrue((String)"Search result is not 0!", (imageTab.getTableItems().size() == 0 ? 1 : 0) != 0);
        imageTab.searchImage("");
        Assert.assertTrue((String)"Search result is 0!", (imageTab.getTableItems().size() > 0 ? 1 : 0) != 0);
    }

    @Override
    @After
    public void after() {
        this.deleteImageContainerAfter("hello-world");
    }
}

