/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.reddeer.preferences;

import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.swt.impl.text.LabeledText;

public class RegistryAccountsPreferencePage
extends PreferencePage {
    public static final String SERVER_ADDRESS = "Server Address:";
    public static final String USERNAME = "Username:";
    public static final String EMAIL = "Email:";
    public static final String PASSWORD = "Password:";

    public RegistryAccountsPreferencePage(ReferencedComposite referenced) {
        super(referenced, new String[]{"Docker", "Registry Accounts"});
    }

    public RegistryAccountsPreferencePage() {
        super(null, new String[]{"Docker", "Registry Accounts"});
    }

    public void addRegistry(String serverAddress, String email, String userName, String password) {
        new PushButton("Add").click();
        new LabeledText(SERVER_ADDRESS).setText(serverAddress);
        new LabeledText(USERNAME).setText(userName);
        new LabeledText(EMAIL).setText(email);
        new LabeledText(PASSWORD).setText(password);
        new OkButton().click();
    }

    public void editRegistry(String serverAddress, String email, String userName, String password) {
        DefaultTable table = new DefaultTable();
        if (table.containsItem(serverAddress)) {
            table.select(new String[]{serverAddress});
            new PushButton("Edit").click();
            new LabeledText(SERVER_ADDRESS).setText(serverAddress);
            new LabeledText(USERNAME).setText(userName);
            new LabeledText(EMAIL).setText(email);
            new LabeledText(PASSWORD).setText(password);
            new PushButton("OK").click();
        }
    }

    public void removeRegistry(String serverAddress) {
        DefaultTable table = new DefaultTable();
        if (table.containsItem(serverAddress)) {
            table.select(new String[]{serverAddress});
            new PushButton("Remove").click();
        }
    }

    public void removeAllRegistries() {
        DefaultTable table = new DefaultTable();
        int i = 0;
        while (i < table.rowCount()) {
            table.select(new int[]{0});
            new PushButton("Remove").click();
            ++i;
        }
    }
}

